/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.util.Properties;

public class ValidateCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(ValidateCommand.class);

    public String getName() {
        return _resources.getString("validate.Name");
    }

    public String getDescription() {
        return _resources.getString("validate.Desc");
    }

    public String getUsage() {
        return _resources.getString("validate.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        if (this._args.size() == 0) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("wrong.argument"));
            return;
        }
        String connName = (String)this._args.elementAt(0);
        try {
            RaStatus returnObj;
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            if (this._args.size() > 1) {
                String propFileName = (String)this._args.elementAt(1);
                Properties props = this.getConfigProp(propFileName);
                _log.debug("RaCommand[DEBUG]:  validate: connName = " + connName + "props= " + RepraPropertyUtil.encProperties(props).toString());
                if (!this.isValidConnProp(props)) {
                    _log.error("RaCommand[ERROR]:  " + _resources.getString("validate.status.fail.2"));
                    return;
                }
                returnObj = raClient.validateConnection(connName, props);
            } else {
                _log.debug("RaCommand[DEBUG]:  validate: connName = " + connName);
                returnObj = raClient.validateConnection(connName);
            }
            if (returnObj == null || !(returnObj instanceof RaStatus)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            RaStatus raS = returnObj;
            _log.debug("RaCommand[DEBUG]:  raStatus Object = " + raS.toString());
            if (raS.getCode() == 0) {
                _log.info("RaCommand[INFO]:  Connection '" + connName + "'" + _resources.getString("validate.status.success"));
            } else if (raS.getCode() == 2) {
                _log.info("RaCommand[WARN]:  " + raS.getMessage());
            } else if (raS.getCode() == 4) {
                _log.error("RaCommand[ERROR]:  " + raS.getMessage());
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("validate.status.fail") + rae.getMessage());
        }
    }
}

