/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.QID;
import com.sybase.connector.repra.rep.RepHolderException;
import com.sybase.connector.repra.rep.Result;
import com.sybase.jdbc3.tds.SrvDataFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class DSIInfo
implements Serializable {
    Properties _props = null;
    private transient RaLogger _log = null;
    protected static final int QIDLENGTH = 36;
    private static transient SrvDataFormat[] _fixedFormat = new SrvDataFormat[]{new SrvDataFormat("origin", 56, 0, 0, null), new SrvDataFormat("origin_qid", 45, 0, 36, null), new SrvDataFormat("secondary_qid", 45, 0, 36, null)};
    private String _persistFile = null;
    private String _usedb = null;
    private int _lastOperSent = 0;
    private boolean _sendOnce = true;
    private Hashtable _qids = new Hashtable();

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    protected String getFile() {
        return this._persistFile;
    }

    protected void setSendOnce(boolean b) {
        this._sendOnce = b;
    }

    protected int getOperCount() {
        return this._lastOperSent;
    }

    protected void incrementOperCount() throws Exception {
        ++this._lastOperSent;
        if (this._sendOnce) {
            DSIInfo.flush(this);
        }
    }

    protected void keepOperCount() throws Exception {
        if (this._sendOnce) {
            DSIInfo.flush(this);
        }
    }

    protected boolean shouldSend(int i) {
        if (!this._sendOnce) {
            return true;
        }
        return i > this._lastOperSent;
    }

    protected void setDB(String db) {
        this._usedb = db;
    }

    protected String getDB() {
        return this._usedb;
    }

    private DSIInfo() {
    }

    private DSIInfo(String file) {
        this._persistFile = file;
    }

    protected String currentQidString(int dbid, int operCount) {
        Integer origdb = new Integer(dbid);
        QID qid = (QID)this._qids.get(origdb);
        QID newQid = QID.buildQID(qid, operCount);
        return QID.qidBytesToString(newQid._QID);
    }

    protected String lastQidString(int dbid) {
        Integer origdb = new Integer(dbid);
        QID qid = (QID)this._qids.get(origdb);
        byte[] qidBytes = qid == null ? QID.ZEROQID : qid._QID;
        return QID.qidBytesToString(qidBytes);
    }

    protected int setCommit(QID qid) throws Exception {
        this._qids.put(qid._origin, qid);
        if (qid._origin > 0) {
            this._lastOperSent = 0;
        }
        DSIInfo.flush(this);
        return qid._origin;
    }

    protected Result getCommit() {
        Result r = new Result();
        r._format = _fixedFormat;
        if (!this._qids.isEmpty()) {
            r._result = new Object[this._qids.size()][3];
            int i = 0;
            Enumeration e = this._qids.elements();
            while (e.hasMoreElements()) {
                QID qid = (QID)e.nextElement();
                r._result[i][0] = qid._origin;
                r._result[i][1] = qid._QID;
                r._result[i][2] = qid._SQID;
                ++i;
            }
        } else {
            r._result = null;
        }
        return r;
    }

    protected static DSIInfo input(String infile) throws Exception {
        File file = new File(infile);
        DSIInfo dsi = null;
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(file));
            Object o = is.readObject();
            if (!(o instanceof DSIInfo)) {
                throw new Exception("REPERR_DSIFileLoadError");
            }
            dsi = (DSIInfo)o;
        }
        catch (Exception e) {
            dsi = new DSIInfo(infile);
            DSIInfo.flush(dsi);
        }
        return dsi;
    }

    private static void flush(DSIInfo dsi) throws Exception {
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(dsi.getFile(), false));
            os.writeObject(dsi);
            os.close();
        }
        catch (IOException ioe) {
            String[] args = new String[]{dsi.getFile(), ioe.getMessage()};
            throw new RepHolderException((Throwable)ioe, "REPERR_DSIQIDFileWriteError", args);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        s.append("\nDSI persist file: " + this._persistFile);
        s.append("\nReplicate DB name: " + this._usedb);
        s.append("\nSend once mode: " + this._sendOnce);
        s.append("\nLast operation count: " + this._lastOperSent);
        s.append("\nQIDS: ");
        Enumeration e = this._qids.elements();
        while (e.hasMoreElements()) {
            QID qid = (QID)e.nextElement();
            s.append("\n" + qid);
        }
        return super.toString() + "\n" + s.toString();
    }
}

