/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.DSISession;
import com.sybase.connector.repra.rep.DataServer;
import com.sybase.connector.repra.rep.RepAdapterImpl;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepHolderException;
import com.sybase.connector.repra.rep.Result;
import com.sybase.jdbc3.tds.SrvCursor;
import com.sybase.jdbc3.tds.SrvDataInputStream;
import com.sybase.jdbc3.tds.SrvDbrpcToken;
import com.sybase.jdbc3.tds.SrvFormatToken;
import com.sybase.jdbc3.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc3.tds.SrvLoginToken;
import com.sybase.jdbc3.tds.SrvLogoutToken;
import com.sybase.jdbc3.tds.SrvProtocolException;
import com.sybase.jdbc3.tds.SrvReceiver;
import com.sybase.jdbc3.tds.SrvRequestListener;
import com.sybase.jdbc3.tds.SrvRowFormatToken;
import com.sybase.jdbc3.tds.SrvSession;
import com.sybase.jdbc3.tds.SrvTextImageData;
import com.sybase.jdbc3.tds.SrvTypeException;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.io.MalformedInputException;

public class DSIReceiver
extends SrvReceiver {
    private RaLogger _log = null;
    private static ConnectionContainer _connectionContainer = null;
    private static final String REPADAPTERSERVERID = "Repra";
    private int _port = 7000;
    private RepAdapterImpl _adapterImpl;
    private ServerSocket _srvSock = null;
    private Socket _inSock = null;
    private Hashtable _sessionSockets = new Hashtable();
    private int _ioErrorCount = 0;
    private boolean _shutdown = false;
    private String _controlCmd = "";
    private DataServer _server;
    private Hashtable _dsiSessions = new Hashtable();
    private Object _syncObject = new Object();
    private String _connectionName = "";
    private String _serverName = "";

    protected DSIReceiver() {
        super(REPADAPTERSERVERID);
    }

    protected void init(String connName, String dsiName, int dsiPort, DataServer server, RaLogger log) {
        this._log = log;
        this._port = dsiPort;
        this._server = server;
        this._serverName = dsiName;
        this._connectionName = connName;
        try {
            _connectionContainer = ConnectionContainer.getInstance();
        }
        catch (Exception anyex) {
            this._log.error("DSIReceiver.init.e1");
            anyex.printStackTrace();
        }
    }

    public void buildCursorResultSet(SrvSession a, SrvCursor b) {
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void setAdapter(RepAdapterImpl adapterImpl) {
        this._adapterImpl = adapterImpl;
    }

    public void run() {
        try {
            this._srvSock = new ServerSocket(this._port);
            this._srvSock.setSoTimeout(1500);
            _connectionContainer.setControl(this._connectionName, "RUNNING");
            this._log.debug("DSIReceiver.run.m1", (Object)this._serverName, String.valueOf(this._port));
        }
        catch (SocketException soex) {
            _connectionContainer.setControl(this._connectionName, "STOP");
            this._log.error("REPERR_RepBadServerSkt", (Object)this._serverName, (Object)String.valueOf(this._port), soex);
            return;
        }
        catch (IOException ioe) {
            _connectionContainer.setControl(this._connectionName, "STOP");
            this._log.error("REPERR_RepBadServerSkt", (Object)this._serverName, (Object)String.valueOf(this._port), ioe);
            return;
        }
        while (!this._shutdown) {
            try {
                try {
                    this._inSock = this._srvSock.accept();
                    if (this._shutdown) {
                        break;
                    }
                }
                catch (SocketTimeoutException tex) {
                    continue;
                }
                catch (IOException ioex) {
                    if (this._ioErrorCount == 0) {
                        this._log.warn("DSIReceiver.run.IOException", (Throwable)ioex);
                        ++this._ioErrorCount;
                        if (this._ioErrorCount == 10000) {
                            this._ioErrorCount = 0;
                        }
                    }
                    if (this._shutdown) break;
                    Thread.sleep(300L);
                    continue;
                }
                this.createSession(this._inSock);
            }
            catch (Exception ioe) {
                if (!this._shutdown) {
                    this._log.error("REPERR_RepBadClientSocket", (Throwable)ioe);
                    _connectionContainer.setControl(this._connectionName, "STOP");
                    continue;
                }
                _connectionContainer.setControl(this._connectionName, "STOP");
                return;
            }
        }
    }

    public synchronized SrvSession createSession(Socket socket) throws IOException {
        SrvSession s = new SrvSession(socket.getInputStream(), socket.getOutputStream(), false, false);
        s.addSrvRequestListener((SrvRequestListener)this);
        Thread t = new Thread((Runnable)s, "DSIReceiver");
        try {
            _connectionContainer.setThreadVector(this._connectionName, t);
        }
        catch (Exception anyex) {
            this._log.error("DSIReceiver.createSession.e1");
            anyex.printStackTrace();
        }
        Thread o = this._sessions.put(s, t);
        this._sessionSockets.put(s, socket);
        s.run();
        this._log.debug("DSIReceiver.createSession.m1");
        return s;
    }

    protected void destroy() {
        this._shutdown = true;
        Enumeration e = this._dsiSessions.keys();
        while (e.hasMoreElements()) {
            try {
                SrvSession s = (SrvSession)e.nextElement();
                this._log.debug("DSIReceiver.destroy.m1", this.getDSISession(s).sessionInfo());
                this.removeDSISession(s);
                try {
                    if (this._inSock != null && !this._inSock.isClosed()) {
                        this._inSock.shutdownInput();
                    }
                    if (this._inSock != null && !this._inSock.isClosed()) {
                        this._inSock.shutdownOutput();
                    }
                    this.removeSession(s);
                }
                catch (NullPointerException nullex) {
                    this._log.warn("DSIReceiver.destroy.m3");
                }
            }
            catch (Exception ee) {
                this._log.error("DSIReceiver.destroy.m2", (Throwable)ee);
            }
        }
        this.close();
        try {
            if (this._inSock != null) {
                this._inSock.close();
                this._inSock = null;
            }
        }
        catch (IOException ioe) {
            this._log.error("REPERR_RepBadClientSocket", (Throwable)ioe);
        }
        try {
            if (this._srvSock != null) {
                this._srvSock.close();
                this._srvSock = null;
            }
        }
        catch (IOException ioe) {
            this._log.error("REPERR_RepBadClientSocket", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDSISession(SrvSession s, DSISession d) {
        Object object = this._syncObject;
        synchronized (object) {
            this._dsiSessions.put(s, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDSISession(SrvSession s) {
        Object object = this._syncObject;
        synchronized (object) {
            this._dsiSessions.remove(s);
        }
    }

    public void removeSession(SrvSession s) {
        try {
            Socket clientSock = (Socket)this._sessionSockets.get(s);
            super.removeSession(s);
            clientSock.close();
            this._sessionSockets.remove(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getSessionCount() {
        return this._dsiSessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DSISession getDSISession(SrvSession s) {
        Object object = this._syncObject;
        synchronized (object) {
            return (DSISession)this._dsiSessions.get(s);
        }
    }

    public synchronized void connect(SrvSession s, SrvLoginToken lt) {
        try {
            boolean loginAccepted;
            boolean bl = loginAccepted = lt.getUser().equals(this._server.getRepAdapterLogin()) && lt.getPassword().equals(this._server.getRepAdapterPassword());
            if (!loginAccepted) {
                this._log.error("REPERR_RepBadLogin", this._serverName);
            }
            this.sendLogin(s, s.getClientCapability(), REPADAPTERSERVERID, loginAccepted, lt.getPacketSize());
        }
        catch (IOException ioe) {
            this._log.error("DSIReceiver.connect.m1", (Throwable)ioe);
            this.removeSession(s);
        }
        String info = new Integer(this.getSessionCount() + 1).toString() + lt.getUser() + lt.getHost().trim() + lt.getCharset() + lt.getLocale();
        DSISession d = new DSISession();
        d.init(s, info, this._server, this._log);
        d.setAdapter(this._adapterImpl);
        this.addDSISession(s, d);
        this._log.debug("DSIReceiver.connect.m2", d.sessionInfo());
    }

    public void handleLogin(SrvSession s, String user, String password, String host, String locale, int packetSize) {
    }

    public void handleLogin(SrvSession s, String user, String password, String host, String locale) {
    }

    public void handleLanguage(SrvSession s, String lang, Object[] params) {
        try {
            Result r = null;
            r = !lang.trim().startsWith("select 'yes'") && lang.trim().startsWith("select") ? this.handleGetTextPtr(s, lang) : (lang.trim().startsWith("writetext") ? this.handleWritetext(s, lang) : this.getDSISession(s).handleLanguage(lang.trim()));
            if (r.hasResults()) {
                try {
                    r._count = r.hasFormat() ? this.sendResults(s, r._format, r._result) : this.sendResults(s, r._header, r._result);
                    this.sendDone(s, r._count, !r.successful(), false, r._rpc);
                }
                catch (Exception e) {
                    this._log.error("DSIReceiver.handleLanguage.m2", (Object)lang, (Throwable)e);
                }
            }
            if (r.hasEvent()) {
                this.sendMessage(s, r.getErrorNum(), r._event, "", 1);
                this.sendDone(s, r._count, !r.successful(), false, r._rpc);
            }
            this.sendDone(s, r._count, !r.successful(), true, r._rpc);
            this._log.debug("DSIReceiver.handleLanguage.m1", r.toString());
            this._controlCmd = _connectionContainer.getControl(this._connectionName);
        }
        catch (Exception ioe) {
            this._log.error("DSIReceiver.handleLanguage.m2", (Object)lang, (Throwable)ioe);
        }
    }

    public synchronized void handleDisconnect(SrvSession s, SrvLogoutToken logout) {
        this.removeDSISession(s);
    }

    public synchronized void handleRPC(SrvSession s, SrvDbrpcToken rpc, Object[] params) {
        try {
            this.sendDone(s, 0, true, true, false);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void handleBulk(SrvSession s, SrvDataInputStream is) {
        Result r = new Result();
        try {
            this.getDSISession(s).handleBulk(is);
        }
        catch (Exception ioe) {
            this._log.error("DSIReceiver.handleBulk.m1", (Throwable)ioe);
            r._event = "Error in DSIReceiver::handleBulk. Exception: " + ioe;
            r.setErrorType(2);
        }
        try {
            if (r.hasEvent()) {
                this.sendMessage(s, r.getErrorNum(), r._event, "", 1);
                this.sendDone(s, r._count, !r.successful(), false, r._rpc);
            }
            this.sendDone(s, r._count, !r.successful(), true, r._rpc);
        }
        catch (IOException ioe) {
            this._log.error("DSIReceiver.handleBulk.m2", (Throwable)ioe);
        }
    }

    public synchronized void handleAttention(SrvSession s) {
        try {
            s.sendAttention();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void handleError(SrvSession s, IOException ioe) {
        Result r = new Result();
        if (ioe instanceof EOFException) {
            this._log.error("DSIReceiver.handleError.m1", (Object)s.toString(), (Throwable)ioe);
            super.handleError(s, ioe);
        } else if (ioe instanceof SrvProtocolException) {
            this._log.error("DSIReceiver.handleError.m2", (Throwable)ioe);
            super.handleError(s, ioe);
        } else if (ioe instanceof SrvTypeException) {
            this._log.error("DSIReceiver.handleError.m3", (Throwable)ioe);
            super.handleError(s, ioe);
        } else if (ioe instanceof MalformedInputException) {
            this._log.error("DSIReceiver.handleError.m4", (Throwable)ioe);
            try {
                this.sendMessage(s, 1, "Rep_Err_EVT_DELIV", "", 1);
                this.sendDone(s, r._count, !r.successful(), true, r._rpc);
            }
            catch (Exception anyex) {
                this._log.error("DSIReceiver.handleError:" + anyex.getMessage());
            }
        } else {
            this._log.error("DSIReceiver.handleError.m5", (Object)ioe.getClass().getName(), (Throwable)ioe);
        }
        if (!(ioe instanceof MalformedInputException)) {
            // empty if block
        }
    }

    private void close() {
        this._shutdown = true;
        try {
            Socket s = new Socket(InetAddress.getLocalHost().getHostName(), this._port);
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Result handleGetTextPtr(SrvSession s, String statement) {
        Result r = new Result();
        try {
            RepEvent re = this.getDSISession(s).handleGetTextPtr(statement);
            SrvRowFormatToken srvRowfmt = new SrvRowFormatToken();
            SrvJavaTypeFormatter formatter = new SrvJavaTypeFormatter((SrvFormatToken)srvRowfmt, s.getClientCapability());
            byte[] txtptr = new byte[16];
            for (int i = 0; i < 16; ++i) {
                txtptr[i] = 0;
            }
            Object[] o = new Object[1];
            byte[] data = new byte[]{0};
            SrvTextImageData textImageData = new SrvTextImageData(txtptr, System.currentTimeMillis(), data);
            textImageData.setTableName(re.getName());
            String colName = re.getColumns().getName(0);
            formatter.addFormat((Object)textImageData, colName, null, null, re.getName(), re.getName(), 48, 0);
            o[0] = textImageData;
            Object[][] rows = new Object[][]{o};
            this._log.debug("DSIReceiver.handleGetTextPtr.m1");
            r._count = this.sendResults(s, (SrvFormatToken)srvRowfmt, rows);
        }
        catch (IOException ioe) {
            this._log.error("DSIReceiver.handleGetTextPtr.m2", (Object)statement, (Throwable)ioe);
            r._event = "Unknown problem in handleGetTextPtr for command: " + statement + " ,Exception: " + ioe.getMessage();
        }
        catch (Exception ue) {
            this._log.error("DSIReceiver.handleGetTextPtr.m2", (Object)statement, (Throwable)ue);
            r._event = ue instanceof RepHolderException ? ue.getMessage() + " : " + statement : ue + " " + statement;
            this._log.error("DSIReceiver.handleGetTextPtr.m2", (Object)statement, (Throwable)ue);
            r.setErrorType(2);
        }
        return r;
    }

    private Result handleWritetext(SrvSession s, String statement) {
        Result r = new Result();
        try {
            this.getDSISession(s).handleWritetext(statement);
        }
        catch (Exception ioe) {
            this._log.error("DSIReceiver.handleWritetext.m1", (Object)statement, (Throwable)ioe);
            r._event = "Unexpected problem in handleWritetext. Exception: " + ioe;
            r.setErrorType(2);
        }
        return r;
    }
}

