/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepEventStream;
import com.sybase.connector.repra.rep.RepMetaConnection;
import com.sybase.connector.repra.rep.RepMetaData;
import com.sybase.connector.repra.rep.ReplicateDB;
import com.sybase.connector.repra.rep.RepraProcessor;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class DataServer {
    RaLogger _log = null;
    private static final String CURRENT_RSSD_VERSION = "rs_configure current_rssd_version";
    private String _dsiName = "repra";
    private String _url = "jdbc:sybase:Tds:localhost:4100/localhost_rs_RSSD";
    private String _sqlInitStr = "set quoted_identifier off";
    private int _dsiPort = 7000;
    private String _rssdLogin = "sa";
    private String _rssdPassword = "";
    private String _adapterLogin = "sa";
    private String _adapterPassword = "";
    private boolean _sendOnce = true;
    private boolean _requiredGroup = true;
    private String _logLevel = "INFO";
    private RepraProcessor _listener = null;
    private Hashtable _replicateDBs = new Hashtable();
    private String _charset = "iso_1";
    private String _locale = null;
    private String _order = "bin_iso_1";
    private RepMetaConnection _conn = null;
    private Properties _props = null;

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    protected void setDSIName(String name) {
        this._dsiName = name;
    }

    protected String getDSIName() {
        return this._dsiName;
    }

    protected void setRequiredGroup(boolean b) {
        this._requiredGroup = b;
    }

    protected boolean getRequiredGroup() {
        return this._requiredGroup;
    }

    protected void setRSSDURL(String url) {
        this._url = url;
    }

    protected String getRSSDURL() {
        return this._url;
    }

    protected void setSQLINITSTR(String initStr) {
        this._sqlInitStr = initStr;
    }

    protected String getSQLINITSTR() {
        return this._sqlInitStr;
    }

    protected void setRepAdapterLogin(String login) {
        this._adapterLogin = login;
    }

    protected void setRSSDLogin(String login) {
        this._rssdLogin = login;
    }

    protected String getRSSDLogin() {
        return this._rssdLogin;
    }

    protected String getRepAdapterLogin() {
        return this._adapterLogin;
    }

    protected void setRSSDPassword(String password) {
        this._rssdPassword = password;
    }

    protected void setRepAdapterPassword(String password) {
        this._adapterPassword = password;
    }

    protected String getRSSDPassword() {
        return this._rssdPassword;
    }

    protected String getRepAdapterPassword() {
        return this._adapterPassword;
    }

    protected void setDSIPort(int dsiPort) {
        this._dsiPort = dsiPort;
    }

    protected int getDSIPort() {
        return this._dsiPort;
    }

    protected void setCharset(String csname) {
        this._charset = csname;
    }

    protected String getCharset() {
        return this._charset;
    }

    protected void setLocale(String locale) {
        this._locale = locale;
    }

    protected String getLocale() {
        return this._locale;
    }

    private void setProperties(Properties props) {
        this._props = props;
        this.setDSIName(props.getProperty("DSIName"));
        this.setRSSDURL(props.getProperty("RSSDURL"));
        this.setSQLINITSTR(props.getProperty("SQLINITSTR"));
        this.setRSSDLogin(props.getProperty("RSSDLogin"));
        this.setRSSDPassword(props.getProperty("RSSDPassword"));
        this.setDSIPort(Integer.parseInt(props.getProperty("DSIPort")));
        this.setRequiredGroup(new Boolean(props.getProperty("RequiredGroup")));
        this.setRepAdapterLogin(props.getProperty("RepAdapterLogin"));
        this.setRepAdapterPassword(props.getProperty("RepAdapterPassword"));
    }

    public Properties getProperties() {
        return this._props;
    }

    private void setSortOrder(String order) {
        this._order = order;
    }

    public String getSortOrder() {
        return this._order;
    }

    protected DataServer() {
    }

    protected void init(Properties props, RepraProcessor listener, RaLogger log) throws Exception {
        this._log = log;
        this.setProperties(props);
        String urlWithInitStr = this._url;
        if (this._sqlInitStr != null) {
            urlWithInitStr = urlWithInitStr + "?SQLINITSTR=" + this._sqlInitStr;
        }
        this._conn = new RepMetaConnection();
        this._conn.initMetaConnection(this._props.getProperty("ConnectionName"), urlWithInitStr, this._rssdLogin, this._rssdPassword, this._log);
        this._listener = listener;
        File dir = new File(RepraPropertyUtil.getSerDir());
        File parent = new File(RepraPropertyUtil.getRepraDir());
        if (parent.isDirectory() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        RepMetaData meta = new RepMetaData(this._dsiName, this._conn);
        meta.setLogger(this._log);
        Vector dbnames = meta.findReplicateDBs(this._dsiName);
        if (dbnames.size() != 0) {
            String dbname = "";
            for (int i = 0; i < dbnames.size(); ++i) {
                dbname = (String)dbnames.elementAt(i);
                this.loadReplicate(dbname);
            }
        }
    }

    protected void shutdown() {
        if (this._conn != null) {
            this._conn.close();
        }
        if (this._replicateDBs != null) {
            this._replicateDBs.clear();
        }
    }

    protected ReplicateDB loadReplicate(String db) throws Exception {
        RepMetaData meta;
        if (this.findReplicateDB(db) != null) {
            Object[] params = new String[]{this._dsiName, db};
            if (this._log.isInfo()) {
                this._log.info("DataServer.loadReplicate.m1", params);
            }
        }
        if (!(meta = new RepMetaData(this._dsiName, this._conn)).load(db)) {
            this._log.error("DataServer.loadReplicate.m2");
        } else {
            this._log.debug("DataServer.loadReplicate.m3");
        }
        RepEventStream stream = new RepEventStream();
        stream.init(this._props, meta, this._log);
        boolean atLeastOne = false;
        stream.addListener(this._listener);
        atLeastOne = true;
        this._log.debug("DataServer.loadReplicate.m4");
        ReplicateDB rdb = new ReplicateDB();
        rdb.init(db, stream, RepraPropertyUtil.getSerDir() + File.separator + "DSI_" + this._dsiName + "_" + db + ".ser", this._sendOnce, this._requiredGroup, this._log);
        rdb.setExists(meta.exists(db));
        this._replicateDBs.put(db, rdb);
        this._log.debug("DataServer.loadReplicate.m5");
        return rdb;
    }

    protected ReplicateDB findReplicateDB(String db) {
        return (ReplicateDB)this._replicateDBs.get(db);
    }

    protected synchronized boolean testConnection() throws Exception {
        RepMetaConnection rmc = this._conn;
        if (rmc == null) {
            Exception ex = new Exception("No Connection established.");
            this._log.error("DataServer.testConnection.m1", (Throwable)ex);
            throw ex;
        }
        Connection con = null;
        try {
            con = rmc.getConnection();
            if (con == null) {
                this._log.debug("DataServer.testConnection.m2");
            }
            if (con.isClosed()) {
                this._log.debug("DataServer.testConnection.m3");
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.createStatement();
                rs = stmt.executeQuery(CURRENT_RSSD_VERSION);
                if (!rs.next()) {
                    this._log.debug("DataServer.testConnection.m4");
                } else {
                    this._log.debug("DataServer.testConnection.m5");
                }
            }
            catch (SQLException sqe) {
                this._log.debug("DataServer.testConnection.m6", (Throwable)sqe);
                throw sqe;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqe) {}
            }
        }
        catch (SQLException sqe) {
            this._log.error("DataServer.testConnection.m6", (Throwable)sqe);
            throw sqe;
        }
        this._log.debug("DataServer.testConnection.m7");
        return true;
    }
}

