/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepTransactionFormatter;
import com.sybase.connector.repra.rep.RepValue;
import com.sybase.connector.repra.rep.RepraException;
import java.util.Properties;
import java.util.Vector;

public class PropertyVectorFormatter
implements RepTransactionFormatter {
    public static final int METADATA = 0;
    public static final int COLUMNDATA = 1;
    public static final int WHERE = 2;
    private RaLogger _log = null;

    public boolean requiresMetaData() {
        return true;
    }

    public boolean requiresParse() {
        return true;
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public Object format(RepEvent rse) throws RepraException {
        int j;
        Vector<Object> propVector = new Vector<Object>(3);
        Properties props = new Properties();
        props.setProperty("RepEventContainer.CONNECTION_NAME", rse.getDsName());
        props.setProperty("RepEventContainer.OPERATION", rse.getOperation());
        props.setProperty("RepEventContainer.DATABASE_NAME", rse.getDbName());
        props.setProperty("RepEventContainer.TABLE_NAME", rse.getName());
        RepValue val = rse.getColumns();
        props.setProperty("RepEventContainer.COLUMNS", Integer.toString(val.size()));
        propVector.add(0, props.clone());
        props.clear();
        if (val.size() > 0) {
            for (j = 0; j < val.size(); ++j) {
                props.setProperty(val.getName(j), "[" + val.getType(j) + "]" + val.getLiteral(j, 2));
            }
            if (props.size() > 0) {
                propVector.add(1, props.clone());
                props.clear();
            }
        }
        propVector.add(props.clone());
        props.clear();
        val = rse.getWhere();
        if (val.size() > 0) {
            for (j = 0; j < val.size(); ++j) {
                props.setProperty(val.getName(j), "[" + val.getType(j) + "]" + val.getLiteral(j, 2));
            }
            if (props.size() > 0) {
                propVector.add(2, props.clone());
            }
        }
        return propVector;
    }

    public Object formatTransaction(RepEvent[] rse) throws RepraException {
        Vector<Vector> groupContainer = new Vector<Vector>();
        for (int pos = 0; pos < rse.length; ++pos) {
            Vector propVector = (Vector)this.format(rse[pos]);
            groupContainer.add(propVector);
        }
        return groupContainer;
    }
}

