/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.RepraAdapter;
import com.sybase.connector.repra.RepraClient;
import com.sybase.connector.repra.RepraCustomClient;
import com.sybase.connector.repra.RepraJmsClient;
import com.sybase.connector.repra.jms.JMSQueueClient;
import com.sybase.connector.repra.jms.JMSTopicClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.mq.MQBase;
import com.sybase.connector.repra.mq.MQClient;
import com.sybase.connector.repra.mq.MQJMSQueueClient;
import com.sybase.connector.repra.mq.MQJMSTopicClient;
import com.sybase.connector.repra.rep.DSIReceiver;
import com.sybase.connector.repra.rep.DataServer;
import com.sybase.connector.repra.rep.RepraProcessor;
import com.sybase.connector.repra.tibrv.TIBAECMClient;
import com.sybase.connector.repra.tibrv.TIBRVCMClient;
import com.sybase.connector.repra.tibrv.TIBRVClient;
import java.io.File;
import java.util.Properties;

public class RepAdapterImpl
extends Thread
implements RepraAdapter {
    private RaLogger _log = null;
    private DSIReceiver _jtds = null;
    private DataServer _server = null;
    RepraProcessor _processor = null;
    private final String DSI_TRACE_DIR = "../repra/trace/";
    protected Properties _props = null;
    private RepraClient _repClient = null;
    private String _protocol = "JMS";
    public Object _finalMsg = null;
    public StringBuffer _newStatement = null;
    public StringBuffer _escapedText = null;
    public char[] _rawTextCharArray = null;
    private boolean _inTransaction = false;
    private String _dtdURL = "http://localhost:8000/RepraWebApp/dtds/dbeventstream.xsd";
    private String _eventId = "";
    private static ConnectionContainer _connectionContainer = null;

    public void setEventId(String eventId) {
        this._eventId = eventId;
    }

    public String getEventId() {
        return this._eventId;
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void setTransaction() {
        this._inTransaction = true;
    }

    public void resetTransaction() {
        this._inTransaction = false;
        this._finalMsg = null;
        this._newStatement = null;
        this._escapedText = null;
        this._rawTextCharArray = null;
        this._eventId = "";
    }

    public boolean getTransaction() {
        return this._inTransaction;
    }

    private void setClientConfig() {
        this._protocol = this._props.getProperty("OutboundType", "JMS");
    }

    public String getConnectionName() {
        return this._props.getProperty("ConnectionName");
    }

    public String getDSIName() {
        return this._props.getProperty("DSIName");
    }

    public int getDSIPort() {
        return Integer.valueOf(this._props.getProperty("DSIPort"));
    }

    public String getLogLevel() {
        return this._props.getProperty("LogLevel");
    }

    public boolean getRequiredGroup() {
        return this._props.getProperty("RequiredGroup").equalsIgnoreCase("true");
    }

    public boolean getMQ_LocalClient() {
        return this._props.getProperty("MQ_LocalClient").equalsIgnoreCase("true");
    }

    public String getDTD_URL() {
        return this._dtdURL;
    }

    public boolean getFormatterFlag() {
        return this._props.getProperty("FormatterFlag").equalsIgnoreCase("true");
    }

    public String getFormatterProps() {
        return this._props.getProperty("FormatterProperties", "");
    }

    public boolean getSenderFlag() {
        return this._props.getProperty("SenderFlag").equalsIgnoreCase("true");
    }

    public String getFormatterPlugin() {
        return this._props.getProperty("FormatterPlugin");
    }

    public String getSenderPlugin() {
        return this._props.getProperty("SenderPlugin");
    }

    public String getRepraDirectory() {
        return this._props.getProperty("RepraDirectory");
    }

    public RepAdapterImpl() {
    }

    public RepAdapterImpl(Properties props) {
        this._props = props;
        this._log = new RaLogger(this._props.getProperty("ConnectionName"), 0, this._props.getProperty("LogLevel", "INFO"));
        this.initAdapter();
    }

    private void initAdapter() {
        this._log.info("RepAdapterImpl.initAdapter.m1", this._props.getProperty("ConnectionName"));
        _connectionContainer = ConnectionContainer.getInstance();
        this.setClientConfig();
        this._server = new DataServer();
        this._dtdURL = this._props.getProperty("DTD_URL", "http://localhost:8000/RepraWebApp/dtds/dbeventstream.xsd");
    }

    public boolean testConnection() throws Exception {
        return this._server.testConnection();
    }

    public void run() {
        try {
            this.configure();
        }
        catch (Exception ee) {
            return;
        }
        _connectionContainer.setControl(this.getConnectionName(), "RUNNING");
        String dsiName = "";
        try {
            int dsiPort = Integer.parseInt(this._props.getProperty("DSIPort"));
            dsiName = this.getDSIName();
            this._jtds = new DSIReceiver();
            this._jtds.init(this.getConnectionName(), dsiName, dsiPort, this._server, this._log);
            this._jtds.setAdapter(this);
            this._jtds.run();
            this._log.debug("RepAdapterImpl.run.m3", (Object)dsiName, this._props.getProperty("DSIPort"));
        }
        catch (Exception ex) {
            this._log.error("RepAdapterImpl.run.e1", (Object)dsiName, (Object)this._props.getProperty("DSIPort"), ex);
            this.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void configure() throws Exception {
        block20: {
            String outboundType;
            block23: {
                block22: {
                    block21: {
                        outboundType = this._props.getProperty("OutboundType", "JMS");
                        if (!outboundType.equalsIgnoreCase("JMS")) break block21;
                        if (this._props.getProperty("JMSType", "queue").equals("queue")) {
                            this._repClient = new JMSQueueClient();
                            ((JMSQueueClient)this._repClient).init(this._props, this._log);
                            break block20;
                        } else if (this._props.getProperty("JMSType", "queue").equals("topic")) {
                            this._repClient = new JMSTopicClient();
                            ((JMSTopicClient)this._repClient).init(this._props, this._log);
                        }
                        break block20;
                    }
                    if (!outboundType.equalsIgnoreCase("IBMMQ")) break block22;
                    if (this._props.getProperty("MQType", "MQ").equals("MQJMS")) {
                        this._repClient = this._props.getProperty("JMSType", "queue").equalsIgnoreCase("queue") ? new MQJMSQueueClient() : new MQJMSTopicClient();
                        ((MQBase)this._repClient).initMQClient(this._props, this._log);
                        break block20;
                    } else {
                        this._repClient = new MQClient();
                        ((MQClient)this._repClient).initMQClient(this._props, this._log);
                    }
                    break block20;
                }
                if (!outboundType.equalsIgnoreCase("TIBCO")) break block23;
                if (this._props.getProperty("TIBType", "RV").equals("RVCM")) {
                    this._repClient = new TIBRVCMClient();
                    ((TIBRVCMClient)this._repClient).initRVCMClient(this._props, this._log);
                    break block20;
                } else if (this._props.getProperty("TIBType", "RV").equals("AECM")) {
                    this._repClient = new TIBAECMClient();
                    ((TIBAECMClient)this._repClient).initAECMClient(this._props, this._log);
                    break block20;
                } else {
                    this._repClient = new TIBRVClient();
                    ((TIBRVClient)this._repClient).initRV(this._props, this._log);
                }
                break block20;
            }
            if (!outboundType.equalsIgnoreCase("CUSTOM")) {
                this._log.error("RepAdapterImpl.configure.e2");
                throw new Exception(this._log.getResourceBundle().getString("RepAdapterImpl.configure.e2"));
            }
            String pluginName = this._props.getProperty("SenderPlugin", "");
            if (pluginName.equals("")) {
                this._log.error("RepAdapterImpl.configure.e1");
                throw new Exception(this._log.getResourceBundle().getString("RepAdapterImpl.configure.e1"));
            }
            try {
                this._repClient = (RepraClient)Class.forName(pluginName).newInstance();
                if (this._repClient instanceof RepraCustomClient) {
                    this._log.debug("RepAdapterImpl.configure.m7");
                    String propFile = this._props.getProperty("SenderProperties", "");
                    this._log.debug("RepAdapterImpl.configure.m9", propFile);
                    if (propFile != null && !propFile.equals("") && !new File(propFile).exists()) {
                        throw new Exception(this._log.getResourceBundle().getString("RepAdapterImpl.configure.e5"));
                    }
                    ((RepraCustomClient)this._repClient).setConfigProps(propFile);
                } else {
                    this._log.debug("RepAdapterImpl.configure.m8");
                }
                this._repClient.setLogger(this._log);
            }
            catch (Exception e) {
                this._log.error("RepAdapterImpl.configure.e3", (Object)pluginName, (Throwable)e);
                throw new Exception(this._log.getResourceBundle().getString("RepAdapterImpl.configure.es3"));
            }
        }
        try {
            this._repClient.configureClient();
            this._log.debug("RepAdapterImpl.configure.m3");
        }
        catch (Exception ex) {
            this._log.error("RepAdapterImpl.configure.m4");
            throw ex;
        }
        try {
            this._processor = new RepraProcessor();
            this._processor.init(this, this._log);
            this._server.init(this._props, this._processor, this._log);
            this._log.debug("RepAdapterImpl.configure.m5");
            return;
        }
        catch (Exception ex) {
            this._log.error("RepAdapterImpl.configure.m6", (Throwable)ex);
            throw ex;
        }
    }

    private void cleanup() {
        _connectionContainer.setControl(this.getConnectionName(), "STOP");
        this._server.shutdown();
        this._repClient.close();
        this._jtds.destroy();
        this._log.debug("RepAdapterImpl.shutdown.m1");
    }

    public boolean sendRepMessage() throws Exception {
        try {
            if (this._repClient instanceof RepraJmsClient) {
                ((RepraJmsClient)this._repClient).sendEvent(this._finalMsg, this._eventId);
            } else {
                this._repClient.sendEvent(this._finalMsg);
            }
            return true;
        }
        catch (Exception ex) {
            this._log.error("RepAdapterImpl.sendRepMessage.m1", (Throwable)ex);
            throw ex;
        }
    }

    public void close() {
        this._log.info("RepAdapterImpl.close.m1");
        this.cleanup();
    }

    public Properties getProperties() {
        return this._props;
    }

    public void setProperties(Properties props) {
        this._props = props;
        this.initAdapter();
    }
}

