/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepColumn;
import com.sybase.connector.repra.rep.RepHolderException;
import com.sybase.connector.repra.rep.RepMetaConnection;
import com.sybase.connector.repra.rep.RepTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class RepMetaData {
    private String _dsName = null;
    private String _dbName = null;
    private RaLogger _log = null;
    private RepMetaConnection _conn = null;
    private Hashtable _tables = null;
    private static final int SUBSCRIPTIONNAME = 0;
    private static final int SUBSCRIPTIONID = 1;
    private static final int REPOBJECTID = 2;
    private static final int TABLENAME = 3;
    private static final int REPLTABLENAME = 4;
    private static final int DBID = 5;
    private static final int OWNER = 6;
    private static final int NUM_METADATA_COLUMNS = 7;

    public RepMetaData(String dataServer, RepMetaConnection conn) {
        this._dsName = dataServer;
        this._conn = conn;
        Locale.setDefault(Locale.US);
        if (this._log == null) {
            this._log = new RaLogger(0);
        }
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public String getRSSDVersion() throws Exception {
        StringBuffer sb = new StringBuffer("");
        String query = "rs_configure current_rssd_version";
        ResultSet rs = this._conn.execute(this, query);
        try {
            while (rs.next()) {
                sb.append(rs.getString(2));
            }
            rs.close();
        }
        catch (SQLException sqe) {
            // empty catch block
        }
        return sb.toString();
    }

    public String getRepVersion() throws Exception {
        StringBuffer sb = new StringBuffer("");
        String query = "select distinct rs_sites.name, rs_version.* from rs_version, rs_sites, rs_databases where (rs_databases.dsname = '" + this._dsName + "') " + "and (rs_databases.prsid = rs_sites.id) " + "and (rs_sites.id = rs_version.siteid) ";
        ResultSet rs = this._conn.execute(this, query);
        try {
            while (rs.next()) {
                sb.append(" " + rs.getString(1) + ": '" + rs.getString(3) + "'");
            }
            rs.close();
        }
        catch (SQLException sqe) {
            // empty catch block
        }
        return sb.toString();
    }

    Vector findDataServers() throws Exception {
        Vector<String> ds = new Vector<String>();
        String query = "select distinct dsname from rs_databases";
        ResultSet rs = this._conn.execute(this, query);
        try {
            while (rs.next()) {
                ds.addElement(rs.getString(1));
            }
            rs.close();
        }
        catch (SQLException sqe) {
            String[] args = new String[]{query};
            throw new RepHolderException((Throwable)sqe, "REPERR_RepRSSDQueryError2", args);
        }
        return ds;
    }

    protected boolean exists(String dbName) throws Exception {
        String query = "select dsname, dbname from rs_databases where dsname = '" + this._dsName + "'" + " and dbname = '" + dbName + "'";
        ResultSet rs = this._conn.execute(this, query);
        int row = 0;
        try {
            while (rs.next()) {
                ++row;
            }
            rs.close();
        }
        catch (SQLException sqe) {
            String[] args = new String[]{query};
            throw new RepHolderException((Throwable)sqe, "REPERR_RepRSSDQueryError2", args);
        }
        return row != 0;
    }

    Vector findReplicateDBs(String dsname) throws Exception {
        Vector<String> dbs = new Vector<String>();
        String query = "select dbname from rs_databases where dsname = '" + dsname + "'";
        ResultSet rs = this._conn.execute(this, query);
        try {
            while (rs.next()) {
                dbs.addElement(rs.getString(1));
            }
        }
        catch (SQLException sqe) {
            String[] args = new String[]{query};
            throw new RepHolderException((Throwable)sqe, "REPERR_RepRSSDQueryError2", args);
        }
        return dbs;
    }

    public boolean load(String dbName) throws Exception {
        this._dbName = dbName;
        return this.load();
    }

    public synchronized boolean load() throws Exception {
        this._tables = new Hashtable();
        String rs_db_table_name = "rs_repdbs";
        if (this._log.getRemoteRepServer()) {
            rs_db_table_name = "rs_databases";
            this._log.debug(rs_db_table_name + " = " + this._log.getRemoteRepServer());
        }
        String query = "select distinct rs_objects.objname, rs_subscriptions.subid, rs_objects.objid, rs_objects.phys_tablename,  rs_objects.deliver_as_name, rs_objects.dbid, rs_objects.phys_objowner from " + rs_db_table_name + ", rs_subscriptions, rs_objects" + " where ((dsname = '" + this._dsName + "' and dbname = '" + this._dbName + "')" + " and " + rs_db_table_name + ".dbid = rs_subscriptions.dbid" + " and rs_subscriptions.type < 8" + " and rs_subscriptions.objid = rs_objects.objid) " + " union" + " select distinct rs_objects.objname, rs_subscriptions.subid," + " rs_objects.objid, rs_objects.phys_tablename, " + " rs_objects.deliver_as_name, rs_objects.dbid, rs_objects.phys_objowner" + " from " + rs_db_table_name + ", rs_articles, rs_subscriptions, rs_objects" + " where " + " ((dsname = '" + this._dsName + "' and dbname = '" + this._dbName + "')" + " and " + rs_db_table_name + ".dbid = rs_subscriptions.dbid" + " and rs_subscriptions.type > 8" + " and rs_articles.articleid = rs_subscriptions.objid" + " and rs_objects.objid = rs_articles.objid)";
        ResultSet rs = this._conn.execute(this, query);
        int row = 0;
        try {
            while (rs.next()) {
                ++row;
                String[] s = new String[7];
                for (int i = 0; i < 7; ++i) {
                    s[i] = i == 1 || i == 2 ? "0x" + rs.getString(i + 1) : rs.getString(i + 1);
                }
                if (s[4] != null && s[4].length() > 0) {
                    s[3] = s[4];
                }
                String fullName = s[3];
                if (s[6] != null && !s[6].trim().equals("")) {
                    fullName = s[6] + "." + fullName;
                }
                RepTable table = new RepTable(s[0], s[3], s[1], s[2], Integer.parseInt(s[5]));
                this._tables.put(fullName, table);
            }
        }
        catch (SQLException sqe) {
            String[] args = new String[]{query};
            throw new RepHolderException((Throwable)sqe, "REPERR_RepRSSDQueryError2", args);
        }
        catch (NumberFormatException nfe) {
            String[] args = new String[]{query};
            throw new RepHolderException((Throwable)nfe, "REPERR_RepRSSDQueryError2", args);
        }
        if (row == 0) {
            return false;
        }
        Enumeration e = this._tables.elements();
        while (e.hasMoreElements()) {
            RepTable t = (RepTable)e.nextElement();
            query = "select * from rs_columns where objid = " + t.getRepDefId() + " order by colnum";
            rs = this._conn.execute(this, query);
            row = 0;
            try {
                ++row;
                while (rs.next()) {
                    RepColumn col = new RepColumn(rs.getString(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(10), rs.getInt(11), rs.getInt(12), rs.getString(13));
                    t.addColumn(col);
                }
                rs.close();
            }
            catch (SQLException sqe) {
                throw new RepHolderException((Throwable)sqe, "REPERR_RepRSSDBadColData", null);
            }
            if (row != 0) continue;
            String[] args = new String[]{t.getSubscriptionName()};
            throw new RepHolderException(null, "REPWARN_RepRSSDNoColData", args);
        }
        return true;
    }

    public RepTable findTable(String name) throws Exception {
        RepTable tab = (RepTable)this._tables.get(name);
        if (tab == null) {
            String[] args = new String[]{name};
            throw new RepHolderException(null, "REPWARN_RepNoTableData", args);
        }
        return tab;
    }

    public String getDsName() throws Exception {
        return this._dsName;
    }

    public String getDbName() throws Exception {
        return this._dbName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        Enumeration e = this._tables.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement().toString());
        }
        return sb.toString();
    }

    public int getTableColumnType(String tableName, String columnName) throws Exception {
        RepTable tableMeta = this.findTable(tableName);
        RepColumn colMeta = tableMeta.getColumn(columnName);
        if (colMeta == null) {
            String[] args = new String[]{tableName + '.' + columnName};
            throw new RepHolderException(null, "REPWARN_RepNoTableData", args);
        }
        return colMeta._coltype;
    }
}

