/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.RepraDataTypes;
import com.sybase.connector.repra.rep.RepColumn;
import com.sybase.connector.repra.rep.RepHolderException;
import com.sybase.connector.repra.rep.RepTable;
import com.sybase.connector.repra.rep.RepTypeException;
import com.sybase.connector.repra.rep.Tuple;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class RepValue
implements Serializable {
    public static final int NAME = 1;
    public static final int AFTER = 2;
    public static final int BEFORE = 4;
    public static final int META = 8;
    private boolean _meta = false;
    private Vector _data = new Vector();
    private Hashtable _idx = new Hashtable();

    protected RepValue() {
    }

    public static String typeString(int typeCode) {
        return (String)RepraDataTypes.DATATYPE_STRINGS.get(new Integer(typeCode));
    }

    public int size() {
        return this._data.size();
    }

    public boolean hasMetaData() {
        return this._meta;
    }

    public String getName(int field) throws RepTypeException {
        return this.getTuple((int)field)._name;
    }

    public String getLiteral(int field, int vType) throws RepTypeException {
        return this.getTuple(field).getLiteral(vType);
    }

    public int getType(int field) throws RepTypeException {
        if (!this._meta) {
            throw new RepTypeException("REPERR_RepNoMetaConfig");
        }
        return this.getTuple((int)field)._column._coltype;
    }

    public int getType(int field, int noexcept) throws RepTypeException {
        if (!this._meta) {
            if (noexcept == 1) {
                return 9999;
            }
            throw new RepTypeException("REPERR_RepNoMetaConfig");
        }
        return this.getTuple((int)field)._column._coltype;
    }

    public boolean isIdentity(int field) throws RepTypeException {
        if (!this._meta) {
            throw new RepTypeException("REPERR_RepNoMetaConfig");
        }
        return (this.getTuple((int)field)._column._status & 1) != 0;
    }

    public boolean isNull(int field, int vType) throws RepTypeException {
        String literal = this.getTuple(field).getLiteral(vType);
        return literal == null || literal.equalsIgnoreCase("null");
    }

    public int getInt(int field, int vType) throws RepTypeException, NumberFormatException {
        try {
            return Integer.parseInt(this.strip(this.getTuple(field).getLiteral(vType)));
        }
        catch (NumberFormatException nfe) {
            if (nfe.getMessage().equalsIgnoreCase("NULL")) {
                String operation = "RepValue.getInt";
                String[] args = new String[]{operation};
                throw new RepTypeException((Throwable)nfe, "REPERR_RepValIsNull", args);
            }
            throw nfe;
        }
    }

    public float getFloat(int field, int vType) throws RepTypeException, NumberFormatException {
        try {
            return Float.valueOf(this.strip(this.getTuple(field).getLiteral(vType))).floatValue();
        }
        catch (NumberFormatException nfe) {
            if (nfe.getMessage().equalsIgnoreCase("NULL")) {
                String operation = "RepValue.getFloat";
                String[] args = new String[]{operation};
                throw new RepTypeException((Throwable)nfe, "REPERR_RepValIsNull", args);
            }
            throw nfe;
        }
    }

    public double getDouble(int field, int vType) throws RepTypeException, NumberFormatException {
        try {
            return Double.valueOf(this.strip(this.getTuple(field).getLiteral(vType)));
        }
        catch (NumberFormatException nfe) {
            if (nfe.getMessage().equalsIgnoreCase("NULL")) {
                String operation = "RepValue.getDouble";
                String[] args = new String[]{operation};
                throw new RepTypeException((Throwable)nfe, "REPERR_RepValIsNull", args);
            }
            throw nfe;
        }
    }

    public byte[] getBytes(int field, int vType) throws RepTypeException {
        try {
            String s = this.strip(this.getTuple(field).getLiteral(vType));
            if (!s.startsWith("0x")) {
                throw new RepTypeException("REPERR_RepEvtNotBinType");
            }
            byte[] b = new byte[s.length() / 2];
            for (int i = 0; i < s.length() / 2; ++i) {
                b[i] = Byte.parseByte(s.substring(i * 2, i * 2 + 1), 16);
            }
            return b;
        }
        catch (NullPointerException npe) {
            String operation = "RepValue.getBytes";
            String[] args = new String[]{operation};
            throw new RepTypeException((Throwable)npe, "REPERR_RepValIsNull", args);
        }
    }

    public boolean getBoolean(int field, int vType) throws RepTypeException {
        return this.getInt(field, vType) != 0;
    }

    public String getString(int field, int vType) throws RepTypeException {
        return this.strip(this.getTuple(field).getLiteral(vType));
    }

    protected void setMetaData(RepTable rst) throws Exception {
        this._meta = true;
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                Tuple t = this.getTuple(i);
                RepColumn col = rst.getColumn(t._name);
                if (col == null) {
                    String[] args = new String[]{t._name};
                    throw new RepHolderException(null, "REPWARN_RepRSSDNoColData2", args);
                }
                this.finishContent(t, col, 8);
            }
        }
    }

    protected void addContent(String name, Object o, int vType) throws Exception {
        Tuple t = null;
        t = (vType & 1) > 0 ? this.addTuple(name) : this.getTuple(name);
        this.finishContent(t, o, vType);
    }

    protected void addContent(int i, Object o, int vType) throws Exception {
        Tuple t = null;
        if ((vType & 1) > 0) {
            try {
                t = this.addTuple((String)o);
                return;
            }
            catch (Exception e) {
                String[] args = new String[]{o.toString()};
                throw new RepHolderException((Throwable)e, "REPERR_RepRSSDBadValueLoad", args);
            }
        }
        t = (Tuple)this._data.elementAt(i);
        this.finishContent(t, o, vType);
    }

    private void finishContent(Tuple t, Object o, int vType) throws Exception {
        try {
            if ((vType & 2) > 0) {
                t._after = (String)o;
            }
            if ((vType & 4) > 0) {
                t._before = (String)o;
            }
            if ((vType & 8) > 0) {
                t._column = (RepColumn)o;
            }
        }
        catch (Exception e) {
            String[] args = new String[]{t._name};
            throw new RepHolderException((Throwable)e, "REPERR_RepRSSDBadValueLoad", args);
        }
    }

    private Tuple addTuple(String name) {
        Tuple t = new Tuple(name);
        this._data.addElement(t);
        this._idx.put(name, t);
        return t;
    }

    private Tuple getTuple(String name) throws RepTypeException {
        return (Tuple)this._idx.get(name);
    }

    private Tuple getTuple(int i) throws RepTypeException {
        if (i < 0 || i >= this._data.size()) {
            throw new RepTypeException("REPERR_RepValOutOfRange");
        }
        return (Tuple)this._data.elementAt(i);
    }

    private String strip(String s) {
        if (s == null) {
            return null;
        }
        return s;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        int i = this._data.size();
        sb.append(" size " + i + " values:\n");
        for (int j = 0; j < i; ++j) {
            Tuple t = (Tuple)this._data.elementAt(j);
            sb.append("Name: " + t._name + " after: " + t._after + " before :" + t._before + " \nMetadata: " + t._column + "\n");
        }
        return sb.toString();
    }
}

