/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepAdapterImpl;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepEventFormatter;
import com.sybase.connector.repra.rep.RepTransactionFormatter;
import com.sybase.connector.repra.rep.RepraCustomTransactionFormatter;
import com.sybase.connector.repra.rep.RepraException;
import com.sybase.connector.repra.rep.StdXMLFormatter;
import com.sybase.connector.repra.rep.XsdXmlFormatter;
import java.io.File;
import org.apache.crimson.tree.XmlDocument;
import org.dom4j.Document;

public class RepraProcessor {
    private RaLogger _log = null;
    protected RepAdapterImpl _adapterImpl = null;
    protected RepEventFormatter _formatter;
    protected static int _formatterFlag = 100;
    private boolean _custFormatter = false;
    private String _replicate = null;

    public void init(RepAdapterImpl adapterImpl, RaLogger log) throws Exception {
        this._adapterImpl = adapterImpl;
        this._log = log;
        if (this._adapterImpl.getFormatterFlag() && this._adapterImpl.getFormatterPlugin() != null && !this._adapterImpl.getFormatterPlugin().equals("") && !this._adapterImpl.getFormatterPlugin().equals("com.sybase.connector.repra.rep.StdXMLFormatter")) {
            String formatterPlugin = null;
            try {
                formatterPlugin = this._adapterImpl.getFormatterPlugin();
                this._formatter = (RepEventFormatter)Class.forName(formatterPlugin).newInstance();
                if (this._formatter instanceof RepraCustomTransactionFormatter) {
                    this._log.debug("RepraProcessor.init.m13");
                    String propFile = this._adapterImpl.getFormatterProps();
                    this._log.debug("RepraProcessor.init.m14", propFile);
                    File file1 = new File(propFile);
                    if (propFile != null && !propFile.equals("") && !new File(propFile).exists()) {
                        this._log.error("RepraProcessor.init.e3");
                        throw new Exception(this._log.getResourceBundle().getString("RepraProcessor.init.e3"));
                    }
                    ((RepraCustomTransactionFormatter)this._formatter).setConfigProps(propFile);
                } else {
                    this._log.debug("RepraProcessor.init.m15");
                }
                this._formatter.setLogger(this._log);
                this._custFormatter = true;
            }
            catch (Exception ex) {
                this._log.error("RepraProcessor.init.e2", (Object)formatterPlugin, (Object)this._adapterImpl.getDSIName(), ex);
                throw ex;
            }
        }
        try {
            if (_formatterFlag == 100) {
                this._formatter = new XsdXmlFormatter();
                ((XsdXmlFormatter)this._formatter).setXsdUri(this._adapterImpl.getDTD_URL());
            } else {
                this._formatter = new StdXMLFormatter();
                ((StdXMLFormatter)this._formatter).setDTD_URL(this._adapterImpl.getDTD_URL());
            }
            this._custFormatter = false;
            this._formatter.setLogger(this._log);
        }
        catch (Exception ex) {
            this._log.error("RepraProcessor.init.e1", (Object)this._adapterImpl.getDSIName(), (Throwable)ex);
            throw ex;
        }
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void setReplicateDB(String rdb) {
        this._replicate = rdb;
        this._replicate = rdb != null && (rdb.equals("null") || rdb.length() == 0) ? null : rdb;
    }

    public String getReplicateDB() {
        return this._replicate;
    }

    public void routeEvent(Object e) throws Exception {
        try {
            this._adapterImpl._finalMsg = this._custFormatter ? e : (_formatterFlag == 100 ? XsdXmlFormatter.xmlDocString((Document)e) : StdXMLFormatter.xmlDocString((XmlDocument)e));
            this._log.debug("RepraProcessor.routeEvent.m1");
            if (!this._adapterImpl.sendRepMessage()) {
                throw new RepraException("Failed to send a Repra message.");
            }
            this._adapterImpl.resetTransaction();
            this._log.debug("RepraProcessor.routeEvent.m2");
        }
        catch (Exception ex) {
            this._log.error("RepraProcessor.routeEvent.m3", (Object)this._adapterImpl.getDSIName(), (Throwable)ex);
            throw ex;
        }
    }

    public void repGroupEvent(RepEvent[] reps) throws Exception {
        if (this._formatter instanceof XsdXmlFormatter) {
            this._adapterImpl.setEventId(reps[reps.length - 1].getMessageId());
            ((XsdXmlFormatter)this._formatter).setEventId(reps[reps.length - 1].getMessageId());
        }
        if (this._formatter instanceof StdXMLFormatter) {
            this._adapterImpl.setEventId(reps[reps.length - 1].getMessageId());
            ((StdXMLFormatter)this._formatter).setEventId(reps[reps.length - 1].getMessageId());
        }
        Object formatted = ((RepTransactionFormatter)this._formatter).formatTransaction(reps);
        this._log.debug("RepraProcessor.repGroupEvent.m1");
        this.routeEvent(formatted);
    }

    public void repevent(RepEvent rse) throws Exception {
        this._log.debug("RepraProcessor.repevent.m1");
        if (this._formatter instanceof XsdXmlFormatter) {
            this._adapterImpl.setEventId(rse.getMessageId());
            ((XsdXmlFormatter)this._formatter).setEventId(rse.getMessageId());
        } else if (this._formatter instanceof StdXMLFormatter) {
            this._adapterImpl.setEventId(rse.getMessageId());
            ((StdXMLFormatter)this._formatter).setEventId(rse.getMessageId());
        }
        this.routeEvent(this._formatter.format(rse));
    }

    public String[] subscribe() {
        if (this._replicate != null) {
            String[] s = new String[]{this._replicate};
            return s;
        }
        return null;
    }

    public boolean requiresParse() {
        return this._formatter.requiresParse();
    }

    public boolean requiresXActions() {
        return true;
    }

    public boolean requiresGrouping() {
        return this._adapterImpl.getRequiredGroup();
    }

    public boolean requiresMetaData() {
        return this._formatter.requiresMetaData();
    }

    public void begin() {
    }

    public void commit() {
    }

    public void rollback() {
    }

    public synchronized void eventDelivered(RepraException ex) {
        this._log.debug("RepraProcessor.eventDelivered.m1", (Throwable)ex);
        this.notifyAll();
    }
}

