/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepTransactionFormatter;
import com.sybase.connector.repra.rep.RepTypeException;
import com.sybase.connector.repra.rep.RepValue;
import com.sybase.connector.repra.rep.RepraException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StdXMLFormatter
implements RepTransactionFormatter {
    private RaLogger _log = null;
    private static boolean _test = false;
    private static final int OPER_INSERT = 0;
    private static final int OPER_DELETE = 1;
    private static final int OPER_UPDATE = 2;
    private static final int OPER_EXEC = 3;
    private static final int OPER_UNDEFINED = -1;
    private String _dtdURL = "http://localhost:8000/RepraWebApp/dtds/dbeventstream.dtd";
    private String _eventId = null;
    private static final String[] REPOPERATIONS = new String[]{"insert", "delete", "update", "exec", null};

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void setDTD_URL(String url) {
        this._dtdURL = url;
    }

    public boolean requiresMetaData() {
        return true;
    }

    public boolean requiresTokenizing() {
        return true;
    }

    public boolean requiresParse() {
        return true;
    }

    public Object format(RepEvent rse) throws RepraException {
        XmlDocument doc = null;
        try {
            Element root = null;
            Element event = null;
            doc = new XmlDocument();
            doc.setDoctype(null, this._dtdURL, null);
            root = this.formatDocRoot((Document)doc, rse);
            doc.appendChild((Node)root);
            int oper = this.getOperationType(rse.getOperation());
            event = oper == 3 ? this.formatExec((Document)doc, rse) : this.formatIndividualEvent((Document)doc, rse);
            root.appendChild(event);
        }
        catch (RepTypeException rte) {
            throw new RepraException(rte, "REPERR_RepInBadFormatter");
        }
        return doc;
    }

    public Object formatTransaction(RepEvent[] events) throws RepraException {
        XmlDocument doc = null;
        try {
            Element root = null;
            Element tran = null;
            RepEvent rep = null;
            rep = events.length > 0 ? events[events.length - 1] : null;
            doc = new XmlDocument();
            doc.setDoctype(null, this._dtdURL, null);
            root = this.formatDocRoot((Document)doc, rep);
            doc.appendChild((Node)root);
            tran = this.formatTran((Document)doc, rep);
            root.appendChild(tran);
            for (int i = 0; i < events.length; ++i) {
                Element event = null;
                int oper = this.getOperationType(events[i].getOperation());
                event = oper == 3 ? this.formatExec((Document)doc, events[i]) : this.formatPrimitiveEvent((Document)doc, events[i]);
                tran.appendChild(event);
            }
        }
        catch (RepTypeException rte) {
            throw new RepraException(rte, "REPERR_RepInBadFormatter");
        }
        return doc;
    }

    private Element formatDocRoot(Document doc, RepEvent rse) {
        Element childNode = doc.createElement("dbStream");
        childNode.setAttribute("environment", this.getEnvironment(rse));
        return childNode;
    }

    private Element formatTran(Document doc, RepEvent rse) throws RepTypeException, RepraException {
        Element tranElem = doc.createElement("tran");
        tranElem.setAttribute("eventId", this.getEventId(rse));
        return tranElem;
    }

    private Element formatExec(Document doc, RepEvent rse) throws RepTypeException {
        Element execElem = doc.createElement("exec");
        execElem.setAttribute("eventId", this.getEventId(rse));
        String fullname = rse.getName();
        if (fullname.indexOf(".") >= 0) {
            execElem.setAttribute("schema", fullname.substring(fullname.indexOf(".") + 1, fullname.length()));
            execElem.setAttribute("owner", fullname.substring(0, fullname.indexOf(".")));
        } else {
            execElem.setAttribute("schema", fullname);
        }
        Element values = this.formatValues(doc, rse.getColumns(), "inValues");
        execElem.appendChild(values);
        return execElem;
    }

    private Element formatIndividualEvent(Document doc, RepEvent rse) throws RepTypeException, RepraException {
        Element eventElem = doc.createElement("dbEvent");
        eventElem.setAttribute("eventId", this.getEventId(rse));
        Element prim = this.formatPrimitiveEvent(doc, rse);
        eventElem.appendChild(prim);
        return eventElem;
    }

    private Element formatPrimitiveEvent(Document doc, RepEvent rse) throws RepTypeException, RepraException {
        Element values;
        String operName = rse.getOperation();
        String fullname = rse.getName();
        String schemaName = "";
        String owner = "";
        if (fullname.indexOf(".") >= 0) {
            schemaName = fullname.substring(fullname.indexOf(".") + 1, fullname.length());
            owner = fullname.substring(0, fullname.indexOf("."));
        } else {
            schemaName = fullname;
        }
        int oper = this.getOperationType(operName);
        if (oper == -1) {
            throw new RepraException("REPERR_RepInBadFormatter");
        }
        Element primElem = doc.createElement(operName);
        primElem.setAttribute("schema", schemaName);
        if (owner != null && !owner.equals("")) {
            primElem.setAttribute("owner", owner);
        }
        if (oper == 0 || oper == 2) {
            values = this.formatValues(doc, rse.getColumns(), "values");
            primElem.appendChild(values);
        }
        if (oper == 1 || oper == 2) {
            values = this.formatValues(doc, rse.getWhere(), "oldValues");
            primElem.appendChild(values);
        }
        return primElem;
    }

    private Element formatValues(Document doc, RepValue val, String elemName) throws RepTypeException {
        Element values = doc.createElement(elemName);
        String colName = "";
        for (int j = 0; j < val.size(); ++j) {
            String repString;
            String currCol = val.getName(j);
            if (elemName.equals("oldValues")) {
                if (currCol == null || currCol.equals(colName)) continue;
                colName = currCol;
            }
            Element item = doc.createElement("cell");
            item.setAttribute("name", currCol);
            int noexcept = 1;
            String itemtype = null;
            itemtype = RepValue.typeString(val.getType(j, noexcept));
            if (itemtype != null) {
                item.setAttribute("type", itemtype);
            }
            if ((repString = val.getString(j, 2)) == null) continue;
            item.appendChild(doc.createTextNode(repString));
            values.appendChild(item);
        }
        return values;
    }

    private String getEnvironment(RepEvent rep) {
        if (rep != null) {
            return rep.getDsName() + "." + rep.getDbName();
        }
        return "null";
    }

    public void setEventId(String eventId) {
        this._eventId = eventId;
    }

    private String getEventId(RepEvent rep) {
        if (this._eventId != null && !this._eventId.equals("")) {
            return this._eventId;
        }
        return rep.getMessageId();
    }

    private String getEventId() {
        return this._eventId;
    }

    private int getOperationType(String oper) {
        int i = 0;
        while (REPOPERATIONS[i] != null) {
            if (oper.equals(REPOPERATIONS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ByteArrayOutputStream xmlDocString(XmlDocument doc) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            StringWriter out = new StringWriter();
            doc.write((Writer)osw);
            if (_test) {
                File debug_file = new File("repra_debug.xml");
                FileOutputStream fos = new FileOutputStream(debug_file);
                fos.write(baos.toByteArray());
                fos.flush();
                fos.close();
            }
            return baos;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

