/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepTransactionFormatter;
import com.sybase.connector.repra.rep.RepTypeException;
import com.sybase.connector.repra.rep.RepValue;
import com.sybase.connector.repra.rep.RepraException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XsdXmlFormatter
implements RepTransactionFormatter {
    private static final int OPER_INSERT = 0;
    private static final int OPER_DELETE = 1;
    private static final int OPER_UPDATE = 2;
    private static final int OPER_EXEC = 3;
    private static final int OPER_UNDEFINED = -1;
    private String _eventId = null;
    private String _xsdUri = "http://localhost:8000/RepraWebApp/dtds/dbeventstream.xsd";
    private static final String DEFAULT_NSPACE = "xsi";
    private static final String DEFAULT_NSPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NO_NSPACE = "noNamespaceSchemaLocation";
    private static final boolean _test = false;
    private static final String[] REPOPERATIONS = new String[]{"insert", "delete", "update", "exec", null};
    private RaLogger _log = null;

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void setXsdUri(String uri) {
        this._xsdUri = uri;
    }

    public Object formatTransaction(RepEvent[] events) throws RepraException {
        Document doc = null;
        try {
            Element root = null;
            Element tran = null;
            RepEvent rep = null;
            rep = events.length > 0 ? events[events.length - 1] : null;
            doc = DocumentFactory.getInstance().createDocument();
            root = this.formatDocRoot(doc, rep);
            doc.add(root);
            tran = this.formatTran(doc, rep);
            root.add(tran);
            for (int i = 0; i < events.length; ++i) {
                Element event = null;
                int oper = this.getOperationType(events[i].getOperation());
                event = oper == 3 ? this.formatExec(doc, events[i]) : this.formatPrimitiveEvent(doc, events[i]);
                tran.add(event);
            }
        }
        catch (RepTypeException rte) {
            throw new RepraException(rte, "REPERR_RepInBadFormatter2");
        }
        return doc;
    }

    private Element formatTran(Document doc, RepEvent rep) throws RepTypeException, RepraException {
        Element tranElem = DocumentFactory.getInstance().createElement("tran");
        tranElem.addAttribute("eventId", this.getEventId(rep));
        if (this._log != null) {
            this._log.debug("XsdXmlFormatter.formatTran.debug", tranElem.toString());
        }
        return tranElem;
    }

    public Object format(RepEvent rse) throws RepraException {
        Document document;
        try {
            document = DocumentFactory.getInstance().createDocument();
            Element root = this.formatDocRoot(document, rse);
            document.setRootElement(root);
            int oper = this.getOperationType(rse.getOperation());
            Element event = oper == 3 ? this.formatExec(document, rse) : this.formatIndividualEvent(document, rse);
            root.add(event);
            if (this._log != null) {
                this._log.debug("XsdXmlFormatter.format.debug", event.toString());
            }
        }
        catch (Throwable ex) {
            if (this._log != null) {
                this._log.error("XsdXmlFormatter.format.error", ex);
            }
            throw new RepraException(ex, "REPERR_RepInBadFormatter2");
        }
        return document;
    }

    private Element formatIndividualEvent(Document document, RepEvent rse) throws RepTypeException, RepraException {
        Element eventElem = DocumentFactory.getInstance().createElement("dbEvent");
        eventElem.addAttribute("eventId", this.getEventId(rse));
        Element prim = this.formatPrimitiveEvent(document, rse);
        eventElem.add(prim);
        if (this._log != null) {
            this._log.debug("XsdXmlFormatter.formatIndividualEvent.debug", eventElem.toString());
        }
        return eventElem;
    }

    private Element formatPrimitiveEvent(Document document, RepEvent rse) throws RepTypeException, RepraException {
        Element values;
        String operName = rse.getOperation();
        String fullname = rse.getName();
        String schemaName = "";
        String owner = "";
        if (fullname.indexOf(".") >= 0) {
            schemaName = fullname.substring(fullname.indexOf(".") + 1, fullname.length());
            owner = fullname.substring(0, fullname.indexOf("."));
        } else {
            schemaName = fullname;
        }
        int oper = this.getOperationType(operName);
        if (oper == -1) {
            throw new RepraException("REPERR_RepInBadFormatter2");
        }
        Element primElem = DocumentFactory.getInstance().createElement(operName);
        primElem.addAttribute("schema", schemaName);
        if (owner != null && !owner.equals("")) {
            primElem.addAttribute("owner", owner);
        }
        if (oper == 0 || oper == 2) {
            values = this.formatValues(document, rse.getColumns(), "values");
            primElem.add(values);
        }
        if (oper == 1 || oper == 2) {
            values = this.formatValues(document, rse.getWhere(), "oldValues");
            primElem.add(values);
        }
        if (this._log != null) {
            this._log.debug("XsdXmlFormatter.formatPrimitiveEvent.debug", primElem.toString());
        }
        return primElem;
    }

    private Element formatExec(Document document, RepEvent rse) throws RepTypeException {
        Element execElem = DocumentFactory.getInstance().createElement("exec");
        execElem.addAttribute("eventId", this.getEventId(rse));
        String fullname = rse.getName();
        if (fullname.indexOf(".") >= 0) {
            execElem.addAttribute("schema", fullname.substring(fullname.indexOf(".") + 1, fullname.length()));
            execElem.addAttribute("owner", fullname.substring(0, fullname.indexOf(".")));
        } else {
            execElem.addAttribute("schema", fullname);
        }
        Element values = this.formatValues(document, rse.getColumns(), "inValues");
        execElem.add(values);
        if (this._log != null) {
            this._log.debug("XsdXmlFormatter.formatExec.debug", execElem.toString());
        }
        return execElem;
    }

    private Element formatValues(Document document, RepValue repVal, String elemName) throws RepTypeException {
        Element values = DocumentFactory.getInstance().createElement(elemName);
        String colName = "";
        for (int j = 0; j < repVal.size(); ++j) {
            String repString;
            String currCol = repVal.getName(j);
            if (elemName.equals("oldValues")) {
                if (currCol == null || currCol.equals(colName)) continue;
                colName = currCol;
            }
            Element item = DocumentFactory.getInstance().createElement("cell");
            item.addAttribute("name", currCol);
            int noexcept = 1;
            String itemtype = null;
            itemtype = RepValue.typeString(repVal.getType(j, noexcept));
            if (itemtype != null) {
                item.addAttribute("type", itemtype);
            }
            if ((repString = repVal.getString(j, 2)) == null) continue;
            item.addText(repString);
            values.add(item);
        }
        if (this._log != null) {
            this._log.debug("XsdXmlFormatter.formatValues.debug", values.toString());
        }
        return values;
    }

    private String getEventId(RepEvent rep) {
        if (this._eventId != null && !this._eventId.equals("")) {
            return this._eventId;
        }
        return rep.getMessageId();
    }

    private String getEventId() {
        return this._eventId;
    }

    private int getOperationType(String oper) {
        int i = 0;
        while (REPOPERATIONS[i] != null) {
            if (oper.equals(REPOPERATIONS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Element formatDocRoot(Document document, RepEvent rse) {
        Namespace namesp = new Namespace(DEFAULT_NSPACE, DEFAULT_NSPACE_URI);
        QName rootName = DocumentFactory.getInstance().createQName(NO_NSPACE, namesp);
        Element rootElement = DocumentFactory.getInstance().createElement("dbStream");
        rootElement.addAttribute(rootName, this._xsdUri);
        rootElement.addAttribute("environment", this.getEnvironment(rse));
        if (this._log != null) {
            this._log.debug("XsdXmlFormatter.format.debug", rootElement.toString());
        }
        return rootElement;
    }

    private String getEnvironment(RepEvent rse) {
        if (rse != null) {
            return rse.getDsName() + "." + rse.getDbName();
        }
        return "null";
    }

    public boolean requiresMetaData() {
        return true;
    }

    public boolean requiresParse() {
        return true;
    }

    public void setEventId(String eventId) {
        this._eventId = eventId;
    }

    public static ByteArrayOutputStream xmlDocString(Document document) throws IOException {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setTrimText(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        XMLWriter writer = new XMLWriter((Writer)osw, outformat);
        writer.write(document);
        writer.flush();
        return baos;
    }
}

