/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.servlet;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.RepraConnectionSpec;
import com.sybase.connector.repra.license.RepraSySamClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class RepraInitServlet
extends HttpServlet {
    private static RaLogger _log = null;
    Context _ctx = null;
    ConnectionFactory _cf = null;
    Hashtable _autoConnections = new Hashtable();
    private static ConnectionContainer _container = null;

    public void init(ServletConfig config) throws ServletException {
        block5: {
            super.init(config);
            _log = new RaLogger(0);
            try {
                if (!RepraSySamClient.getRepraLicense()) {
                    _log.error("RepraInitServlet.startAutoStartConnections.m3");
                    break block5;
                }
                this._ctx = new InitialContext();
                try {
                    this._cf = (ConnectionFactory)this._ctx.lookup("eis/Sybase_RepConnector_MCF");
                }
                catch (Exception ex) {
                    this._cf = (ConnectionFactory)this._ctx.lookup("Repra/Sybase_RepConnector_MCF");
                }
                _container = ConnectionContainer.getInstance();
                this.getAutoStartConnections();
                this.startAutoStartConnections();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void getAutoStartConnections() {
        try {
            File configDir = new File(RepraPropertyUtil.getConfigDir());
            if (!configDir.isDirectory()) {
                return;
            }
            String[] fileList = configDir.list();
            Properties props = null;
            String configFile = "";
            File tmpFile = null;
            FileInputStream fstream = null;
            String connectionName = null;
            for (int ido = 0; ido < fileList.length; ++ido) {
                configFile = configDir + File.separator + fileList[ido];
                tmpFile = new File(configFile);
                if (tmpFile.isDirectory() || !configFile.toLowerCase().endsWith(".props")) continue;
                props = new Properties();
                fstream = new FileInputStream(tmpFile);
                props.load(fstream);
                connectionName = props.getProperty("ConnectionName", "");
                if (this._autoConnections.containsKey(connectionName) || connectionName.equals("") || !props.getProperty("AutoStart", "false").toLowerCase().equals("true")) continue;
                this._autoConnections.put(connectionName, RepraPropertyUtil.decProperties(props));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startAutoStartConnections() {
        Connection conn = null;
        Object cf = null;
        String name = "";
        String startMode = "false";
        try {
            Enumeration connectionNames = this._autoConnections.keys();
            Properties props = null;
            while (connectionNames.hasMoreElements()) {
                name = (String)connectionNames.nextElement();
                props = (Properties)this._autoConnections.get(name);
                try {
                    RepraConnectionSpec spec = new RepraConnectionSpec(props);
                    conn = this._cf.getConnection((ConnectionSpec)spec);
                    _container.setConnection(name, conn);
                }
                catch (Exception repex) {
                    _log.error("RepraInitServlet.startAutoStartConnections.m1", (Object)name, (Throwable)repex);
                }
            }
        }
        catch (Exception ex) {
            _log.error("RepraInitServlet.startAutoStartConnections.m2", (Throwable)ex);
        }
    }
}

