/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.tibrv;

import com.sybase.connector.repra.RepraAdapter;
import com.sybase.connector.repra.tibrv.TIBRVAdapterImpl;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import com.tibco.tibrv.TibrvCmListener;
import com.tibco.tibrv.TibrvCmMsg;
import com.tibco.tibrv.TibrvCmTransport;
import com.tibco.tibrv.TibrvDispatchable;
import com.tibco.tibrv.TibrvDispatcher;
import com.tibco.tibrv.TibrvListener;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvMsgCallback;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvRvdTransport;
import java.io.File;
import java.util.Properties;

public class TIBRVCMAdapterImpl
extends TIBRVAdapterImpl
implements TibrvMsgCallback,
RepraAdapter {
    private String _cmName;
    private long _lastSeqNo = 0L;
    private Object _lockSeqNo = new Object();
    private double _cmDuration = 0.0;
    private TibrvRvdTransport _rvdTransport;
    private TibrvCmTransport _cmTransport;
    private TibrvCmListener _cmListener;
    private TibrvDispatcher _dispatcher;
    private TibrvQueue _queue = null;
    private ThreadGroup _dispatcherGroup = new ThreadGroup("DispatcherGroup");

    public TIBRVCMAdapterImpl(Properties cProps) {
        this.initTIBRVAdapter(cProps);
        this._cmName = this._cProps.getProperty("RV_CMName", "RepaCM");
    }

    public void configureRVCMListener() throws Exception {
        Object[] info = new String[]{this._service, this._network, this._daemon};
        try {
            this._queue = new TibrvQueue();
            this._rvTransport = new TibrvRvdTransport(this._service, this._network, this._daemon);
            this._log.debug("TIBRVCMAdapterImpl.configureRVCMListener.m1", info);
            String ledgerPath = RepraPropertyUtil.getRepraDir() + File.separator + "cmledgers" + File.separator + this._cProps.getProperty("ConnectionName") + "_" + this._cmName + "_ledger.rcv";
            File fptr = new File(RepraPropertyUtil.getRepraDir() + File.separator + "cmledgers");
            if (!fptr.exists()) {
                fptr.mkdir();
            }
            this._cmTransport = new TibrvCmTransport((TibrvRvdTransport)this._rvTransport, this._cmName, true, ledgerPath, true, null);
            this._log.debug("TIBRVCMAdapterImpl.configureRVCMListener.m2", this._cmName);
            this._cmListener = new TibrvCmListener(this._queue, (TibrvMsgCallback)this, this._cmTransport, this._subject, null);
            this._log.debug("TIBRVCMAdapterImpl.configureRVCMListener.m3", this._subject);
            this._cmListener.setExplicitConfirm();
            this._dispatcher = new TibrvDispatcher(this._dispatcherGroup, "Dispatcher", (TibrvDispatchable)this._queue, 3000.0);
            this._log.debug("TIBRVCMAdapterImpl.configureRVCMListener.m4");
        }
        catch (Exception ex) {
            this._log.error("TIBRVCMAdapterImpl.configureRVCMListener.m5", info, (Throwable)ex);
            throw ex;
        }
    }

    public void run() {
        try {
            this.configureRVCMListener();
        }
        catch (Throwable ex) {
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this.cleanup();
            this.close();
            return;
        }
        try {
            this.configureJDBCClient();
            this._log.info("TIBRVCMAdapterImpl.configureJDBCClient.m1", (Object)this._cProps.getProperty("DATABASE_URL"), this._cProps.getProperty("DATABASE_Username"));
        }
        catch (Throwable ex) {
            this.handleException(ex.toString());
            this._log.error("TIBRVCMAdapterImpl.configureJDBCClient.e1");
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this.cleanup();
            this.close();
            return;
        }
        _connectionContainer.setControl(this.getConnectionName(), "RUNNING");
        this._log.debug("TIBRVCMAdapterImpl.run.m1");
        while (!_connectionContainer.getControl(this.getConnectionName()).equals("STOP")) {
            try {
                this._dispatcher.join();
            }
            catch (Exception exception) {}
        }
        this.cleanup();
    }

    public void onMsg(TibrvListener listener, TibrvMsg message) {
        long seqno = 0L;
        try {
            seqno = TibrvCmMsg.getSequence((TibrvMsg)message);
            if (seqno > 0L) {
                this._cmListener.confirmMsg(message);
            }
        }
        catch (Exception anyex) {
            this._log.warn("TIBRVCMAdapterImpl.onMsg.m1", (Object)(seqno + "::" + message.toString()), null);
        }
        this.onMsgImpl(listener, message);
    }

    public void cleanup() {
        _connectionContainer.setControl(this.getConnectionName(), "STOP");
        try {
            if (this._jdbcClient != null) {
                this._jdbcClient.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this._dispatcher != null) {
                this._dispatcherGroup.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

