/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sybase.connector.repra.util.RaConnection;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.repra.util.RaUtils;
import java.util.Properties;
import java.util.Vector;

public class RaClientUtil
implements RaUtils {
    private String _host = "localhost";
    private String _port = "8000";
    private String _user = "repraadmin";
    private String _password = null;
    private RaConnection _raConn = null;
    private boolean _verbose = false;

    public RaClientUtil(String host, String port, String user, String password, String servletName) {
        this.init(host, port, user, password, servletName, false);
    }

    public RaClientUtil(String host, String port, String user, String password, String servletName, boolean verbose) {
        this.init(host, port, user, password, servletName, verbose);
    }

    public RaClientUtil(String host, String port, String user, String password) {
        this.init(host, port, user, password, null, false);
    }

    public RaClientUtil(String host, String port, String user, String password, boolean verbose) {
        this.init(host, port, user, password, null, verbose);
    }

    private void init(String host, String port, String user, String password, String servletName, boolean verbose) {
        this._verbose = verbose;
        if (this._verbose) {
            System.out.println("RaClientUtil[DEBUG]: host:" + host + ", port:" + port + ", user:" + user + ", password: " + password + ",servletName = " + servletName + ",verbose:" + verbose);
        }
        if (this.isEmpty(host)) {
            this._host = host;
        }
        if (this.isEmpty(port)) {
            this._port = port;
        }
        if (this.isEmpty(user)) {
            this._user = user;
        }
        if (this.isEmpty(password)) {
            this._password = password;
        }
        this._raConn = new RaConnection(this._host, this._port, this._user, this._password, this._verbose);
        if (this.isEmpty(servletName)) {
            this._raConn.setServletName(servletName);
        }
    }

    private boolean isEmpty(String value) {
        return value != null && value.trim().length() > 0;
    }

    public Vector startConnection() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[Info]: startConnection()");
        }
        Object returnObj = null;
        this._raConn.setURI("command", 2);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (Vector)returnObj;
    }

    public RaStatus startConnection(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: startConnection(): connName=" + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 1);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public Vector stopConnection() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: stopConnection()");
        }
        Object returnObj = null;
        this._raConn.setURI("command", 4);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (Vector)returnObj;
    }

    public RaStatus stopConnection(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: stopConnection(): connName=" + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 3);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public Vector refreshConnection() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: refreshConnection()");
        }
        Object returnObj = null;
        this._raConn.setURI("command", 6);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (Vector)returnObj;
    }

    public RaStatus refreshConnection(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: refreshConnection(): connName=" + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 5);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus createConnection(String connName, Properties connProps, boolean override) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: createConnection(): connName=" + connName + ", override = " + override + "connProps = " + connProps.toString());
        }
        Object returnObj = null;
        if (connProps == null || connProps.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 7);
        if (connName == null) {
            connName = connProps.getProperty("ConnectionName");
        }
        if (connName != null) {
            this._raConn.setURI("connName", connName);
        }
        if (override) {
            this._raConn.setURI("override", String.valueOf(override));
        }
        try {
            returnObj = this._raConn.send(connProps);
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public Vector deleteConnection() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: deleteConnection()");
        }
        Object returnObj = null;
        this._raConn.setURI("command", 10);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (Vector)returnObj;
    }

    public RaStatus deleteConnection(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: deleteConnection(): connName = " + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 9);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus copyConnection(String connName, String newConnName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: copyConnection(): connName = " + connName + ", newConnName = " + newConnName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        if (this.isNull(newConnName)) {
            throw new RaException("new Connection name is not valid.");
        }
        this._raConn.setURI("command", 12);
        this._raConn.setURI("connName", connName);
        this._raConn.setURI("newConnName", newConnName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus renameConnection(String connName, String newConnName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: renameConnection(): connName = " + connName + ", newConnName = " + newConnName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        if (this.isNull(newConnName)) {
            throw new RaException("new Connection name is not valid.");
        }
        this._raConn.setURI("command", 11);
        this._raConn.setURI("connName", connName);
        this._raConn.setURI("newConnName", newConnName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus validateConnection(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: validateConnection(): connName = " + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 13);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus validateConnection(String connName, Properties connProps) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: validateConnection(): connName = " + connName + " connProps = " + connProps.toString());
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        if (connProps == null || connProps.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 13);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send(connProps);
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getConnections() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnections()");
        }
        Object returnObj = null;
        this._raConn.setURI("command", 14);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getConnectionStatus() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionStatus()");
        }
        Object returnObj = null;
        this._raConn.setURI("command", 16);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getConnectionStatus(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionStatus(): connName = " + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 15);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus isRunning(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: isRunning(): connName = " + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 27);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getConnectionProps(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionProps(): connName = " + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 18);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getConnectionPropValue(String connName, String propName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionPropValue(): connName = " + connName + ", propName = " + propName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        if (this.isNull(propName)) {
            throw new RaException("Property Key name is not specified.");
        }
        this._raConn.setURI("command", 19);
        this._raConn.setURI("connName", connName);
        this._raConn.setURI("propName", propName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus setConnectionPropValue(String connName, String propName, String propValue) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionPropValue(): connName = " + connName + ", propName = " + propName + ",propValue = " + propValue);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        if (this.isNull(propName)) {
            throw new RaException("Property Key name is not specified.");
        }
        if (this.isNull(propValue)) {
            throw new RaException("Property Value name is not specified.");
        }
        this._raConn.setURI("command", 20);
        this._raConn.setURI("connName", connName);
        this._raConn.setURI("propName", propName);
        this._raConn.setURI("propValue", propValue);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getInboundTypes() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getInboundTypes()");
        }
        Object returnObj = null;
        this._raConn.setURI("command", 25);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getOutboundTypes() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getOutboundTypes()");
        }
        Object returnObj = null;
        this._raConn.setURI("command", 26);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getInboundTypes(String outboundType) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getInboundTypes(): outboundType = " + outboundType);
        }
        Object returnObj = null;
        if (this.isNull(outboundType)) {
            throw new RaException("Type is not specified.");
        }
        this._raConn.setURI("command", 25);
        this._raConn.setURI("OutboundType", outboundType);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getOutboundTypes(String inboundType) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getOutboundTypes(): inboundType = " + inboundType);
        }
        Object returnObj = null;
        if (this.isNull(inboundType)) {
            throw new RaException("Type is not specified.");
        }
        this._raConn.setURI("command", 26);
        this._raConn.setURI("InboundType", inboundType);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getGeneralParams(Properties connProps) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getGeneralParams(): connProps = " + connProps);
        }
        Object returnObj = null;
        if (connProps == null || connProps.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 21);
        try {
            returnObj = this._raConn.send(connProps);
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getInboundParams(Properties connProps) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getInboundParams(): connProps = " + connProps);
        }
        Object returnObj = null;
        if (connProps == null || connProps.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 22);
        try {
            returnObj = this._raConn.send(connProps);
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getOutboundParams(Properties connProps) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getOutboundParams(): connProps = " + connProps);
        }
        Object returnObj = null;
        if (connProps == null || connProps.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 23);
        try {
            returnObj = this._raConn.send(connProps);
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getPluginParams(Properties connProps) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getPluginParams(): connProps = " + connProps);
        }
        Object returnObj = null;
        if (connProps == null || connProps.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 24);
        try {
            returnObj = this._raConn.send(connProps);
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getLogInfo(String connName) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getLogInfo(): connName = " + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 17);
        this._raConn.setURI("connName", connName);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getLogInfo(String connName, int sLine, int eLine) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getLogInfo(): connName = " + connName);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 17);
        this._raConn.setURI("connName", connName);
        this._raConn.setURI("sLine", sLine);
        this._raConn.setURI("eLine", eLine);
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    public RaStatus getLogInfo(String connName, int size) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getLogInfo(): connName = " + connName + ", size = " + size);
        }
        Object returnObj = null;
        if (this.isNull(connName)) {
            throw new RaException("Connection is not specified.");
        }
        if (size == 0 || size < -1) {
            // empty if block
        }
        this._raConn.setURI("command", 17);
        this._raConn.setURI("connName", connName);
        this._raConn.setURI("size", String.valueOf(size));
        try {
            returnObj = this._raConn.send();
        }
        catch (Exception ee) {
            throw new RaException(ee.getMessage());
        }
        return (RaStatus)returnObj;
    }

    private boolean isNull(String str) {
        boolean isEmpty = false;
        if (str == null || str.equals("")) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public Vector ping(String connName, String type, Properties props) throws RaException {
        Vector retStatus = new Vector();
        if (!this.isEmpty(connName)) {
            throw new RaException("connname.null");
        }
        if (!this.isEmpty(type)) {
            throw new RaException("sourcetype.null");
        }
        this._raConn.setURI("command", 29);
        this._raConn.setURI("connName", connName);
        this._raConn.setURI("Source", type);
        try {
            retStatus = props != null ? (Vector)this._raConn.send(props) : (Vector)this._raConn.send();
        }
        catch (Throwable ee) {
            throw new RaException(ee.getMessage());
        }
        return retStatus;
    }

    public Vector ping(String connName, String type) throws RaException {
        return this.ping(connName, type, null);
    }

    private void verbose(String msg) {
        System.out.println("RaClientUtil[INFO]: " + msg);
    }
}

