/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class RaXMLBuilder {
    private static final String DEFAULT_NSPACE = "xsi";
    private static final String DEFAULT_NSPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NO_NSPACE = "noNamespaceSchemaLocation";
    private static final String DBENVIRONMENT_ATTR = "environment";
    private static final String DBSTREAM_TAG = "dbStream";
    private static final String DBTRANS_TAG = "tran";
    private static final String DBEVENT_TAG = "dbEvent";
    private static final String EVENTID_TAG = "eventId";
    private static final String CONDITION_TAG = "condition";
    private static final String OPERATOR_TAG = "operator";
    private static final String DEFAULT_OP = "=";
    private static final String DEFAULT_COND = "AND";
    private static final String STATUSROOT_TAG = "eventStatus";
    private static final String STATUS_TAG = "status";
    private static final String STATUSCODE_TAG = "statusCode";
    private static final String MESSAGE_TAG = "message";
    private boolean _isTran = true;
    private Document _rootDoc;
    private Element _rootElem;
    private Element _eventElem;

    public Element createTranDocument(String uri, String dbname, String eventId) throws Exception {
        this._isTran = true;
        this.buildStream(uri, dbname);
        this._eventElem = this.createDBTranElement(eventId);
        this._rootElem.add(this._eventElem);
        return this._eventElem;
    }

    public Element createEventDocument(String uri, String dbname, String eventId) throws Exception {
        this._isTran = false;
        this.buildStream(uri, dbname);
        this._eventElem = this.createDBEventElement(eventId);
        this._rootElem.add(this._eventElem);
        return this._eventElem;
    }

    private void buildStream(String uri, String dbname) throws Exception {
        if (this._rootDoc == null) {
            this._rootDoc = DocumentHelper.createDocument();
        }
        if (this._rootDoc.getRootElement() != null && this._rootElem != null) {
            this._rootDoc.remove(this._rootElem);
        }
        this._rootElem = this.createRootElement(uri, dbname);
        this._rootDoc.add(this._rootElem);
    }

    private Element createRootElement(String xsdUri, String dbname) throws Exception {
        Namespace namesp = new Namespace(DEFAULT_NSPACE, DEFAULT_NSPACE_URI);
        QName rootName = DocumentFactory.getInstance().createQName(NO_NSPACE, namesp);
        Element rootElement = DocumentFactory.getInstance().createElement(DBSTREAM_TAG);
        rootElement.addAttribute(rootName, xsdUri);
        rootElement.addAttribute(DBENVIRONMENT_ATTR, dbname);
        return rootElement;
    }

    private Element createDBEventElement(String eventId) throws Exception {
        Element eventElement = DocumentFactory.getInstance().createElement(DBEVENT_TAG);
        eventElement.addAttribute(EVENTID_TAG, eventId);
        return eventElement;
    }

    private Element createDBTranElement(String eventId) throws Exception {
        Element eventElement = DocumentFactory.getInstance().createElement(DBTRANS_TAG);
        eventElement.addAttribute(EVENTID_TAG, eventId);
        return eventElement;
    }

    public Element addOperation(String operName, String schemaName) throws Exception {
        if (!this._isTran && this._eventElem.elements().size() > 0) {
            return null;
        }
        Element operElem = DocumentFactory.getInstance().createElement(operName);
        operElem.addAttribute("schema", schemaName);
        this._eventElem.add(operElem);
        return operElem;
    }

    public void addValue(Element operElem, String fieldName, String fieldType, String fieldValue) throws Exception {
        Element elem = null;
        elem = operElem.element("values");
        if (elem == null) {
            elem = DocumentFactory.getInstance().createElement("values");
            operElem.add(elem);
        }
        Element item = DocumentFactory.getInstance().createElement("cell");
        item.addAttribute("name", fieldName);
        item.addAttribute("type", fieldType);
        item.addText(fieldValue);
        elem.add(item);
    }

    public void addInValue(Element operElem, String fieldName, String fieldType, String fieldValue) throws Exception {
        Element elem = null;
        elem = operElem.element("inValues");
        if (elem == null) {
            elem = DocumentFactory.getInstance().createElement("inValues");
            operElem.add(elem);
        }
        Element item = DocumentFactory.getInstance().createElement("cell");
        item.addAttribute("name", fieldName);
        item.addAttribute("type", fieldType);
        item.addText(fieldValue);
        elem.add(item);
    }

    public void addOutValue(Element operElem, String fieldName, String fieldType, String fieldValue) throws Exception {
        Element elem = null;
        elem = operElem.element("outValues");
        if (elem == null) {
            elem = DocumentFactory.getInstance().createElement("outValues");
            operElem.add(elem);
        }
        Element item = DocumentFactory.getInstance().createElement("cell");
        item.addAttribute("name", fieldName);
        item.addAttribute("type", fieldType);
        item.addText(fieldValue);
        elem.add(item);
    }

    public void addWhere(Element operElem, String fieldName, String fieldType, String fieldValue) throws Exception {
        this.addWhere(operElem, fieldName, fieldType, fieldValue, DEFAULT_COND, DEFAULT_OP);
    }

    public void addWhere(Element operElem, String fieldName, String fieldType, String fieldValue, String condition, String operator) throws Exception {
        if (operElem.getQName().getName().equalsIgnoreCase("insert")) {
            return;
        }
        Element elem = null;
        elem = operElem.element("oldValues");
        if (elem == null) {
            elem = DocumentFactory.getInstance().createElement("oldValues");
            operElem.add(elem);
        }
        Element item = DocumentFactory.getInstance().createElement("cell");
        item.addAttribute("name", fieldName);
        item.addAttribute("type", fieldType);
        if (elem.elements().size() != 0) {
            if (condition != null && !condition.equals("")) {
                item.addAttribute(CONDITION_TAG, condition);
            } else {
                item.addAttribute(CONDITION_TAG, DEFAULT_COND);
            }
        }
        if (operator != null && !operator.equals("")) {
            item.addAttribute(OPERATOR_TAG, operator);
        } else {
            item.addAttribute(OPERATOR_TAG, DEFAULT_OP);
        }
        item.addText(fieldValue);
        elem.add(item);
    }

    public void write(String filename) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(filename), format);
        writer.write(this._rootDoc);
        writer.close();
    }

    public ByteArrayOutputStream xmlDocByteArray() throws Exception {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        XMLWriter writer = new XMLWriter((Writer)osw, outformat);
        writer.write(this._rootDoc);
        writer.flush();
        return baos;
    }

    public String xmlDocString() throws Exception {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        ByteArrayOutputStream baos = this.xmlDocByteArray();
        return baos.toString("UTF-8");
    }

    public void calcelOperation(Element elem) throws Exception {
        if (elem != null) {
            this._eventElem.remove(elem);
        }
    }

    public static String getErrorEventId(String xmlText) throws Exception {
        Element status = RaXMLBuilder.getStatusElement(xmlText);
        return status.attributeValue(EVENTID_TAG);
    }

    public static String getErrorStatusCode(String xmlText) throws Exception {
        Element status = RaXMLBuilder.getStatusElement(xmlText);
        return status.attributeValue(STATUSCODE_TAG);
    }

    public static String getErrorMessage(String xmlText) throws Exception {
        Element status = RaXMLBuilder.getStatusElement(xmlText);
        return status.attributeValue(MESSAGE_TAG);
    }

    private static Element getStatusElement(String xmlText) throws Exception {
        Document errorDoc = DocumentHelper.parseText((String)xmlText);
        Element rootElem = errorDoc.getRootElement();
        if (rootElem.getQName().getName().equalsIgnoreCase(STATUSROOT_TAG)) {
            Element status = rootElem.element(STATUS_TAG);
            return status;
        }
        return null;
    }
}

