/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.sybase.connector.repra.logging.RaLogger;
import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvRvdTransport;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.directory.InitialDirContext;

public class RepraPingUtil {
    static RaLogger _log;

    public static boolean pingRSSD(RaLogger log, String url, String username, String password) throws Exception {
        Connection conn = null;
        _log = log;
        try {
            _log.debug("RepraPingUtil.pingrssd.debug.1", "url:" + url);
            _log.debug("RepraPingUtil.pingrssd.debug.1", "userName:" + username);
            Driver driver = (Driver)Class.forName("com.sybase.jdbc3.jdbc.SybDriver").newInstance();
            Properties rssdprops = new Properties();
            rssdprops.put("user", username);
            rssdprops.put("password", password);
            rssdprops.put("USE_METADATA", "false");
            conn = driver.connect(url, rssdprops);
            conn.close();
            _log.debug("RepraPingUtil.pingrssd.debug.1", "PingSucceed");
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraPingUtil.pingrssd.debug.1", (Object)"Exception", (Throwable)ex);
            throw ex;
        }
    }

    public static boolean pingJMS(RaLogger log, String destType, String url, String connFactory, String initContext, String username, String password, String dest, String statusDest) throws Exception {
        InitialContext ctx = null;
        ConnectionFactory jcf = null;
        QueueConnection jConnection = null;
        QueueSession jSession = null;
        Queue jDest = null;
        Queue jDest1 = null;
        boolean sonicmq = false;
        _log = log;
        try {
            _log.debug("RepraPingUtil.pingjms.debug.1", "DestType:" + destType);
            _log.debug("RepraPingUtil.pingjms.debug.1", "connFact:" + connFactory);
            _log.debug("RepraPingUtil.pingjms.debug.1", "iniCxt:" + initContext);
            _log.debug("RepraPingUtil.pingjms.debug.1", "userName:" + username);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", initContext);
            env.put("java.naming.provider.url", url);
            if (username != null) {
                env.put("java.naming.security.principal", username);
            }
            if (password != null) {
                env.put("java.naming.security.credentials", password);
            }
            _log.debug("RepraPingUtil.pingjms.debug.1", "GotInitialContext");
            if (initContext.indexOf("com.tibco.tibjms.naming.TibjmsInitialContextFactory") >= 0) {
                try {
                    ctx = new InitialContext(env);
                }
                catch (Exception ex) {
                    env.put("java.naming.referral", "throw");
                    ctx = new InitialDirContext(env);
                }
                Class<?> factory = Class.forName(connFactory);
                Class[] args1 = new Class[]{String.class};
                Object[] urlObj = new Object[]{url};
                Constructor<?> cons = factory.getConstructor(args1);
                jcf = (ConnectionFactory)cons.newInstance(urlObj);
            } else if (initContext.indexOf("progress.message.jclient.QueueConnectionFactory") >= 0 || initContext.indexOf("progress.message.jclient.TopicConnectionFactory") >= 0) {
                sonicmq = true;
                Class<?> factory = Class.forName(connFactory);
                Class[] args1 = new Class[]{String.class};
                Object[] urlObj = new Object[]{url};
                Constructor<?> cons = factory.getConstructor(args1);
                jcf = (ConnectionFactory)cons.newInstance(urlObj);
            } else {
                try {
                    ctx = new InitialContext(env);
                }
                catch (Exception ex) {
                    env.put("java.naming.referral", "throw");
                    ctx = new InitialDirContext(env);
                }
                jcf = (ConnectionFactory)ctx.lookup(connFactory);
            }
            _log.debug("RepraPingUtil.pingjms.debug.1", "GotConnectionFactory");
            if (destType.equals("queue")) {
                jConnection = ((QueueConnectionFactory)jcf).createQueueConnection(username, password);
                jSession = jConnection.createQueueSession(false, 1);
                _log.debug("RepraPingUtil.pingjms.debug.1", "GotQueueSession");
                if (!sonicmq) {
                    jDest = (Queue)ctx.lookup(dest);
                    if (statusDest != null && !statusDest.equals("")) {
                        jDest1 = (Queue)ctx.lookup(statusDest);
                    }
                }
            } else {
                jConnection = ((TopicConnectionFactory)jcf).createTopicConnection(username, password);
                jSession = ((TopicConnection)jConnection).createTopicSession(false, 1);
                _log.debug("RepraPingUtil.pingjms.debug.1", "GotTopicSession");
                if (!sonicmq) {
                    jDest = (Topic)ctx.lookup(dest);
                    if (statusDest != null && !statusDest.equals("")) {
                        jDest1 = (Queue)ctx.lookup(statusDest);
                    }
                }
            }
            jSession.close();
            jConnection.close();
            _log.debug("RepraPingUtil.pingjms.debug.1", "PingSucceed");
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraPingUtil.pingjms.debug.1", (Object)"Exception", (Throwable)ex);
            throw ex;
        }
    }

    public static boolean pingTIBRV(RaLogger log, String service, String network, String daemon) throws Exception {
        try {
            _log = log;
            _log.debug("RepraPingUtil.pingtibco.debug.1", "Service:" + service);
            _log.debug("RepraPingUtil.pingtibco.debug.1", "Network:" + network);
            _log.debug("RepraPingUtil.pingtibco.debug.1", "Daemon:" + daemon);
            Tibrv.open((int)2);
            TibrvRvdTransport rvTransport = new TibrvRvdTransport(service, network, daemon);
            Tibrv.close();
            _log.debug("RepraPingUtil.pingtibco.debug.1", "Ping Tibco Successed");
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraPingUtil.pingtibco.debug.1", (Object)"Exception", (Throwable)ex);
            throw ex;
        }
    }

    public static boolean pingTIBAE(String configFile) throws Exception {
        return false;
    }

    public static boolean pingIBMMQ(RaLogger log, String hostname, String portnumber, String channel, String qmgr, String lqueue, String username, String password) throws Exception {
        try {
            _log = log;
            _log.debug("RepraPingUtil.pingmq.debug.1", "Host:" + hostname);
            _log.debug("RepraPingUtil.pingmq.debug.1", "Port:" + portnumber);
            _log.debug("RepraPingUtil.pingmq.debug.1", "Channel:" + channel);
            _log.debug("RepraPingUtil.pingmq.debug.1", "Qmgr:" + qmgr);
            _log.debug("RepraPingUtil.pingmq.debug.1", "lqueue:" + lqueue);
            _log.debug("RepraPingUtil.pingmq.debug.1", "username:" + username);
            MQEnvironment.hostname = hostname;
            if (portnumber == null || portnumber.equals("\"\"") || portnumber.equals("''")) {
                portnumber = "";
            }
            if (!portnumber.equals("")) {
                MQEnvironment.port = Integer.parseInt(portnumber);
            }
            if (channel == null || channel.equals("\"\"") || channel.equals("''")) {
                channel = "";
            }
            if (!channel.equals("")) {
                MQEnvironment.channel = channel;
            }
            if (username != null && username.equals("")) {
                MQEnvironment.userID = username;
            }
            if (password != null && password.equals("")) {
                MQEnvironment.password = password;
            }
            MQQueueManager queueManager = new MQQueueManager(qmgr);
            _log.debug("RepraPingUtil.pingmq.debug.1", "GotQueueMgr");
            int option = 16;
            MQQueue localQueue = queueManager.accessQueue(lqueue, option);
            queueManager.disconnect();
            _log.debug("RepraPingUtil.pingmq.debug.1", "Ping Succeed");
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraPingUtil.pingmq.debug.1", (Object)"Exception", (Throwable)ex);
            throw ex;
        }
    }

    public static boolean pingIBMMQJMS(RaLogger log, String hostname, String portnumber, String channel, String localClient, String qmgr, String lqueue, String username, String password) throws Exception {
        try {
            _log = log;
            _log.debug("RepraPingUtil.pingmq.debug.1", "Host:" + hostname);
            _log.debug("RepraPingUtil.pingmq.debug.1", "Port:" + portnumber);
            _log.debug("RepraPingUtil.pingmq.debug.1", "Channel:" + channel);
            _log.debug("RepraPingUtil.pingmq.debug.1", "LocalClient:" + localClient);
            _log.debug("RepraPingUtil.pingmq.debug.1", "JMS Qmgr:" + qmgr);
            _log.debug("RepraPingUtil.pingmq.debug.1", "JMS lqueue:" + lqueue);
            _log.debug("RepraPingUtil.pingmq.debug.1", "username:" + username);
            MQQueueConnectionFactory factory = null;
            QueueSession session = null;
            QueueConnection connection = null;
            Queue queue = null;
            ConfigEnvironment.start();
            factory = new MQQueueConnectionFactory();
            if (localClient.equals("true")) {
                ((MQConnectionFactory)factory).setTransportType(1);
            }
            ((MQConnectionFactory)factory).setQueueManager(qmgr);
            ((MQConnectionFactory)factory).setHostName(hostname);
            if (portnumber == null || portnumber.equals("\"\"") || portnumber.equals("''")) {
                portnumber = "";
            }
            if (!portnumber.equals("")) {
                ((MQConnectionFactory)factory).setPort(Integer.parseInt(portnumber));
            }
            if (channel == null || channel.equals("\"\"") || channel.equals("''")) {
                channel = "";
            }
            if (!channel.equals("")) {
                ((MQConnectionFactory)factory).setChannel(channel);
            }
            connection = username == null || username.trim().equals("") ? factory.createQueueConnection() : factory.createQueueConnection(username, password);
            connection.start();
            session = connection.createQueueSession(false, 1);
            queue = session.createQueue(lqueue);
            connection.close();
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraPingUtil.pingmq.debug.1", (Object)"Exception", (Throwable)ex);
            throw ex;
        }
    }

    public static boolean pingDB(RaLogger log, String url, String jdbcDriver, String username, String password) throws Exception {
        Connection conn = null;
        try {
            _log = log;
            Class.forName(jdbcDriver);
            _log.debug("RepraPingUtil.pingdb.debug.1", "URL:" + url);
            _log.debug("RepraPingUtil.pingdb.debug.1", "UserName:" + username);
            _log.debug("RepraPingUtil.pingdb.debug.1", "Driver Class:" + jdbcDriver);
            conn = DriverManager.getConnection(url, username, password);
            conn.close();
            _log.debug("RepraPingUtil.pingdb.debug.1", "Ping succeed");
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraPingUtil.pingdb.debug.1", (Object)"Exception", (Throwable)ex);
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception sqlex) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }
}

