/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;
    static final long serialVersionUID = -8144641928112860441L;

    public SerialBlob(byte[] byArray) throws SerialException, SQLException {
        this.len = byArray.length;
        this.buf = new byte[(int)this.len];
        int n = 0;
        while ((long)n < this.len) {
            this.buf[n] = byArray[n];
            ++n;
        }
        this.origLen = this.len;
    }

    public SerialBlob(Blob blob) throws SerialException, SQLException {
        if (blob == null) {
            throw new SQLException("Cannot instantiate a SerialBlob object with a null Blob object");
        }
        this.len = blob.length();
        this.buf = blob.getBytes(1L, (int)this.len);
        this.blob = blob;
        this.origLen = this.len;
    }

    public byte[] getBytes(long l, int n) throws SerialException {
        if ((long)n > this.len) {
            n = (int)this.len;
        }
        if (l < 1L || (long)n - l < 0L) {
            throw new SerialException("Invalid arguments: position cannot be less that 1");
        }
        --l;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.buf[(int)l];
            ++l;
        }
        return byArray;
    }

    public long length() throws SerialException {
        return this.len;
    }

    public InputStream getBinaryStream() throws SerialException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        return byteArrayInputStream;
    }

    public long position(byte[] byArray, long l) throws SerialException, SQLException {
        if (l < 1L || l > this.len) {
            return -1L;
        }
        int n = (int)l - 1;
        int n2 = 0;
        long l2 = byArray.length;
        while ((long)n < this.len) {
            if (byArray[n2] == this.buf[n]) {
                if ((long)(n2 + 1) == l2) {
                    return (long)(n + 1) - (l2 - 1L);
                }
                ++n2;
                ++n;
                continue;
            }
            if (byArray[n2] == this.buf[n]) continue;
            ++n;
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SerialException, SQLException {
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    public int setBytes(long l, byte[] byArray) throws SerialException, SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SerialException, SQLException {
        int n3;
        if (n < 0 || n > byArray.length) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if (l < 1L || l > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if ((long)n2 > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (n2 + n > byArray.length) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset and length that is greater that the Blob buffer");
        }
        --l;
        for (n3 = 0; n3 < n2 || n + n3 + 1 < byArray.length - n; ++n3) {
            this.buf[(int)l + n3] = byArray[n + n3];
        }
        return n3;
    }

    public OutputStream setBinaryStream(long l) throws SerialException, SQLException {
        if (this.blob.setBinaryStream(l) != null) {
            return this.blob.setBinaryStream(l);
        }
        throw new SerialException("Unsupported operation. SerialBlob cannot return a writable binary stream, unless instantiated with a Blob object that provides a setBinaryStream() implementation");
    }

    public void truncate(long l) throws SerialException {
        if (l > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        if ((int)l == 0) {
            this.buf = new byte[0];
            this.len = l;
        } else {
            this.len = l;
            this.buf = this.getBytes(1L, (int)this.len);
        }
    }
}

