/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import javax.swing.SpringLayout;

public abstract class Spring {
    public static final int UNSET = Integer.MIN_VALUE;

    protected Spring() {
    }

    public abstract int getMinimumValue();

    public abstract int getPreferredValue();

    public abstract int getMaximumValue();

    public abstract int getValue();

    public abstract void setValue(int var1);

    private double range(boolean bl) {
        return bl ? (double)(this.getPreferredValue() - this.getMinimumValue()) : (double)(this.getMaximumValue() - this.getPreferredValue());
    }

    double getStrain() {
        double d = this.getValue() - this.getPreferredValue();
        return d / this.range(this.getValue() < this.getPreferredValue());
    }

    void setStrain(double d) {
        this.setValue(this.getPreferredValue() + (int)(d * this.range(d < 0.0)));
    }

    boolean isCyclic(SpringLayout springLayout) {
        return false;
    }

    public static Spring constant(int n) {
        return Spring.constant(n, n, n);
    }

    public static Spring constant(int n, int n2, int n3) {
        return new StaticSpring(n, n2, n3);
    }

    public static Spring minus(Spring spring) {
        return new NegativeSpring(spring);
    }

    public static Spring sum(Spring spring, Spring spring2) {
        return new SumSpring(spring, spring2);
    }

    public static Spring max(Spring spring, Spring spring2) {
        return new MaxSpring(spring, spring2);
    }

    static Spring difference(Spring spring, Spring spring2) {
        return Spring.sum(spring, Spring.minus(spring2));
    }

    public static Spring scale(Spring spring, float f) {
        Spring.checkArg(spring);
        return new ScaleSpring(spring, f);
    }

    public static Spring width(Component component) {
        Spring.checkArg(component);
        return new WidthSpring(component);
    }

    public static Spring height(Component component) {
        Spring.checkArg(component);
        return new HeightSpring(component);
    }

    private static void checkArg(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument must not be null");
        }
    }

    static abstract class AbstractSpring
    extends Spring {
        protected int size = Integer.MIN_VALUE;

        AbstractSpring() {
        }

        public int getValue() {
            return this.size != Integer.MIN_VALUE ? this.size : this.getPreferredValue();
        }

        public void setValue(int n) {
            if (n == Integer.MIN_VALUE) {
                this.clear();
                return;
            }
            this.size = n;
        }

        protected void clear() {
            this.size = Integer.MIN_VALUE;
        }
    }

    static abstract class CompoundSpring
    extends StaticSpring {
        protected Spring s1;
        protected Spring s2;

        public CompoundSpring(Spring spring, Spring spring2) {
            this.clear();
            this.s1 = spring;
            this.s2 = spring2;
        }

        public String toString() {
            return "CompoundSpring of " + this.s1 + " and " + this.s2;
        }

        protected void clear() {
            this.size = Integer.MIN_VALUE;
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
        }

        public void setValue(int n) {
            if (n == Integer.MIN_VALUE && this.size != Integer.MIN_VALUE) {
                super.setValue(n);
                this.s1.setValue(Integer.MIN_VALUE);
                this.s2.setValue(Integer.MIN_VALUE);
                return;
            }
            super.setValue(n);
        }

        protected abstract int op(int var1, int var2);

        public int getMinimumValue() {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.op(this.s1.getMinimumValue(), this.s2.getMinimumValue());
            }
            return this.min;
        }

        public int getPreferredValue() {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.op(this.s1.getPreferredValue(), this.s2.getPreferredValue());
            }
            return this.pref;
        }

        public int getMaximumValue() {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.op(this.s1.getMaximumValue(), this.s2.getMaximumValue());
            }
            return this.max;
        }

        public int getValue() {
            if (this.size == Integer.MIN_VALUE) {
                this.size = this.op(this.s1.getValue(), this.s2.getValue());
            }
            return this.size;
        }

        boolean isCyclic(SpringLayout springLayout) {
            return springLayout.isCyclic(this.s1) || springLayout.isCyclic(this.s2);
        }
    }

    static class HeightSpring
    extends AbstractSpring {
        Component c;

        public HeightSpring(Component component) {
            this.c = component;
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().height;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().height;
        }

        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().height);
        }
    }

    private static class MaxSpring
    extends CompoundSpring {
        public MaxSpring(Spring spring, Spring spring2) {
            super(spring, spring2);
        }

        protected int op(int n, int n2) {
            return Math.max(n, n2);
        }

        public void setValue(int n) {
            super.setValue(n);
            if (n == Integer.MIN_VALUE) {
                return;
            }
            if (this.s1.getPreferredValue() < this.s2.getPreferredValue()) {
                this.s1.setValue(Math.min(n, this.s1.getPreferredValue()));
                this.s2.setValue(n);
            } else {
                this.s1.setValue(n);
                this.s2.setValue(Math.min(n, this.s2.getPreferredValue()));
            }
        }
    }

    private static class NegativeSpring
    extends Spring {
        private Spring s;

        public NegativeSpring(Spring spring) {
            this.s = spring;
        }

        public int getMinimumValue() {
            return -this.s.getMaximumValue();
        }

        public int getPreferredValue() {
            return -this.s.getPreferredValue();
        }

        public int getMaximumValue() {
            return -this.s.getMinimumValue();
        }

        public int getValue() {
            return -this.s.getValue();
        }

        public void setValue(int n) {
            this.s.setValue(-n);
        }

        boolean isCyclic(SpringLayout springLayout) {
            return this.s.isCyclic(springLayout);
        }
    }

    private static class ScaleSpring
    extends Spring {
        private Spring s;
        private float factor;

        private ScaleSpring(Spring spring, float f) {
            this.s = spring;
            this.factor = f;
        }

        public int getMinimumValue() {
            return Math.round((float)(this.factor < 0.0f ? this.s.getMaximumValue() : this.s.getMinimumValue()) * this.factor);
        }

        public int getPreferredValue() {
            return Math.round((float)this.s.getPreferredValue() * this.factor);
        }

        public int getMaximumValue() {
            return Math.round((float)(this.factor < 0.0f ? this.s.getMinimumValue() : this.s.getMaximumValue()) * this.factor);
        }

        public int getValue() {
            return Math.round((float)this.s.getValue() * this.factor);
        }

        public void setValue(int n) {
            if (n == Integer.MIN_VALUE) {
                this.s.setValue(Integer.MIN_VALUE);
            } else {
                this.s.setValue(Math.round((float)n / this.factor));
            }
        }

        boolean isCyclic(SpringLayout springLayout) {
            return this.s.isCyclic(springLayout);
        }
    }

    private static class StaticSpring
    extends AbstractSpring {
        protected int min;
        protected int pref;
        protected int max;

        public StaticSpring() {
        }

        public StaticSpring(int n) {
            this(n, n, n);
        }

        public StaticSpring(int n, int n2, int n3) {
            this.min = n;
            this.pref = n2;
            this.max = n3;
            this.size = n2;
        }

        public String toString() {
            return "StaticSpring [" + this.min + ", " + this.pref + ", " + this.max + "]";
        }

        public int getMinimumValue() {
            return this.min;
        }

        public int getPreferredValue() {
            return this.pref;
        }

        public int getMaximumValue() {
            return this.max;
        }
    }

    private static class SumSpring
    extends CompoundSpring {
        public SumSpring(Spring spring, Spring spring2) {
            super(spring, spring2);
        }

        protected int op(int n, int n2) {
            return n + n2;
        }

        public void setValue(int n) {
            super.setValue(n);
            if (n == Integer.MIN_VALUE) {
                return;
            }
            this.s1.setStrain(this.getStrain());
            this.s2.setValue(n - this.s1.getValue());
        }
    }

    static class WidthSpring
    extends AbstractSpring {
        Component c;

        public WidthSpring(Component component) {
            this.c = component;
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().width;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().width;
        }

        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().width);
        }
    }
}

