/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FramePeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import sun.awt.NullComponentPeer;
import sun.awt.SunToolkit;

public abstract class EmbeddedFrame
extends Frame
implements KeyEventDispatcher,
PropertyChangeListener {
    private boolean isCursorAllowed = true;
    private static Field fieldPeer;
    private static Field currentCycleRoot;
    private boolean supportsXEmbed = false;
    private KeyboardFocusManager appletKFM;
    private static final long serialVersionUID = 2967042741780317130L;
    protected static final boolean FORWARD = true;
    protected static final boolean BACKWARD = false;

    public boolean supportsXEmbed() {
        return this.supportsXEmbed && SunToolkit.needsXEmbed();
    }

    protected EmbeddedFrame(boolean bl) {
        this(0L, bl);
    }

    protected EmbeddedFrame() {
        this(0L);
    }

    @Deprecated
    protected EmbeddedFrame(int n) {
        this((long)n);
    }

    protected EmbeddedFrame(long l) {
        this(l, false);
    }

    protected EmbeddedFrame(long l, boolean bl) {
        this.supportsXEmbed = bl;
    }

    public Container getParent() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("managingFocus")) {
            return;
        }
        if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
            return;
        }
        this.removeTraversingOutListeners((KeyboardFocusManager)propertyChangeEvent.getSource());
        this.appletKFM = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (this.isVisible()) {
            this.addTraversingOutListeners(this.appletKFM);
        }
    }

    private void addTraversingOutListeners(KeyboardFocusManager keyboardFocusManager) {
        keyboardFocusManager.addKeyEventDispatcher(this);
        keyboardFocusManager.addPropertyChangeListener("managingFocus", this);
    }

    private void removeTraversingOutListeners(KeyboardFocusManager keyboardFocusManager) {
        keyboardFocusManager.removeKeyEventDispatcher(this);
        keyboardFocusManager.removePropertyChangeListener("managingFocus", this);
    }

    public void registerListeners() {
        if (this.appletKFM != null) {
            this.removeTraversingOutListeners(this.appletKFM);
        }
        this.appletKFM = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (this.isVisible()) {
            this.addTraversingOutListeners(this.appletKFM);
        }
    }

    public void show() {
        if (this.appletKFM != null) {
            this.addTraversingOutListeners(this.appletKFM);
        }
        super.show();
    }

    public void hide() {
        if (this.appletKFM != null) {
            this.removeTraversingOutListeners(this.appletKFM);
        }
        super.hide();
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Container container;
        block9: {
            if (currentCycleRoot == null) {
                currentCycleRoot = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        block5: {
                            try {
                                Field field = KeyboardFocusManager.class.getDeclaredField("currentFocusCycleRoot");
                                if (field != null) {
                                    field.setAccessible(true);
                                }
                                return field;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                assert (false);
                            }
                            catch (SecurityException securityException) {
                                if ($assertionsDisabled) break block5;
                                throw new AssertionError();
                            }
                        }
                        return null;
                    }
                });
            }
            container = null;
            if (currentCycleRoot != null) {
                try {
                    container = (Container)currentCycleRoot.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
        }
        if (this != container) {
            return false;
        }
        if (keyEvent.getID() == 400) {
            return false;
        }
        if (!this.getFocusTraversalKeysEnabled() || keyEvent.isConsumed()) {
            return false;
        }
        AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
        Component component = keyEvent.getComponent();
        Component component2 = this.getFocusTraversalPolicy().getLastComponent(this);
        Set<AWTKeyStroke> set = this.getFocusTraversalKeys(0);
        if (set.contains(aWTKeyStroke) && (component == component2 || component2 == null) && this.traverseOut(true)) {
            keyEvent.consume();
            return true;
        }
        Component component3 = this.getFocusTraversalPolicy().getFirstComponent(this);
        set = this.getFocusTraversalKeys(1);
        if (set.contains(aWTKeyStroke) && (component == component3 || component3 == null) && this.traverseOut(false)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    protected boolean traverseOut(boolean bl) {
        return false;
    }

    public void setTitle(String string) {
    }

    public void setIconImage(Image image) {
    }

    public void setMenuBar(MenuBar menuBar) {
    }

    public void setResizable(boolean bl) {
    }

    public void remove(MenuComponent menuComponent) {
    }

    public boolean isResizable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getPeer() == null) {
                this.setPeer(new NullEmbeddedFramePeer());
            }
            super.addNotify();
        }
    }

    public void setCursorAllowed(boolean bl) {
        this.isCursorAllowed = bl;
        this.getPeer().updateCursorImmediately();
    }

    public boolean isCursorAllowed() {
        return this.isCursorAllowed;
    }

    public Cursor getCursor() {
        return this.isCursorAllowed ? super.getCursor() : Cursor.getPredefinedCursor(0);
    }

    protected void setPeer(ComponentPeer componentPeer) {
        block4: {
            if (fieldPeer == null) {
                fieldPeer = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        block5: {
                            try {
                                Field field = Component.class.getDeclaredField("peer");
                                if (field != null) {
                                    field.setAccessible(true);
                                }
                                return field;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                assert (false);
                            }
                            catch (SecurityException securityException) {
                                if ($assertionsDisabled) break block5;
                                throw new AssertionError();
                            }
                        }
                        return null;
                    }
                });
            }
            try {
                if (fieldPeer != null) {
                    fieldPeer.set(this, componentPeer);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void synthesizeWindowActivation(boolean bl) {
    }

    protected void setLocationPrivate(int n, int n2) {
        Dimension dimension = this.getSize();
        this.setBoundsPrivate(n, n2, dimension.width, dimension.height);
    }

    protected void setBoundsPrivate(int n, int n2, int n3, int n4) {
        FramePeer framePeer = (FramePeer)this.getPeer();
        if (framePeer != null) {
            framePeer.setBoundsPrivate(n, n2, n3, n4);
        }
    }

    public void toFront() {
    }

    public void toBack() {
    }

    private static class NullEmbeddedFramePeer
    extends NullComponentPeer
    implements FramePeer {
        private NullEmbeddedFramePeer() {
        }

        public void setTitle(String string) {
        }

        public void setIconImage(Image image) {
        }

        public void setMenuBar(MenuBar menuBar) {
        }

        public void setResizable(boolean bl) {
        }

        public void setState(int n) {
        }

        public int getState() {
            return 0;
        }

        public void setMaximizedBounds(Rectangle rectangle) {
        }

        public void toFront() {
        }

        public void toBack() {
        }

        public void updateFocusableWindowState() {
        }

        public void updateAlwaysOnTop() {
        }

        public Component getGlobalHeavyweightFocusOwner() {
            return null;
        }

        public void setBoundsPrivate(int n, int n2, int n3, int n4) {
            this.setBounds(n, n2, n3, n4, 3);
        }

        public void restack() {
            throw new UnsupportedOperationException();
        }

        public boolean isRestackSupported() {
            return false;
        }

        public boolean requestWindowFocus() {
            return false;
        }
    }
}

