/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ExceptionHandler;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.InputPatchPage;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.internal.patch.PreviewPatchPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class PatchWizard
extends Wizard {
    private static final String DIALOG_SETTINGS_KEY = "PatchWizard";
    private boolean fHasNewDialogSettings;
    private InputPatchPage fPatchWizardPage;
    private Patcher fPatcher;
    private IResource fTarget;

    PatchWizard(ISelection selection) {
        this.setDefaultPageImageDescriptor(CompareUIPlugin.getImageDescriptor("wizban/applypatch_wizban.gif"));
        this.setWindowTitle(PatchMessages.PatchWizard_title);
        this.setTargets(Utilities.getResources(selection));
        this.fPatcher = new Patcher();
        IDialogSettings workbenchSettings = CompareUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    Patcher getPatcher() {
        return this.fPatcher;
    }

    IResource getTarget() {
        return this.fTarget;
    }

    void setTargets(IResource[] targets) {
        if (targets != null && targets.length > 0) {
            this.fTarget = targets[0];
        }
    }

    public void addPages() {
        super.addPages();
        this.fPatchWizardPage = new InputPatchPage(this);
        this.addPage((IWizardPage)this.fPatchWizardPage);
        this.addPage((IWizardPage)new PreviewPatchPage(this));
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        this.fPatcher.setName(this.fPatchWizardPage.getPatchName());
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation((ISchedulingRule)this.fTarget.getProject()){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        PatchWizard.this.fPatcher.applyAll(PatchWizard.this.getTarget(), monitor, PatchWizard.this.getShell(), PatchMessages.PatchWizard_title);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, PatchMessages.PatchWizard_title, PatchMessages.PatchWizard_unexpectedException_message);
        }
        catch (InterruptedException interruptedException) {}
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = CompareUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fPatchWizardPage.saveWidgetValues();
        return true;
    }
}

