/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistry;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistryReader;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.part.FileEditorInput;

public final class IDE {
    public static final QualifiedName EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    public static final String EDITOR_ID_ATTR = "org.eclipse.ui.editorID";
    public static final String RESOURCE_PERSPECTIVE_ID = "org.eclipse.ui.resourcePerspective";
    private static MarkerHelpRegistry markerHelpRegistry = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private IDE() {
    }

    public static IMarkerHelpRegistry getMarkerHelpRegistry() {
        if (markerHelpRegistry == null) {
            markerHelpRegistry = new MarkerHelpRegistry();
            new MarkerHelpRegistryReader().addHelp(markerHelpRegistry);
        }
        return markerHelpRegistry;
    }

    public static void gotoMarker(IEditorPart editor, IMarker marker) {
        IGotoMarker gotoMarker = null;
        if (editor instanceof IGotoMarker) {
            gotoMarker = (IGotoMarker)editor;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            gotoMarker = (IGotoMarker)editor.getAdapter((Class)clazz);
        }
        if (gotoMarker != null) {
            gotoMarker.gotoMarker(marker);
        }
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String editorId) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor(input, editorId);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String editorId, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor(input, editorId, activate);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, boolean activate) throws PartInitException {
        return IDE.openEditor(page, input, activate, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, boolean activate, boolean determineContentType) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor editorDesc = IDE.getEditorDescriptor(input, determineContentType);
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorDesc.getId(), activate);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor editorDesc = IDE.getEditorDescriptor(input);
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorDesc.getId());
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, String editorId) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorId);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, String editorId, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorId, activate);
    }

    public static IEditorDescriptor getEditorDescriptor(IFile file) throws PartInitException {
        return IDE.getEditorDescriptor(file, true);
    }

    public static IEditorDescriptor getEditorDescriptor(IFile file, boolean determineContentType) throws PartInitException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        return IDE.getEditorDescriptor(file.getName(), PlatformUI.getWorkbench().getEditorRegistry(), IDE.getDefaultEditor(file, determineContentType));
    }

    public static IEditorDescriptor getEditorDescriptor(String name) throws PartInitException {
        return IDE.getEditorDescriptor(name, true);
    }

    public static IEditorDescriptor getEditorDescriptor(String name, boolean inferContentType) throws PartInitException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = inferContentType ? Platform.getContentTypeManager().findContentTypeFor(name) : null;
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        return IDE.getEditorDescriptor(name, editorReg, editorReg.getDefaultEditor(name, contentType));
    }

    private static IEditorDescriptor getEditorDescriptor(String name, IEditorRegistry editorReg, IEditorDescriptor defaultDescriptor) throws PartInitException {
        if (defaultDescriptor != null) {
            return defaultDescriptor;
        }
        IEditorDescriptor editorDesc = defaultDescriptor;
        if (editorReg.isSystemInPlaceEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDesc == null && editorReg.isSystemExternalEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDesc == null) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (editorDesc == null) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
        }
        return editorDesc;
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IMarker marker) throws PartInitException {
        return IDE.openEditor(page, marker, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IMarker marker, boolean activate) throws PartInitException {
        if (page == null || marker == null) {
            throw new IllegalArgumentException();
        }
        if (!(marker.getResource() instanceof IFile)) {
            IDEWorkbenchPlugin.log("Open editor on marker failed; marker resource not an IFile");
            return null;
        }
        IFile file = (IFile)marker.getResource();
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = null;
        try {
            String editorID = (String)marker.getAttribute(EDITOR_ID_ATTR);
            if (editorID != null) {
                editorDesc = editorReg.findEditor(editorID);
            }
        }
        catch (CoreException coreException) {}
        IEditorPart editor = null;
        editor = editorDesc == null ? IDE.openEditor(page, file, activate) : page.openEditor((IEditorInput)new FileEditorInput(file), editorDesc.getId(), activate);
        if (editor != null) {
            IDE.gotoMarker(editor, marker);
        }
        return editor;
    }

    public static boolean saveAllEditors(IResource[] resourceRoots, boolean confirm) {
        final IResource[] finalResources = resourceRoots;
        final boolean finalConfirm = confirm;
        final boolean[] result = new boolean[]{true};
        if (resourceRoots.length == 0) {
            return result[0];
        }
        Platform.run((ISafeRunnable)new SafeRunnable(IDEWorkbenchMessages.ErrorClosing){

            public void run() {
                ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchWindow window = windows[i];
                    IWorkbenchPage[] pages = window.getPages();
                    int j = 0;
                    while (j < pages.length) {
                        IWorkbenchPage page = pages[j];
                        IEditorPart[] dirty = page.getDirtyEditors();
                        int k = 0;
                        while (k < dirty.length) {
                            IEditorPart part = dirty[k];
                            IFile file = ResourceUtil.getFile(part.getEditorInput());
                            if (file != null) {
                                int l = 0;
                                while (l < finalResources.length) {
                                    IResource resource = finalResources[l];
                                    if (resource.getFullPath().isPrefixOf(file.getFullPath())) {
                                        dirtyEditors.add(part);
                                        break;
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (dirtyEditors.size() > 0) {
                    IWorkbenchWindow w = Workbench.getInstance().getActiveWorkbenchWindow();
                    if (w == null) {
                        w = windows[0];
                    }
                    result[0] = EditorManager.saveAll(dirtyEditors, (boolean)finalConfirm, (IWorkbenchWindow)w);
                }
            }
        });
        return result[0];
    }

    public static void setDefaultEditor(IFile file, String editorID) {
        try {
            file.setPersistentProperty(EDITOR_KEY, editorID);
        }
        catch (CoreException coreException) {}
    }

    public static IEditorDescriptor getDefaultEditor(IFile file) {
        return IDE.getDefaultEditor(file, true);
    }

    public static IEditorDescriptor getDefaultEditor(IFile file, boolean determineContentType) {
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        try {
            IEditorDescriptor desc;
            String editorID = file.getPersistentProperty(EDITOR_KEY);
            if (editorID != null && (desc = editorReg.findEditor(editorID)) != null) {
                return desc;
            }
        }
        catch (CoreException coreException) {}
        IContentType contentType = null;
        if (determineContentType) {
            contentType = IDE.getContentType(file);
        }
        return editorReg.getDefaultEditor(file.getName(), contentType);
    }

    public static List computeSelectedResources(IStructuredSelection originalSelection) {
        ArrayList<Object> resources = null;
        Iterator e = originalSelection.iterator();
        while (e.hasNext()) {
            Object next = e.next();
            Object resource = null;
            if (next instanceof IResource) {
                resource = next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = iAdaptable.getAdapter((Class)clazz);
            }
            if (resource == null) continue;
            if (resources == null) {
                resources = new ArrayList<Object>(originalSelection.size());
            }
            resources.add(resource);
        }
        if (resources == null) {
            return Collections.EMPTY_LIST;
        }
        return resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IContentType getContentType(IFile file) {
        IContentType iContentType;
        block6: {
            IContentType iContentType2;
            block5: {
                try {
                    try {
                        UIStats.start((int)14, (String)file.getName());
                        IContentDescription contentDescription = file.getContentDescription();
                        if (contentDescription == null) {
                            iContentType2 = null;
                            Object var2_5 = null;
                            break block5;
                        }
                        iContentType = contentDescription.getContentType();
                        break block6;
                    }
                    catch (CoreException coreException) {
                        IContentType iContentType3 = null;
                        Object var2_7 = null;
                        UIStats.end((int)14, (Object)file, (String)file.getName());
                        return iContentType3;
                    }
                }
                catch (Throwable throwable) {
                    Object var2_8 = null;
                    UIStats.end((int)14, (Object)file, (String)file.getName());
                    throw throwable;
                }
            }
            UIStats.end((int)14, (Object)file, (String)file.getName());
            return iContentType2;
        }
        Object var2_6 = null;
        UIStats.end((int)14, (Object)file, (String)file.getName());
        return iContentType;
    }

    public static interface SharedImages {
        public static final String IMG_OBJ_PROJECT = "IMG_OBJ_PROJECT";
        public static final String IMG_OBJ_PROJECT_CLOSED = "IMG_OBJ_PROJECT_CLOSED";
        public static final String IMG_OPEN_MARKER = "IMG_OPEN_MARKER";
        public static final String IMG_OBJS_TASK_TSK = "IMG_OBJS_TASK_TSK";
        public static final String IMG_OBJS_BKMRK_TSK = "IMG_OBJS_BKMRK_TSK";
    }

    public static interface Preferences {
        public static final String PROJECT_OPEN_NEW_PERSPECTIVE = "PROJECT_OPEN_NEW_PERSPECTIVE";
        public static final String SHOW_WORKSPACE_SELECTION_DIALOG = "SHOW_WORKSPACE_SELECTION_DIALOG";
        public static final String MAX_RECENT_WORKSPACES = "MAX_RECENT_WORKSPACES";
        public static final String RECENT_WORKSPACES = "RECENT_WORKSPACES";
        public static final String RECENT_WORKSPACES_PROTOCOL = "RECENT_WORKSPACES_PROTOCOL";
    }
}

