/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.ide.Category;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateProjectStep;
import org.eclipse.ui.internal.ide.dialogs.InstallCapabilityStep;
import org.eclipse.ui.internal.ide.dialogs.MultiStepCapabilityWizard;
import org.eclipse.ui.internal.ide.dialogs.WizardNewProjectCapabilityPage;
import org.eclipse.ui.internal.ide.dialogs.WizardNewProjectNameAndLocationPage;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;

public class NewProjectWizard
extends MultiStepCapabilityWizard
implements INewWizard {
    private IWorkbench workbench;
    private WizardNewProjectNameAndLocationPage creationPage;
    private WizardNewProjectCapabilityPage capabilityPage;
    private IProject newProject;
    private String initialProjectName;
    private Capability[] initialProjectCapabilities;
    private Category[] initialSelectedCategories;

    public NewProjectWizard() {
        IDEWorkbenchPlugin plugin = IDEWorkbenchPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewProjectWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewProjectWizard");
        }
        this.setDialogSettings(section);
    }

    protected void addCustomPages() {
        this.creationPage = new WizardNewProjectNameAndLocationPage("newProjectCreationPage");
        this.creationPage.setTitle(IDEWorkbenchMessages.NewProjectWizard_title);
        this.creationPage.setDescription(IDEWorkbenchMessages.WizardNewProjectCreationPage_description);
        this.creationPage.setInitialProjectName(this.initialProjectName);
        this.addPage((IWizardPage)this.creationPage);
        this.capabilityPage = new WizardNewProjectCapabilityPage("newProjectCapabilityPage");
        this.capabilityPage.setTitle(IDEWorkbenchMessages.NewProjectWizard_title);
        this.capabilityPage.setDescription(IDEWorkbenchMessages.WizardNewProjectCapabilityPage_description);
        this.capabilityPage.setInitialProjectCapabilities(this.initialProjectCapabilities);
        this.capabilityPage.setInitialSelectedCategories(this.initialSelectedCategories);
        this.addPage((IWizardPage)this.capabilityPage);
    }

    private boolean buildSteps() {
        Capability[] caps = this.capabilityPage.getSelectedCapabilities();
        CapabilityRegistry reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
        IStatus status = reg.validateCapabilities(caps);
        if (status.isOK()) {
            Capability[] results = reg.pruneCapabilities(caps);
            WizardStep[] steps = new WizardStep[results.length + 1];
            steps[0] = new CreateProjectStep(1, this.creationPage, this);
            int i = 0;
            while (i < results.length) {
                steps[i + 1] = new InstallCapabilityStep(i + 2, results[i], this.workbench, this);
                ++i;
            }
            this.setSteps(steps);
            return true;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewProjectWizard_errorTitle, (String)IDEWorkbenchMessages.NewProjectWizard_invalidCapabilities, (IStatus)status);
        return false;
    }

    protected boolean canFinishOnReviewPage() {
        return this.getSteps().length == 1;
    }

    protected String getConfigurePageTitle() {
        return IDEWorkbenchMessages.NewProjectWizard_title;
    }

    protected String getConfigurePageDescription() {
        return IDEWorkbenchMessages.WizardProjectConfigurePage_description;
    }

    protected String getReviewPageTitle() {
        return IDEWorkbenchMessages.NewProjectWizard_title;
    }

    protected String getReviewPageDescription() {
        return IDEWorkbenchMessages.WizardProjectReviewPage_description;
    }

    protected String getFinishStepLabel(WizardStep[] steps) {
        if (steps.length > 2) {
            return super.getFinishStepLabel(steps);
        }
        return null;
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    protected String[] getPerspectiveChoices() {
        ArrayList<String> results = new ArrayList<String>();
        Capability[] caps = this.capabilityPage.getSelectedCapabilities();
        int i = 0;
        while (i < caps.length) {
            ArrayList ids = caps[i].getPerspectiveChoices();
            if (ids != null) {
                Iterator it = ids.iterator();
                while (it.hasNext()) {
                    String id = (String)it.next();
                    if (results.contains(id)) continue;
                    results.add(id);
                }
            }
            ++i;
        }
        String[] ids = new String[results.size()];
        results.toArray(ids);
        return ids;
    }

    public IProject getProject() {
        return this.newProject;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.capabilityPage && !this.buildSteps()) {
            return this.capabilityPage;
        }
        return super.getNextPage(page);
    }

    boolean handleMissingStepWizard(WizardStep step) {
        MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewProjectWizard_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.NewProjectWizard_noWizard, (Object)step.getLabel()));
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.initializeDefaultPageImageDescriptor();
        this.setWindowTitle(IDEWorkbenchMessages.NewProjectWizard_windowTitle);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor("wizban/newprj_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void setInitialSelectedCategories(Category[] categories) {
        this.initialSelectedCategories = categories;
    }

    public void setInitialProjectCapabilities(Capability[] capabilities) {
        this.initialProjectCapabilities = capabilities;
    }

    public void setInitialProjectName(String name) {
        this.initialProjectName = name == null ? null : name.trim();
    }

    void setNewProject(IProject project) {
        this.newProject = project;
    }
}

