/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class WorkbenchContentProvider
extends BaseWorkbenchContentProvider
implements IResourceChangeListener {
    private Viewer viewer;

    public void dispose() {
        if (this.viewer != null) {
            IWorkspace workspace = null;
            Object obj = this.viewer.getInput();
            if (obj instanceof IWorkspace) {
                workspace = (IWorkspace)obj;
            } else if (obj instanceof IContainer) {
                workspace = ((IContainer)obj).getWorkspace();
            }
            if (workspace != null) {
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
        super.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer;
        IWorkspace oldWorkspace = null;
        IWorkspace newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = (IWorkspace)oldInput;
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = ((IContainer)oldInput).getWorkspace();
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        }
        if (oldWorkspace != newWorkspace) {
            if (oldWorkspace != null) {
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }
    }

    public final void resourceChanged(IResourceChangeEvent event) {
        this.processDelta(event.getDelta());
    }

    protected void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final ArrayList runnables = new ArrayList();
        this.processDelta(delta, runnables);
        if (runnables.isEmpty()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.runUpdates(runnables);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Control ctrl = WorkbenchContentProvider.this.viewer.getControl();
                    if (ctrl == null || ctrl.isDisposed()) {
                        return;
                    }
                    WorkbenchContentProvider.this.runUpdates(runnables);
                }
            });
        }
    }

    private void runUpdates(Collection runnables) {
        Iterator runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
        }
    }

    private void processDelta(IResourceDelta delta, Collection runnables) {
        Object[] removedObjects;
        int i;
        Object[] addedObjects;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            if ((affectedChildren[i2].getFlags() & 0x8000) != 0) {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
            ++i2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x9C000) != 0) {
            Runnable updateRunnable = new Runnable(){

                public void run() {
                    ((StructuredViewer)WorkbenchContentProvider.this.viewer).update((Object)resource, null);
                }
            };
            runnables.add(updateRunnable);
        }
        if ((changeFlags & 0x40000) != 0) {
            runnables.add(this.getRefreshRunnable(resource));
            return;
        }
        int i3 = 0;
        while (i3 < affectedChildren.length) {
            this.processDelta(affectedChildren[i3], runnables);
            ++i3;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
        if (addedChildren.length == 0 && removedChildren.length == 0) {
            return;
        }
        int numMovedFrom = 0;
        int numMovedTo = 0;
        if (addedChildren.length > 0) {
            addedObjects = new Object[addedChildren.length];
            i = 0;
            while (i < addedChildren.length) {
                addedObjects[i] = addedChildren[i].getResource();
                if ((addedChildren[i].getFlags() & 0x1000) != 0) {
                    ++numMovedFrom;
                }
                ++i;
            }
        } else {
            addedObjects = new Object[]{};
        }
        if (removedChildren.length > 0) {
            removedObjects = new Object[removedChildren.length];
            i = 0;
            while (i < removedChildren.length) {
                removedObjects[i] = removedChildren[i].getResource();
                if ((removedChildren[i].getFlags() & 0x2000) != 0) {
                    ++numMovedTo;
                }
                ++i;
            }
        } else {
            removedObjects = new Object[]{};
        }
        final boolean hasRename = numMovedFrom > 0 && numMovedTo > 0;
        Runnable addAndRemove = new Runnable(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 102->108)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        runnables.add(addAndRemove);
    }

    private Runnable getRefreshRunnable(final IResource resource) {
        return new Runnable(){

            public void run() {
                ((StructuredViewer)WorkbenchContentProvider.this.viewer).refresh((Object)resource);
            }
        };
    }
}

