/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.util;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JUnitStubUtility {
    public static GenStubSettings getCodeGenerationSettings(IJavaProject project) {
        return new GenStubSettings(project);
    }

    public static String formatCompilationUnit(IJavaProject project, String sourceString, String lineDelim) {
        return JUnitStubUtility.codeFormat(project, sourceString, 8, 0, lineDelim);
    }

    public static String codeFormat(IJavaProject project, String sourceString, int kind, int initialIndentationLevel, String lineDelim) {
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)project.getOptions(true));
        TextEdit edit = formatter.format(kind, sourceString, 0, sourceString.length(), initialIndentationLevel, lineDelim);
        if (edit != null) {
            Document doc = new Document(sourceString);
            try {
                edit.apply((IDocument)doc);
                return doc.get();
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (BadLocationException badLocationException) {}
        }
        return sourceString;
    }

    public static String genStub(String destTypeName, IMethod method, GenStubSettings settings, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        int flags;
        IType declaringtype = method.getDeclaringType();
        StringBuffer buf = new StringBuffer();
        String[] paramTypes = method.getParameterTypes();
        String[] paramNames = method.getParameterNames();
        String[] excTypes = method.getExceptionTypes();
        String retTypeSig = method.getReturnType();
        int lastParam = paramTypes.length - 1;
        if (settings.createComments) {
            String desc;
            if (method.isConstructor()) {
                desc = "Constructor for " + destTypeName;
                JUnitStubUtility.genJavaDocStub(desc, paramNames, "V", excTypes, buf);
            } else if (settings.fMethodOverwrites) {
                boolean isDeprecated = Flags.isDeprecated((int)method.getFlags());
                JUnitStubUtility.genJavaDocSeeTag(declaringtype.getElementName(), method.getElementName(), paramTypes, settings.createComments, isDeprecated, buf);
            } else {
                desc = "Method " + method.getElementName();
                JUnitStubUtility.genJavaDocStub(desc, paramNames, retTypeSig, excTypes, buf);
            }
        }
        if (Flags.isPublic((int)(flags = method.getFlags())) || declaringtype.isInterface() && !settings.fNoBody) {
            buf.append("public ");
        } else if (Flags.isProtected((int)flags)) {
            buf.append("protected ");
        } else if (Flags.isPrivate((int)flags)) {
            buf.append("private ");
        }
        if (Flags.isSynchronized((int)flags)) {
            buf.append("synchronized ");
        }
        if (Flags.isVolatile((int)flags)) {
            buf.append("volatile ");
        }
        if (Flags.isStrictfp((int)flags)) {
            buf.append("strictfp ");
        }
        if (Flags.isStatic((int)flags)) {
            buf.append("static ");
        }
        if (method.isConstructor()) {
            buf.append(destTypeName);
        } else {
            String retTypeFrm = Signature.toString((String)retTypeSig);
            if (!JUnitStubUtility.isBuiltInType(retTypeSig)) {
                JUnitStubUtility.resolveAndAdd(retTypeSig, declaringtype, imports);
            }
            buf.append(Signature.getSimpleName((String)retTypeFrm));
            buf.append(' ');
            buf.append(method.getElementName());
        }
        buf.append('(');
        int i = 0;
        while (i <= lastParam) {
            String paramTypeSig = paramTypes[i];
            String paramTypeFrm = Signature.toString((String)paramTypeSig);
            if (!JUnitStubUtility.isBuiltInType(paramTypeSig)) {
                JUnitStubUtility.resolveAndAdd(paramTypeSig, declaringtype, imports);
            }
            buf.append(Signature.getSimpleName((String)paramTypeFrm));
            buf.append(' ');
            buf.append(paramNames[i]);
            if (i < lastParam) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(')');
        int lastExc = excTypes.length - 1;
        if (lastExc >= 0) {
            buf.append(" throws ");
            int i2 = 0;
            while (i2 <= lastExc) {
                String excTypeSig = excTypes[i2];
                String excTypeFrm = Signature.toString((String)excTypeSig);
                JUnitStubUtility.resolveAndAdd(excTypeSig, declaringtype, imports);
                buf.append(Signature.getSimpleName((String)excTypeFrm));
                if (i2 < lastExc) {
                    buf.append(", ");
                }
                ++i2;
            }
        }
        if (settings.fNoBody) {
            buf.append(";\n\n");
        } else {
            buf.append(" {\n\t");
            if (!settings.fCallSuper) {
                if (retTypeSig != null && !retTypeSig.equals("V")) {
                    buf.append('\t');
                    if (!JUnitStubUtility.isBuiltInType(retTypeSig) || Signature.getArrayCount((String)retTypeSig) > 0) {
                        buf.append("return null;\n\t");
                    } else if (retTypeSig.equals("Z")) {
                        buf.append("return false;\n\t");
                    } else {
                        buf.append("return 0;\n\t");
                    }
                }
            } else {
                buf.append('\t');
                if (!method.isConstructor()) {
                    if (!"V".equals(retTypeSig)) {
                        buf.append("return ");
                    }
                    buf.append("super.");
                    buf.append(method.getElementName());
                } else {
                    buf.append("super");
                }
                buf.append('(');
                int i3 = 0;
                while (i3 <= lastParam) {
                    buf.append(paramNames[i3]);
                    if (i3 < lastParam) {
                        buf.append(", ");
                    }
                    ++i3;
                }
                buf.append(");\n\t");
            }
            buf.append("}\n\n");
        }
        return buf.toString();
    }

    private static void genJavaDocStub(String descr, String[] paramNames, String retTypeSig, String[] excTypeSigs, StringBuffer buf) {
        buf.append("/**\n");
        buf.append(" * ");
        buf.append(descr);
        buf.append(".\n");
        int i = 0;
        while (i < paramNames.length) {
            buf.append(" * @param ");
            buf.append(paramNames[i]);
            buf.append('\n');
            ++i;
        }
        if (retTypeSig != null && !retTypeSig.equals("V")) {
            String simpleName = Signature.getSimpleName((String)Signature.toString((String)retTypeSig));
            buf.append(" * @return ");
            buf.append(simpleName);
            buf.append('\n');
        }
        i = 0;
        while (i < excTypeSigs.length) {
            String simpleName = Signature.getSimpleName((String)Signature.toString((String)excTypeSigs[i]));
            buf.append(" * @throws ");
            buf.append(simpleName);
            buf.append('\n');
            ++i;
        }
        buf.append(" */\n");
    }

    public static void genJavaDocSeeTag(String declaringTypeName, String methodName, String[] paramTypes, boolean nonJavaDocComment, boolean isDeprecated, StringBuffer buf) {
        buf.append("/*");
        if (!nonJavaDocComment) {
            buf.append('*');
        }
        buf.append("\n * @see ");
        buf.append(declaringTypeName);
        buf.append('#');
        buf.append(methodName);
        buf.append('(');
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Signature.getSimpleName((String)Signature.toString((String)paramTypes[i])));
            ++i;
        }
        buf.append(")\n");
        if (isDeprecated) {
            buf.append(" * @deprecated\n");
        }
        buf.append(" */\n");
    }

    private static boolean isBuiltInType(String typeName) {
        char first = Signature.getElementType((String)typeName).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static void resolveAndAdd(String refTypeSig, IType declaringType, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        String resolvedTypeName = JavaModelUtil.getResolvedTypeName((String)refTypeSig, (IType)declaringType);
        if (resolvedTypeName != null) {
            imports.addImport(resolvedTypeName);
        }
    }

    public static String getTodoTaskTag(IJavaProject project) {
        String markers = null;
        markers = project == null ? JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.taskTags") : project.getOption("org.eclipse.jdt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)member.getAncestor(4);
        return pack != null && otherpack != null && pack.getElementName().equals(otherpack.getElementName());
    }

    public static class GenStubSettings {
        public boolean fCallSuper;
        public boolean fMethodOverwrites;
        public boolean fNoBody;
        public final boolean createComments;
        public final boolean useKeywordThis;
        public final String[] importOrder;
        public final int importThreshold;
        public final boolean importIgnoreLowercase;
        public final int tabWidth;

        public GenStubSettings(IJavaProject project) {
            this.createComments = Boolean.valueOf(PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.javadoc", (IJavaProject)project));
            this.useKeywordThis = Boolean.valueOf(PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.keywordthis", (IJavaProject)project));
            this.importOrder = GenStubSettings.getImportOrderPreference(project);
            this.importThreshold = GenStubSettings.getImportNumberThreshold(project);
            this.importIgnoreLowercase = Boolean.valueOf(PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.ignorelowercasenames", (IJavaProject)project));
            this.tabWidth = GenStubSettings.getTabWidth(project);
        }

        private static int getImportNumberThreshold(IJavaProject project) {
            String thresholdStr = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.ondemandthreshold", (IJavaProject)project);
            try {
                int threshold = Integer.parseInt(thresholdStr);
                if (threshold < 0) {
                    threshold = Integer.MAX_VALUE;
                }
                return threshold;
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MAX_VALUE;
            }
        }

        private static String[] getImportOrderPreference(IJavaProject project) {
            String str = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.importorder", (IJavaProject)project);
            if (str != null) {
                return GenStubSettings.unpackList(str, ";");
            }
            return new String[0];
        }

        private static String[] unpackList(String str, String separator) {
            StringTokenizer tok = new StringTokenizer(str, separator);
            int nTokens = tok.countTokens();
            String[] res = new String[nTokens];
            int i = 0;
            while (i < nTokens) {
                res[i] = tok.nextToken().trim();
                ++i;
            }
            return res;
        }

        private static int getTabWidth(IJavaProject project) {
            String tabSize = project != null ? project.getOption("org.eclipse.jdt.core.formatter.tabulation.size", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.size");
            try {
                return Integer.parseInt(tabSize);
            }
            catch (NumberFormatException numberFormatException) {
                return 4;
            }
        }
    }
}

