/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitAddLibraryProposal;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.junit.wizards.MethodStubsSelectionButtonGroup;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class NewTestCaseWizardPageOne
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewTestCaseCreationWizardPage";
    public static final String CLASS_UNDER_TEST = "NewTestCaseCreationWizardPage.classundertest";
    private static final String QUESTION_MARK_TAG = "Q";
    private static final String OF_TAG = "Of";
    private static final String TEST_SUFFIX = "Test";
    private static final String SETUP = "setUp";
    private static final String TEARDOWN = "tearDown";
    private static final String PREFIX = "test";
    private static final String STORE_GENERATE_MAIN = "NewTestCaseCreationWizardPage.GENERATE_MAIN";
    private static final String STORE_USE_TESTRUNNER = "NewTestCaseCreationWizardPage.USE_TESTRUNNER";
    private static final String STORE_TESTRUNNER_TYPE = "NewTestCaseCreationWizardPage.TESTRUNNER_TYPE";
    private NewTestCaseWizardPageTwo fPage2;
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private String fClassUnderTestText;
    private IType fClassUnderTest;
    private Text fClassUnderTestControl;
    private IStatus fClassUnderTestStatus;
    private Button fClassUnderTestButton;
    private JavaTypeCompletionProcessor fClassToTestCompletionProcessor;

    public NewTestCaseWizardPageOne(NewTestCaseWizardPageTwo page2) {
        super(true, PAGE_NAME);
        this.fPage2 = page2;
        this.setTitle(WizardMessages.NewTestCaseWizardPageOne_title);
        this.setDescription(WizardMessages.NewTestCaseWizardPageOne_description);
        String[] buttonNames = new String[]{"&public static void main(String[] args)", WizardMessages.NewTestCaseWizardPageOne_methodStub_testRunner, WizardMessages.NewTestCaseWizardPageOne_methodStub_setUp, WizardMessages.NewTestCaseWizardPageOne_methodStub_tearDown, WizardMessages.NewTestCaseWizardPageOne_methodStub_constructor};
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, buttonNames, 1);
        this.fMethodStubsButtons.setLabelText(WizardMessages.NewTestCaseWizardPageOne_method_Stub_label);
        this.fClassToTestCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        this.fClassUnderTestStatus = new JUnitStatus();
        this.fClassUnderTestText = "";
    }

    public void init(IStructuredSelection selection) {
        IJavaElement element = this.getInitialJavaElement(selection);
        this.initContainerPage(element);
        this.initTypePage(element);
        if (element != null) {
            IType classToTest = null;
            IType typeInCompUnit = (IType)element.getAncestor(7);
            if (typeInCompUnit != null) {
                if (typeInCompUnit.getCompilationUnit() != null) {
                    classToTest = typeInCompUnit;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)element.getAncestor(5);
                if (cu != null) {
                    classToTest = cu.findPrimaryType();
                } else if (element instanceof IClassFile) {
                    try {
                        IClassFile cf = (IClassFile)element;
                        if (cf.isStructureKnown()) {
                            classToTest = cf.getType();
                        }
                    }
                    catch (JavaModelException e) {
                        JUnitPlugin.log(e);
                    }
                }
            }
            if (classToTest != null) {
                try {
                    if (!TestSearchEngine.isTestImplementor(classToTest)) {
                        this.setClassUnderTest(classToTest.getFullyQualifiedName('.'));
                    }
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e);
                }
            }
        }
        this.fMethodStubsButtons.setSelection(0, false);
        this.fMethodStubsButtons.setSelection(1, false);
        this.fMethodStubsButtons.setEnabled(1, false);
        this.fMethodStubsButtons.setSelection(2, false);
        this.fMethodStubsButtons.setSelection(3, false);
        this.fMethodStubsButtons.setSelection(4, false);
        this.updateStatus(this.getStatusList());
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals("NewContainerWizardPage.container")) {
            this.fClassUnderTestStatus = this.classUnderTestChanged();
            if (this.fClassUnderTestButton != null && !this.fClassUnderTestButton.isDisposed()) {
                this.fClassUnderTestButton.setEnabled(this.getPackageFragmentRoot() != null);
            }
        }
        this.updateStatus(this.getStatusList());
    }

    protected IStatus[] getStatusList() {
        return new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fClassUnderTestStatus, this.fModifierStatus, this.fSuperClassStatus};
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setSuperClass("junit.framework.TestCase", true);
        this.createSeparator(composite, nColumns);
        this.createClassUnderTestControls(composite, nColumns);
        this.setControl((Control)composite);
        String classUnderTest = this.getClassUnderTestText();
        if (classUnderTest.length() > 0) {
            this.setTypeName(String.valueOf(Signature.getSimpleName((String)classUnderTest)) + TEST_SUFFIX, true);
        }
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.junit.new_testcase_wizard_page_context");
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    protected void createClassUnderTestControls(Composite composite, int nColumns) {
        Label classUnderTestLabel = new Label(composite, 16448);
        classUnderTestLabel.setFont(composite.getFont());
        classUnderTestLabel.setText(WizardMessages.NewTestCaseWizardPageOne_class_to_test_label);
        classUnderTestLabel.setLayoutData((Object)new GridData());
        this.fClassUnderTestControl = new Text(composite, 2052);
        this.fClassUnderTestControl.setEnabled(true);
        this.fClassUnderTestControl.setFont(composite.getFont());
        this.fClassUnderTestControl.setText(this.fClassUnderTestText);
        this.fClassUnderTestControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestCaseWizardPageOne.this.internalSetClassUnderText(((Text)e.widget).getText());
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        this.fClassUnderTestControl.setLayoutData((Object)gd);
        this.fClassUnderTestButton = new Button(composite, 8);
        this.fClassUnderTestButton.setText(WizardMessages.NewTestCaseWizardPageOne_class_to_test_browse);
        this.fClassUnderTestButton.setEnabled(true);
        this.fClassUnderTestButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTestCaseWizardPageOne.this.classToTestButtonPressed();
            }

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseWizardPageOne.this.classToTestButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 1;
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fClassUnderTestButton);
        this.fClassUnderTestButton.setLayoutData((Object)gd);
        ControlContentAssistHelper.createTextContentAssistant((Text)this.fClassUnderTestControl, (IContentAssistProcessor)this.fClassToTestCompletionProcessor);
        this.setFocus();
    }

    private void classToTestButtonPressed() {
        IType type = this.chooseClassToTestType();
        if (type != null) {
            this.setClassUnderTest(type.getFullyQualifiedName('.'));
        }
    }

    private IType chooseClassToTestType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        try {
            Object[] resultArray;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getWizard().getContainer(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)this.getClassUnderTestText());
            dialog.setTitle(WizardMessages.NewTestCaseWizardPageOne_class_to_test_dialog_title);
            dialog.setMessage(WizardMessages.NewTestCaseWizardPageOne_class_to_test_dialog_message);
            if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
                return (IType)resultArray[0];
            }
        }
        catch (JavaModelException e) {
            JUnitPlugin.log(e);
        }
        return null;
    }

    protected IStatus packageChanged() {
        IStatus status = super.packageChanged();
        this.fClassToTestCompletionProcessor.setPackageFragment(this.getPackageFragment());
        return status;
    }

    protected IStatus classUnderTestChanged() {
        JUnitStatus status = new JUnitStatus();
        this.fClassUnderTest = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return status;
        }
        String classToTestName = this.getClassUnderTestText();
        if (classToTestName.length() == 0) {
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)classToTestName);
        if (val.getSeverity() == 4) {
            status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_valid);
            return status;
        }
        IPackageFragment pack = this.getPackageFragment();
        try {
            IType type = this.resolveClassNameToType(root.getJavaProject(), pack, classToTestName);
            if (type == null) {
                status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_exist);
                return status;
            }
            if (type.isInterface()) {
                status.setWarning(Messages.format(WizardMessages.NewTestCaseWizardPageOne_warning_class_to_test_is_interface, classToTestName));
            }
            if (pack != null && !JUnitStubUtility.isVisible((IMember)type, pack)) {
                status.setWarning(Messages.format(WizardMessages.NewTestCaseWizardPageOne_warning_class_to_test_not_visible, new String[]{type.isInterface() ? WizardMessages.NewTestCaseWizardPageOne_Interface : WizardMessages.NewTestCaseWizardPageOne_Class, classToTestName}));
            }
            this.fClassUnderTest = type;
            this.fPage2.setClassUnderTest(this.fClassUnderTest);
        }
        catch (JavaModelException javaModelException) {
            status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_valid);
        }
        return status;
    }

    public String getClassUnderTestText() {
        return this.fClassUnderTestText;
    }

    public IType getClassUnderTest() {
        return this.fClassUnderTest;
    }

    public void setClassUnderTest(String name) {
        if (this.fClassUnderTestControl != null && !this.fClassUnderTestControl.isDisposed()) {
            this.fClassUnderTestControl.setText(name);
        }
        this.internalSetClassUnderText(name);
    }

    private void internalSetClassUnderText(String name) {
        this.fClassUnderTestText = name;
        this.fClassUnderTestStatus = this.classUnderTestChanged();
        this.handleFieldChanged(CLASS_UNDER_TEST);
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        if (this.fMethodStubsButtons.isSelected(0)) {
            this.createMain(type);
        }
        if (this.fMethodStubsButtons.isSelected(4)) {
            this.createConstructor(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(2)) {
            this.createSetUp(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(3)) {
            this.createTearDown(type, imports);
        }
        if (this.fClassUnderTest != null) {
            this.createTestMethodStubs(type);
        }
    }

    private void createConstructor(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        String content = "";
        IMethod methodTemplate = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod constrMethod;
                if (superTypes[i].exists() && (constrMethod = superTypes[i].getMethod(superTypes[i].getElementName(), new String[]{"Ljava.lang.String;"})).exists() && constrMethod.isConstructor()) {
                    methodTemplate = constrMethod;
                    break;
                }
                ++i;
            }
        }
        if (methodTemplate != null) {
            JUnitStubUtility.GenStubSettings settings = JUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
            settings.fCallSuper = true;
            settings.fMethodOverwrites = true;
            content = JUnitStubUtility.genStub(this.getTypeName(), methodTemplate, settings, imports);
        } else {
            String delimiter = this.getLineDelimiter();
            StringBuffer buffer = new StringBuffer(32);
            buffer.append("public ");
            buffer.append(this.getTypeName());
            buffer.append("(");
            buffer.append(imports.addImport("java.lang.String"));
            buffer.append(" name) {");
            buffer.append(delimiter);
            buffer.append("super(name);");
            buffer.append(delimiter);
            buffer.append("}");
            buffer.append(delimiter);
            content = String.valueOf(content) + buffer.toString();
        }
        type.createMethod(content, null, true, null);
    }

    private void createMain(IType type) throws JavaModelException {
        type.createMethod(this.fMethodStubsButtons.getMainMethod(this.getTypeName()), null, false, null);
    }

    private void createSetUp(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        String content = "";
        IMethod methodTemplate = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod testMethod;
                if (superTypes[i].exists() && (testMethod = superTypes[i].getMethod(SETUP, new String[0])).exists()) {
                    methodTemplate = testMethod;
                    break;
                }
                ++i;
            }
        }
        JUnitStubUtility.GenStubSettings settings = JUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
        if (methodTemplate != null) {
            settings.fCallSuper = true;
            settings.fMethodOverwrites = true;
            content = JUnitStubUtility.genStub(this.getTypeName(), methodTemplate, settings, imports);
        } else {
            String delimiter = this.getLineDelimiter();
            StringBuffer buffer = new StringBuffer();
            if (settings.createComments) {
                buffer.append("/**");
                buffer.append(delimiter);
                buffer.append(" * Sets up the fixture, for example, open a network connection.");
                buffer.append(delimiter);
                buffer.append(" * This method is called before a test is executed.");
                buffer.append(delimiter);
                buffer.append(delimiter);
                buffer.append(" * @throws ");
                buffer.append(imports.addImport("java.lang.Exception"));
                buffer.append(delimiter);
                buffer.append(" */");
                buffer.append(delimiter);
            }
            buffer.append("protected void ");
            buffer.append(SETUP);
            buffer.append("() throws ");
            buffer.append(imports.addImport("java.lang.Exception"));
            buffer.append(" {}");
            buffer.append(delimiter);
        }
        type.createMethod(content, null, false, null);
    }

    private void createTearDown(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        String tearDown = "";
        IMethod methodTemplate = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod testM;
                if (superTypes[i].exists() && (testM = superTypes[i].getMethod(TEARDOWN, new String[0])).exists()) {
                    methodTemplate = testM;
                    break;
                }
                ++i;
            }
        }
        if (methodTemplate != null) {
            JUnitStubUtility.GenStubSettings settings = JUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
            settings.fCallSuper = true;
            settings.fMethodOverwrites = true;
            tearDown = JUnitStubUtility.genStub(this.getTypeName(), methodTemplate, settings, imports);
            type.createMethod(tearDown, null, false, null);
        }
    }

    private void createTestMethodStubs(IType type) throws JavaModelException {
        IMethod[] methods = this.fPage2.getCheckedMethods();
        if (methods.length == 0) {
            return;
        }
        IMethod[] allMethodsArray = this.fPage2.getAllMethods();
        ArrayList<IMethod> allMethods = new ArrayList<IMethod>();
        allMethods.addAll(Arrays.asList(allMethodsArray));
        List overloadedMethods = this.getOveloadedMethods(allMethods);
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            String elementName = method.getElementName();
            StringBuffer name = new StringBuffer(PREFIX).append(Character.toUpperCase(elementName.charAt(0))).append(elementName.substring(1));
            StringBuffer buffer = new StringBuffer();
            boolean contains = overloadedMethods.contains(method);
            if (contains) {
                this.appendParameterNamesToMethodName(name, method.getParameterTypes());
            }
            this.replaceIllegalCharacters(name);
            String result = name.toString();
            if (names.contains(result)) {
                int suffix = 1;
                while (names.contains(String.valueOf(result) + Integer.toString(suffix))) {
                    ++suffix;
                }
                name.append(Integer.toString(suffix));
            }
            result = name.toString();
            names.add(result);
            this.appendMethodComment(buffer, method);
            buffer.append("public ");
            if (this.fPage2.getCreateFinalMethodStubsButtonSelection()) {
                buffer.append("final ");
            }
            buffer.append("void ");
            buffer.append(result);
            buffer.append("()");
            try {
                this.appendTestMethodBody(buffer, result, method);
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
            type.createMethod(buffer.toString(), null, false, null);
            ++i;
        }
    }

    private void replaceIllegalCharacters(StringBuffer buffer) {
        char character = '\u0000';
        int index = buffer.length() - 1;
        while (index >= 0) {
            character = buffer.charAt(index);
            if (Character.isWhitespace(character)) {
                buffer.deleteCharAt(index);
            } else if (character == '<') {
                buffer.replace(index, index + 1, OF_TAG);
            } else if (character == '?') {
                buffer.replace(index, index + 1, QUESTION_MARK_TAG);
            } else if (!Character.isJavaIdentifierPart(character)) {
                buffer.deleteCharAt(index);
            }
            --index;
        }
    }

    private String getLineDelimiter() {
        IType classToTest = this.getClassUnderTest();
        if (classToTest != null && classToTest.exists()) {
            return StubUtility.getLineDelimiterUsed((IJavaElement)classToTest);
        }
        return StubUtility.getLineDelimiterUsed((IJavaElement)this.getPackageFragment());
    }

    private void appendTestMethodBody(StringBuffer buffer, String name, IMethod method) throws CoreException {
        String content;
        String delimiter = this.getLineDelimiter();
        buffer.append("{").append(delimiter);
        if (this.fPage2.isCreateTasks() && (content = StubUtility.getMethodBodyContent((boolean)false, (IJavaProject)method.getJavaProject(), (String)CLASS_UNDER_TEST, (String)name, (String)"", (String)delimiter)) != null && content.length() > 0) {
            buffer.append(content);
        }
        buffer.append(delimiter).append("}").append(delimiter).append(delimiter);
    }

    private void appendParameterNamesToMethodName(StringBuffer buffer, String[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            StringBuffer buf = new StringBuffer(Signature.getSimpleName((String)Signature.toString((String)Signature.getElementType((String)parameters[i]))));
            char character = buf.charAt(0);
            if (buf.length() > 0 && !Character.isUpperCase(character)) {
                buf.setCharAt(0, Character.toUpperCase(character));
            }
            buffer.append(buf.toString());
            int j = 0;
            int arrayCount = Signature.getArrayCount((String)parameters[i]);
            while (j < arrayCount) {
                buffer.append("Array");
                ++j;
            }
            ++i;
        }
    }

    private void appendMethodComment(StringBuffer buffer, IMethod method) throws JavaModelException {
        String delimiter = this.getLineDelimiter();
        StringBuffer buf = new StringBuffer(16);
        JavaElementLabels.getMethodLabel((IMethod)method, (long)(JavaElementLabels.ALL_DEFAULT | 0x80L), (StringBuffer)buf);
        buffer.append("/*");
        buffer.append(delimiter);
        buffer.append(" * ");
        buffer.append(Messages.format(WizardMessages.NewTestCaseWizardPageOne_comment_class_to_test, buf.toString()));
        buffer.append(delimiter);
        buffer.append(" */");
        buffer.append(delimiter);
    }

    private List getOveloadedMethods(List allMethods) {
        ArrayList<IMethod> overloadedMethods = new ArrayList<IMethod>();
        int i = 0;
        while (i < allMethods.size()) {
            IMethod current = (IMethod)allMethods.get(i);
            String currentName = current.getElementName();
            boolean currentAdded = false;
            ListIterator iter = allMethods.listIterator(i + 1);
            while (iter.hasNext()) {
                IMethod iterMethod = (IMethod)iter.next();
                if (!iterMethod.getElementName().equals(currentName)) continue;
                if (!currentAdded) {
                    overloadedMethods.add(current);
                    currentAdded = true;
                }
                overloadedMethods.add(iterMethod);
                iter.remove();
            }
            ++i;
        }
        return overloadedMethods;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.saveWidgetValues();
        }
    }

    protected IStatus containerChanged() {
        IStatus projectStatus;
        IStatus containerStatus = super.containerChanged();
        if (!containerStatus.matches(4) && !(projectStatus = this.validateIfJUnitProject()).isOK()) {
            return projectStatus;
        }
        return containerStatus;
    }

    protected IStatus validateIfJUnitProject() {
        JUnitStatus status = new JUnitStatus();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return status;
        }
        IJavaProject jp = root.getJavaProject();
        try {
            if (jp.findType("junit.framework.TestCase") != null) {
                return status;
            }
        }
        catch (JavaModelException javaModelException) {}
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)WizardMessages.NewTestCaseWizardPageOne_not_on_buildpath_title, (String)WizardMessages.NewTestCaseWizardPageOne_not_on_buildpath_message)) {
            try {
                JUnitAddLibraryProposal.addJUnitToBuildPath(this.getShell(), jp);
                return status;
            }
            catch (JavaModelException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)WizardMessages.NewTestCaseWizardPageOne_cannot_add_title, (String)WizardMessages.NewTestCaseWizardPageOne_cannot_add_message, (IStatus)e.getStatus());
            }
        }
        status.setWarning(WizardMessages.NewTestCaseWizardPageOne_error_junitNotOnbuildpath);
        return status;
    }

    protected IStatus superClassChanged() {
        String superClassName = this.getSuperClass();
        JUnitStatus status = new JUnitStatus();
        if (superClassName == null || superClassName.trim().equals("")) {
            status.setError(WizardMessages.NewTestCaseWizardPageOne_error_superclass_empty);
            return status;
        }
        if (this.getPackageFragmentRoot() != null) {
            try {
                IType type = this.resolveClassNameToType(this.getPackageFragmentRoot().getJavaProject(), this.getPackageFragment(), superClassName);
                if (type == null) {
                    status.setWarning(WizardMessages.NewTestCaseWizardPageOne_error_superclass_not_exist);
                    return status;
                }
                if (type.isInterface()) {
                    status.setError(WizardMessages.NewTestCaseWizardPageOne_error_superclass_is_interface);
                    return status;
                }
                if (!TestSearchEngine.isTestImplementor(type)) {
                    status.setError(Messages.format(WizardMessages.NewTestCaseWizardPageOne_error_superclass_not_implementing_test_interface, "junit.framework.Test"));
                    return status;
                }
            }
            catch (JavaModelException e) {
                JUnitPlugin.log(e);
            }
        }
        return status;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.getClassUnderTest() != null;
    }

    private IType resolveClassNameToType(IJavaProject jproject, IPackageFragment pack, String classToTestName) throws JavaModelException {
        IType type = jproject.findType(classToTestName);
        if (type == null && pack != null && !pack.isDefaultPackage()) {
            type = jproject.findType(pack.getElementName(), classToTestName);
        }
        if (type == null) {
            type = jproject.findType("java.lang", classToTestName);
        }
        return type;
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            boolean generateMain = settings.getBoolean(STORE_GENERATE_MAIN);
            this.fMethodStubsButtons.setSelection(0, generateMain);
            this.fMethodStubsButtons.setEnabled(1, generateMain);
            this.fMethodStubsButtons.setSelection(1, settings.getBoolean(STORE_USE_TESTRUNNER));
            try {
                this.fMethodStubsButtons.setComboSelection(settings.getInt(STORE_TESTRUNNER_TYPE));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_GENERATE_MAIN, this.fMethodStubsButtons.isSelected(0));
            settings.put(STORE_USE_TESTRUNNER, this.fMethodStubsButtons.isSelected(1));
            settings.put(STORE_TESTRUNNER_TYPE, this.fMethodStubsButtons.getComboSelection());
        }
    }
}

