/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetViewer;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetExpandRestoreAction;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetPage;
import org.eclipse.ui.internal.cheatsheets.views.CoreItem;
import org.eclipse.ui.internal.cheatsheets.views.ErrorPage;
import org.eclipse.ui.internal.cheatsheets.views.IntroItem;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;
import org.osgi.framework.Bundle;

public class CheatSheetViewer
implements ICheatSheetViewer {
    private CheatSheetElement contentElement;
    private URL contentURL;
    private String currentID;
    private int currentItemNum = -1;
    private boolean hascontent = false;
    private boolean invalidCheatSheetId = false;
    private boolean nullCheatSheetId = false;
    private CheatSheetParser parser;
    private CheatSheet cheatSheet;
    private CheatSheetManager manager;
    private CheatSheetSaveHelper saveHelper;
    private CheatSheetExpandRestoreAction expandRestoreAction;
    private Action copyAction;
    private ViewItem currentItem;
    private ArrayList expandRestoreList = new ArrayList();
    private ArrayList viewItemList = new ArrayList();
    private Composite control;
    private Cursor busyCursor;
    private ErrorPage errorPage;
    private CheatSheetPage cheatSheetPage;
    private Label howToBegin;

    public CheatSheetViewer() {
        this.saveHelper = new CheatSheetSaveHelper();
    }

    void advanceIntroItem() {
        IntroItem introItem = (IntroItem)this.getViewItemAtIndex(0);
        boolean isStarted = introItem.isCompleted();
        this.expandRestoreList = new ArrayList();
        if (this.expandRestoreAction != null) {
            this.expandRestoreAction.setCollapsed(false);
        }
        this.clearBackgrounds();
        this.clearIcons();
        this.collapseAllButtons();
        if (isStarted) {
            this.getNewManager();
        }
        this.currentItemNum = 1;
        Iterator iter = this.viewItemList.iterator();
        while (iter.hasNext()) {
            CoreItem c;
            ArrayList l;
            ViewItem item = (ViewItem)iter.next();
            if (!(item instanceof CoreItem) || (l = (c = (CoreItem)item).getListOfSubItemCompositeHolders()) == null) continue;
            int j = 0;
            while (j < l.size()) {
                ((SubItemCompositeHolder)l.get(j)).setSkipped(false);
                ((SubItemCompositeHolder)l.get(j)).setCompleted(false);
                ++j;
            }
        }
        if (isStarted) {
            this.getManager().fireEvent(3);
        } else {
            this.getManager().fireEvent(2);
        }
        isStarted = true;
        introItem.setAsNormalCollapsed();
        introItem.setComplete();
        introItem.setRestartImage();
        ViewItem nextItem = this.getViewItemAtIndex(1);
        if (nextItem.item.isDynamic()) {
            nextItem.handleButtons();
        }
        nextItem.setAsCurrentActiveItem();
        this.collapseAllButCurrent(false);
        this.saveCurrentSheet();
    }

    void advanceItem(ImageHyperlink link, boolean markAsCompleted) {
        this.currentItem = (ViewItem)link.getData();
        int indexNextItem = this.getIndexOfItem(this.currentItem) + 1;
        if (indexNextItem < this.currentItemNum) {
            ViewItem vi = this.getViewItemAtIndex(this.currentItemNum);
            vi.setAsNormalNonCollapsed();
        }
        if (this.currentItem != null) {
            this.currentItem.setAsNormalCollapsed();
            if (markAsCompleted) {
                this.currentItem.setComplete();
            } else {
                this.currentItem.setSkipped();
            }
        }
        if (indexNextItem < this.viewItemList.size()) {
            ViewItem nextItem = this.getViewItemAtIndex(indexNextItem);
            this.currentItemNum = indexNextItem;
            if (nextItem != null) {
                if (nextItem.item.isDynamic()) {
                    ((CoreItem)nextItem).handleButtons();
                }
                nextItem.setAsCurrentActiveItem();
                this.currentItem = nextItem;
            }
            FormToolkit.ensureVisible((Control)this.currentItem.getMainItemComposite());
        } else if (indexNextItem == this.viewItemList.size()) {
            this.saveCurrentSheet();
            ViewItem item = this.getViewItemAtIndex(0);
            item.setExpanded();
            item.setBold(true);
            item.getMainItemComposite().setFocus();
            this.getManager().fireEvent(4);
        }
        this.saveCurrentSheet();
    }

    void advanceSubItem(ImageHyperlink link, boolean markAsCompleted, int subItemIndex) {
        Label l = null;
        ArrayList list = null;
        SubItemCompositeHolder sich = null;
        CoreItem ciws = null;
        this.currentItem = (ViewItem)link.getData();
        if (this.currentItem instanceof CoreItem) {
            ciws = (CoreItem)this.currentItem;
        }
        if (ciws != null) {
            list = ciws.getListOfSubItemCompositeHolders();
            sich = (SubItemCompositeHolder)list.get(subItemIndex);
            l = sich.getIconLabel();
        }
        if (l != null) {
            if (markAsCompleted) {
                l.setImage(ciws.getCompleteImage());
                sich.setCompleted(true);
                sich.setSkipped(false);
            } else {
                l.setImage(ciws.getSkipImage());
                sich.setSkipped(true);
                sich.setCompleted(false);
            }
        }
        boolean allAttempted = this.checkAllAttempted(list);
        boolean anySkipped = this.checkContainsSkipped(list);
        if (allAttempted && !anySkipped) {
            this.advanceItem(link, true);
            return;
        }
        if (allAttempted && anySkipped) {
            this.advanceItem(link, false);
            return;
        }
        FormToolkit.ensureVisible((Control)this.currentItem.getMainItemComposite());
        this.saveCurrentSheet();
    }

    private boolean checkAllAttempted(ArrayList list) {
        int i = 0;
        while (i < list.size()) {
            SubItemCompositeHolder s = (SubItemCompositeHolder)list.get(i);
            if (!s.isCompleted() && !s.isSkipped()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkContainsSkipped(ArrayList list) {
        int i = 0;
        while (i < list.size()) {
            SubItemCompositeHolder s = (SubItemCompositeHolder)list.get(i);
            if (s.isSkipped()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkSavedState() {
        try {
            Properties props = this.saveHelper.loadState(this.currentID);
            this.clearBackgrounds();
            if (props == null) {
                this.getViewItemAtIndex(0).setAsCurrentActiveItem();
                return true;
            }
            boolean buttonIsDown = Integer.parseInt((String)props.get("button")) != 0;
            int itemNum = Integer.parseInt((String)props.get("current"));
            ArrayList completedStatesList = (ArrayList)props.get("completed");
            ArrayList expandedStatesList = (ArrayList)props.get("expanded");
            this.expandRestoreList = (ArrayList)props.get("expandRestore");
            String cid = (String)props.get("id");
            Hashtable completedSubItems = (Hashtable)props.get("subitemcompleted");
            Hashtable skippedSubItems = (Hashtable)props.get("subitemskipped");
            Hashtable csmData = (Hashtable)props.get("CSMData");
            ArrayList completedSubItemsItemList = new ArrayList();
            ArrayList skippedSubItemsItemList = new ArrayList();
            Enumeration e = completedSubItems.keys();
            while (e.hasMoreElements()) {
                completedSubItemsItemList.add(e.nextElement());
            }
            Enumeration e2 = skippedSubItems.keys();
            while (e2.hasMoreElements()) {
                skippedSubItemsItemList.add(e2.nextElement());
            }
            if (cid != null) {
                this.currentID = cid;
            }
            this.getManager().setData(csmData);
            if (itemNum >= 0) {
                this.currentItemNum = itemNum;
                this.currentItem = this.getViewItemAtIndex(itemNum);
                CheatSheetStopWatch.startStopWatch("CheatSheetViewer.checkSavedState()");
                int i = 0;
                while (i < this.viewItemList.size()) {
                    String token;
                    CoreItem coreitemws;
                    StringTokenizer st;
                    String subItemNumbers;
                    ViewItem item = this.getViewItemAtIndex(i);
                    if (i > 0 && item.item.isDynamic() && i <= this.currentItemNum) {
                        item.handleButtons();
                        item.setOriginalColor();
                    }
                    if (completedStatesList.contains(Integer.toString(i))) {
                        item.setComplete();
                        item.setRestartImage();
                    } else if (i < this.currentItemNum) {
                        item.setSkipped();
                    }
                    if (expandedStatesList.contains(Integer.toString(i))) {
                        if (i <= this.currentItemNum) {
                            item.setButtonsExpanded();
                        } else {
                            item.setButtonsCollapsed();
                        }
                        item.setExpanded();
                    } else {
                        item.setCollapsed();
                        if (i > this.currentItemNum) {
                            item.setButtonsCollapsed();
                        } else {
                            item.setButtonsExpanded();
                        }
                    }
                    if (this.expandRestoreList.contains(Integer.toString(i))) {
                        item.setCollapsed();
                    }
                    if (completedSubItemsItemList.contains(Integer.toString(i))) {
                        subItemNumbers = (String)completedSubItems.get(Integer.toString(i));
                        st = new StringTokenizer(subItemNumbers, ",");
                        if (item instanceof CoreItem) {
                            coreitemws = (CoreItem)item;
                            while (st.hasMoreTokens()) {
                                token = st.nextToken();
                                ((SubItemCompositeHolder)coreitemws.getListOfSubItemCompositeHolders().get(Integer.parseInt(token))).setCompleted(true);
                                ((SubItemCompositeHolder)coreitemws.getListOfSubItemCompositeHolders().get(Integer.parseInt(token))).getIconLabel().setImage(item.getCompleteImage());
                                ArrayList l = coreitemws.getListOfSubItemCompositeHolders();
                                SubItemCompositeHolder s = (SubItemCompositeHolder)l.get(Integer.parseInt(token));
                                if (s == null || s.getStartButton() == null) continue;
                                s.getStartButton().setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_RESTART"));
                                s.getStartButton().setToolTipText(Messages.RESTART_TASK_TOOLTIP);
                            }
                        }
                    }
                    if (skippedSubItemsItemList.contains(Integer.toString(i))) {
                        subItemNumbers = (String)skippedSubItems.get(Integer.toString(i));
                        st = new StringTokenizer(subItemNumbers, ",");
                        if (item instanceof CoreItem) {
                            coreitemws = (CoreItem)item;
                            while (st.hasMoreTokens()) {
                                token = st.nextToken();
                                ((SubItemCompositeHolder)coreitemws.getListOfSubItemCompositeHolders().get(Integer.parseInt(token))).setSkipped(true);
                                ((SubItemCompositeHolder)coreitemws.getListOfSubItemCompositeHolders().get(Integer.parseInt(token))).getIconLabel().setImage(item.getSkipImage());
                            }
                        }
                    }
                    CheatSheetStopWatch.printLapTime("CheatSheetViewer.checkSavedState()", "Time in CheatSheetViewer.checkSavedState() after loop #" + i + ": ");
                    ++i;
                }
                CheatSheetStopWatch.printLapTime("CheatSheetViewer.checkSavedState()", "Time in CheatSheetViewer.checkSavedState() after loop: ");
                if (buttonIsDown) {
                    if (this.expandRestoreAction != null) {
                        this.expandRestoreAction.setCollapsed(true);
                    }
                    this.saveCurrentSheet();
                }
                if (this.viewItemList.size() - 1 == itemNum && this.currentItem.isCompleted()) {
                    this.currentItem.setCollapsed();
                    this.getViewItemAtIndex(0).getMainItemComposite().setFocus();
                    this.getManager().fireEvent(5);
                    this.getManager().fireEvent(4);
                } else {
                    this.currentItem.setAsCurrentActiveItem();
                    if (this.getViewItemAtIndex(0).isCompleted()) {
                        this.getManager().fireEvent(5);
                    }
                }
            } else {
                this.getViewItemAtIndex(0).setAsCurrentActiveItem();
            }
            FormToolkit.ensureVisible((Control)this.currentItem.getMainItemComposite());
            return true;
        }
        catch (Exception e) {
            String stateFile = this.saveHelper.getStateFile(this.currentID).toOSString();
            String message = NLS.bind((String)Messages.ERROR_APPLYING_STATE_DATA_LOG, (Object[])new Object[]{stateFile, this.currentID});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            this.currentID = null;
            this.internalDispose();
            this.contentURL = null;
            this.currentItem = null;
            this.currentItemNum = -1;
            this.cheatSheetPage = null;
            this.expandRestoreList = new ArrayList();
            this.viewItemList = new ArrayList();
            this.createErrorPage(Messages.ERROR_APPLYING_STATE_DATA);
            return false;
        }
    }

    private void clearBackgrounds() {
        Iterator iter = this.viewItemList.iterator();
        while (iter.hasNext()) {
            ViewItem item = (ViewItem)iter.next();
            item.setOriginalColor();
        }
    }

    private void clearIcons() {
        Iterator iter = this.viewItemList.iterator();
        while (iter.hasNext()) {
            ViewItem item = (ViewItem)iter.next();
            item.setOriginalColor();
            if (!item.isCompleted() && !item.isExpanded() && !item.isSkipped()) continue;
            item.setIncomplete();
        }
    }

    private void collapseAllButCurrent(boolean fromAction) {
        this.expandRestoreList = new ArrayList();
        try {
            ViewItem current = this.getViewItemAtIndex(this.currentItemNum);
            ListIterator iter = this.viewItemList.listIterator(this.viewItemList.size());
            while (iter.hasPrevious()) {
                ViewItem item = (ViewItem)iter.previous();
                if (item == current || !item.isExpanded()) continue;
                item.setCollapsed();
                if (!fromAction) continue;
                this.expandRestoreList.add(Integer.toString(this.getIndexOfItem(item)));
            }
        }
        catch (Exception exception) {}
    }

    private void collapseAllButtons() {
        ListIterator iter = this.viewItemList.listIterator(1);
        while (iter.hasNext()) {
            ViewItem item = (ViewItem)iter.next();
            item.setButtonsCollapsed();
        }
    }

    private void createErrorPage(String message) {
        this.errorPage = message != null ? new ErrorPage(message) : new ErrorPage();
        this.errorPage.createPart(this.control);
        this.hascontent = true;
        this.control.layout(true);
    }

    public void createPartControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 1;
        this.control.setLayout((Layout)layout);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CheatSheetViewer.this.dispose();
            }
        });
        this.howToBegin = new Label(this.control, 64);
        this.howToBegin.setText(Messages.INITIAL_VIEW_DIRECTIONS);
        this.howToBegin.setLayoutData((Object)new GridData(1808));
        Display display = parent.getDisplay();
        this.busyCursor = new Cursor((Device)display, 1);
        if (this.contentElement != null) {
            this.initCheatSheetView();
        }
    }

    private void dispose() {
        this.internalDispose();
        if (this.busyCursor != null) {
            this.busyCursor.dispose();
        }
    }

    public String getCheatSheetID() {
        if (this.getContent() != null) {
            return this.getContent().getID();
        }
        return null;
    }

    CheatSheetElement getContent() {
        return this.contentElement;
    }

    public Control getControl() {
        return this.control;
    }

    private boolean getHasContent() {
        return this.hascontent;
    }

    private int getIndexOfItem(ViewItem item) {
        int index = this.viewItemList.indexOf(item);
        if (index != -1) {
            return index;
        }
        return 0;
    }

    CheatSheetManager getManager() {
        if (this.manager == null) {
            this.getNewManager();
        }
        return this.manager;
    }

    private CheatSheetManager getNewManager() {
        this.manager = new CheatSheetManager(this.contentElement);
        return this.manager;
    }

    private ViewItem getViewItemAtIndex(int index) {
        return (ViewItem)this.viewItemList.get(index);
    }

    private void initCheatSheetView() {
        CheatSheetStopWatch.startStopWatch("CheatSheetViewer.initCheatSheetView()");
        this.expandRestoreList = new ArrayList();
        if (this.expandRestoreAction != null) {
            this.expandRestoreAction.setCollapsed(false);
        }
        this.currentItem = null;
        this.currentItemNum = 0;
        this.viewItemList = new ArrayList();
        this.errorPage = null;
        this.cheatSheetPage = null;
        if (this.howToBegin != null) {
            this.howToBegin.dispose();
            this.howToBegin = null;
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() before readFile() call: ");
        boolean parsedOK = this.readFile();
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after readFile() call: ");
        if (!parsedOK) {
            if (this.nullCheatSheetId) {
                return;
            }
            if (this.invalidCheatSheetId) {
                this.createErrorPage(Messages.ERROR_CHEATSHEET_DOESNOT_EXIST);
            } else {
                this.createErrorPage(null);
            }
            return;
        }
        this.control.setRedraw(false);
        this.cheatSheetPage = new CheatSheetPage(this.cheatSheet, this.viewItemList, this);
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after CheatSheetPage() call: ");
        this.cheatSheetPage.createPart(this.control);
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after CheatSheetPage.createPart() call: ");
        this.hascontent = true;
        this.getNewManager().fireEvent(0);
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after fireEvent() call: ");
        if (!this.checkSavedState()) {
            this.control.setRedraw(true);
            this.control.layout();
            return;
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after checkSavedState() call: ");
        this.cheatSheetPage.initialized();
        this.control.setRedraw(true);
        this.control.layout();
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after layout() call: ");
        if (this.currentItem != null && !this.currentItem.isCompleted()) {
            this.currentItem.getMainItemComposite().setFocus();
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() at end of method: ");
    }

    private void internalDispose() {
        if (this.manager != null) {
            this.manager.fireEvent(1);
        }
        this.saveCurrentSheet();
        Iterator iter = this.viewItemList.iterator();
        while (iter.hasNext()) {
            ViewItem item = (ViewItem)iter.next();
            item.dispose();
        }
        if (this.errorPage != null) {
            this.errorPage.dispose();
        }
        if (this.cheatSheetPage != null) {
            this.cheatSheetPage.dispose();
        }
    }

    private boolean readFile() {
        if (this.parser == null) {
            this.parser = new CheatSheetParser();
        }
        this.cheatSheet = this.parser.parse(this.contentURL);
        return this.cheatSheet != null;
    }

    private void restoreExpandStates() {
        try {
            int i = 0;
            while (i < this.expandRestoreList.size()) {
                int index = Integer.parseInt((String)this.expandRestoreList.get(i));
                ViewItem item = this.getViewItemAtIndex(index);
                if (!item.isExpanded()) {
                    item.setExpanded();
                }
                ++i;
            }
            this.expandRestoreList = null;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runPerformAction(ImageHyperlink link) {
        CoreItem coreItem = null;
        link.setCursor(this.busyCursor);
        this.currentItem = (ViewItem)link.getData();
        coreItem = (CoreItem)this.currentItem;
        try {
            try {
                if (coreItem != null && coreItem.runAction(this.getManager()) == 0 && !coreItem.hasConfirm()) {
                    coreItem.setRestartImage();
                    this.advanceItem(link, true);
                    this.saveCurrentSheet();
                }
            }
            catch (RuntimeException e) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_RUNNING_ACTION, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            link.setCursor(null);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        link.setCursor(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runSubItemPerformAction(ImageHyperlink link, int subItemIndex) {
        CoreItem coreItem = null;
        link.setCursor(this.busyCursor);
        this.currentItem = (ViewItem)link.getData();
        coreItem = (CoreItem)this.currentItem;
        try {
            try {
                if (coreItem != null && coreItem.runSubItemAction(this.getManager(), subItemIndex) == 0 && !coreItem.hasConfirm(subItemIndex)) {
                    ArrayList l = coreItem.getListOfSubItemCompositeHolders();
                    SubItemCompositeHolder s = (SubItemCompositeHolder)l.get(subItemIndex);
                    s.getStartButton().setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_RESTART"));
                    s.getStartButton().setToolTipText(Messages.RESTART_TASK_TOOLTIP);
                    this.advanceSubItem(link, true, subItemIndex);
                    this.saveCurrentSheet();
                }
            }
            catch (RuntimeException e) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_RUNNING_ACTION, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            link.setCursor(null);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        link.setCursor(null);
    }

    void saveCurrentSheet() {
        if (this.currentID != null) {
            boolean expandRestoreActionState = false;
            if (this.expandRestoreAction != null) {
                expandRestoreActionState = this.expandRestoreAction.isCollapsed();
            }
            this.saveHelper.saveState(this.currentItemNum, this.viewItemList, expandRestoreActionState, this.expandRestoreList, this.currentID, this.getManager());
        }
    }

    private void setContent(CheatSheetElement element) {
        CheatSheetStopWatch.startStopWatch("CheatSheetViewer.setContent(CheatSheetElement element)");
        if (element != null && ((Object)((Object)element)).equals((Object)this.contentElement)) {
            return;
        }
        if (this.getHasContent()) {
            this.internalDispose();
        }
        this.contentElement = element;
        this.currentID = null;
        this.contentURL = null;
        if (element != null) {
            this.currentID = element.getID();
            Bundle bundle = null;
            if (element != null && element.getConfigurationElement() != null) {
                try {
                    String pluginId = element.getConfigurationElement().getNamespace();
                    bundle = Platform.getBundle((String)pluginId);
                }
                catch (Exception exception) {}
            }
            if (bundle != null) {
                this.contentURL = Platform.find(bundle, (IPath)new Path(element.getContentFile()));
            }
            if (this.contentURL == null) {
                try {
                    URL checker = new URL(element.getContentFile());
                    if (checker.getProtocol().equalsIgnoreCase("http")) {
                        this.contentURL = checker;
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setContent(CheatSheetElement element)", "Time in CheatSheetViewer.setContent() before initCheatSheetView() call: ");
        if (this.control != null) {
            this.initCheatSheetView();
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setContent(CheatSheetElement element)", "Time in CheatSheetViewer.setContent() after initCheatSheetView() call: ");
    }

    void setExpandRestoreAction(CheatSheetExpandRestoreAction action) {
        this.expandRestoreAction = action;
    }

    public void setFocus() {
        if (this.currentItem != null) {
            this.currentItem.getMainItemComposite().setFocus();
        }
    }

    public void setInput(String id) {
        CheatSheetStopWatch.startStopWatch("CheatSheetViewer.setInput(String id)");
        CheatSheetElement element = null;
        if (id == null) {
            this.nullCheatSheetId = true;
        } else {
            this.nullCheatSheetId = false;
            element = CheatSheetRegistryReader.getInstance().findCheatSheet(id);
            if (element == null) {
                String message = NLS.bind((String)Messages.ERROR_INVALID_CHEATSHEET_ID, (Object[])new Object[]{id});
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                this.invalidCheatSheetId = true;
            } else {
                this.invalidCheatSheetId = false;
            }
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setInput(String id)", "Time in CheatSheetViewer.setInput(String id) before setContent() call: ");
        this.setContent(element);
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setInput(String id)", "Time in CheatSheetViewer.setInput(String id) after setContent() call: ");
        CheatSheetPlugin.getPlugin().getCheatSheetHistory().add(element);
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setInput(String id)", "Time in CheatSheetViewer.setInput(String id) after getCheatSheetHistory() call: ");
    }

    public void setInput(String id, String name, URL url) {
        if (id == null || name == null || url == null) {
            throw new IllegalArgumentException();
        }
        CheatSheetElement element = new CheatSheetElement(name);
        element.setID(id);
        element.setContentFile(url.toString());
        this.nullCheatSheetId = false;
        this.invalidCheatSheetId = false;
        this.setContent(element);
    }

    void toggleExpandRestore() {
        if (this.expandRestoreAction == null) {
            return;
        }
        if (this.expandRestoreAction.isCollapsed()) {
            this.restoreExpandStates();
            this.expandRestoreAction.setCollapsed(false);
            this.saveCurrentSheet();
        } else {
            this.collapseAllButCurrent(true);
            this.expandRestoreAction.setCollapsed(true);
            this.saveCurrentSheet();
        }
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public void setCopyAction(Action copyAction) {
        this.copyAction = copyAction;
    }

    public void copy() {
        if (this.currentItem != null) {
            this.currentItem.copy();
        }
    }
}

