/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;

public abstract class Page {
    protected static final int HORZ_SCROLL_INCREMENT = 20;
    protected static final int VERT_SCROLL_INCREMENT = 20;
    protected Color backgroundColor;
    private Color[] colorArray;
    protected FormToolkit toolkit;
    protected ScrolledForm form;

    public Control getControl() {
        return this.form;
    }

    public void createPart(Composite parent) {
        this.init(parent.getDisplay());
        CheatSheetStopWatch.startStopWatch("Page.createInfoArea()");
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() after new FormToolkit(): ");
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setData("novarrows", (Object)Boolean.TRUE);
        this.form.setText(this.getTitle());
        this.form.setDelayedReflow(true);
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() after createScrolledForm(): ");
        this.form.setLayoutData((Object)new GridData(1808));
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() after setLayoutData(): ");
        TableWrapLayout layout = new TableWrapLayout();
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() after new FormTableWrapLayout(): ");
        layout.numColumns = 2;
        layout.verticalSpacing = 3;
        this.form.getBody().setLayout((Layout)layout);
        CheatSheetStopWatch.printLapTime("Page.createInfoArea()", "Time in Page.createInfoArea() end of method: ");
    }

    public void dispose() {
        if (this.form != null) {
            this.form.dispose();
        }
        if (this.colorArray != null) {
            int i = 0;
            while (i < this.colorArray.length) {
                if (this.colorArray[i] != null) {
                    this.colorArray[i].dispose();
                }
                ++i;
            }
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        this.form = null;
        this.toolkit = null;
        this.colorArray = null;
    }

    protected void init(Display display) {
        this.toolkit = new FormToolkit(display);
        this.backgroundColor = this.toolkit.getColors().getBackground();
    }

    protected abstract String getTitle();
}

