/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.File;
import java.io.FileFilter;
import java.io.FilePermission;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import sun.plugin.cache.CleanupThread;
import sun.plugin.util.Trace;
import sun.plugin.util.UserProfile;
import sun.security.action.GetPropertyAction;

public class Cache {
    protected static long maxSize;
    protected static long threadThresholdSize;
    protected static long deleteThresholdSize;
    protected static boolean cachingDisabled;
    protected static Random random;
    protected static CleanupThread cleanupThread;
    protected static final byte INCOMPLETE = 0;
    protected static final byte UNUSABLE = 1;
    protected static final byte INUSE = 2;
    protected static final byte VERSION = 16;
    protected static final String INDEX_FILE_EXT = ".idx";
    protected static final long CLEANUP_INTERVAL = 1L;
    protected static final long MINIMUM_CACHE_SIZE = 5L;
    protected static final String ENABLED_PROP = "deployment.javapi.cache.enabled";
    protected static final String SIZE_PROP = "deployment.cache.max.size";
    protected static String KB;
    protected static String MB;
    protected static String BYTES;
    protected static String UNLIMITED;

    public static void init() {
    }

    protected static final boolean isSupportedProtocol(URL uRL) {
        String string = uRL.getProtocol();
        return string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"));
    }

    protected static final void msgPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray);
    }

    protected static final File getIndexFile(File file, URL uRL) {
        String string = file.getName();
        string = string.substring(0, string.length() - Cache.getFileExtension(uRL.toString()).length());
        string = string + INDEX_FILE_EXT;
        return new File(file.getParentFile(), string);
    }

    protected static final File getDataFile(File file, String string) {
        String string2 = file.getName();
        string2 = string2.substring(0, string2.length() - INDEX_FILE_EXT.length());
        string2 = string2 + Cache.getFileExtension(string);
        return new File(file.getParentFile(), string2);
    }

    protected static final String getFileExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(n);
        }
        if (string2.equalsIgnoreCase(".jar") || string2.equalsIgnoreCase(".jarjar")) {
            string2 = ".zip";
        }
        return string2;
    }

    protected static String generateCacheFileName(File file, URL uRL) throws IOException {
        File file2;
        String string;
        File file3;
        String string2 = Cache.getKey(uRL);
        do {
            string = string2 + Integer.toString(Cache.getRandom(), 16);
            file2 = new File(file, string + Cache.getFileExtension(uRL.toString()));
        } while ((file3 = new File(file, string + INDEX_FILE_EXT)).exists() || file2.exists());
        file3 = null;
        file2 = null;
        return string;
    }

    protected static Enumeration getMatchingFiles(File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        final File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(string);
            }
        });
        return new Enumeration(){
            private int index = 0;

            public boolean hasMoreElements() {
                return this.index < fileArray.length;
            }

            public Object nextElement() {
                return fileArray[this.index++];
            }
        };
    }

    protected static final void touch(final File file) throws IOException {
        try {
            AccessController.doPrivileged(new CacheIOAction(){

                public Object run() throws IOException {
                    file.setLastModified(System.currentTimeMillis());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
    }

    protected static String getKey(URL uRL) {
        int n;
        String string = uRL.getPath();
        int n2 = string.lastIndexOf("/");
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        if ((n = Cache.hashCode(uRL)) < 0) {
            n -= Integer.MIN_VALUE;
        }
        return string + "-" + Integer.toString(n, 16) + "-";
    }

    protected static String parseKey(String string) {
        String string2 = null;
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string2 = string.substring(0, n + 1);
        }
        return string2;
    }

    protected static final int getRandom() {
        return 0x10000000 + random.nextInt(0x6FFFFFFF);
    }

    protected static void checkPermission(URLConnection uRLConnection) throws IOException {
        SecurityManager securityManager;
        Permission permission = uRLConnection.getPermission();
        URL uRL = uRLConnection.getURL();
        if (permission != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
    }

    protected static long getFileSizeFromServer(URL uRL) throws IOException {
        long l = -1L;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("HEAD");
        l = httpURLConnection.getContentLength();
        httpURLConnection.disconnect();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addToTable(File file, Hashtable hashtable) {
        String string = Cache.parseKey(file.getName());
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            ArrayList<File> arrayList = (ArrayList<File>)hashtable.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<File>();
                arrayList.add(file);
                hashtable.put(string, arrayList);
            } else if (arrayList.indexOf(file) == -1) {
                arrayList.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeFromTable(File file, Hashtable hashtable) {
        String string = Cache.parseKey(file.getName());
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            ArrayList arrayList = (ArrayList)hashtable.get(string);
            if (arrayList != null) {
                int n = arrayList.indexOf(file);
                if (n != -1) {
                    arrayList.remove(n);
                }
                if (arrayList.size() == 0) {
                    hashtable.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean updateTable(File file, Hashtable hashtable, final String string) {
        boolean bl = false;
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(Cache.INDEX_FILE_EXT) && file.getName().startsWith(string);
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            Hashtable hashtable2 = hashtable;
            synchronized (hashtable2) {
                ArrayList<File> arrayList = (ArrayList<File>)hashtable.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<File>();
                    arrayList.add(fileArray[i]);
                    hashtable.put(string, arrayList);
                    bl = true;
                } else if (arrayList.indexOf(fileArray[i]) == -1) {
                    arrayList.add(fileArray[i]);
                    bl = true;
                }
                continue;
            }
        }
        return bl;
    }

    protected static void createTable(File file, Hashtable hashtable) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(Cache.INDEX_FILE_EXT);
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            String string = Cache.parseKey(fileArray[i].getName());
            ArrayList<File> arrayList = (ArrayList<File>)hashtable.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<File>();
                arrayList.add(fileArray[i]);
                hashtable.put(string, arrayList);
                continue;
            }
            arrayList.add(fileArray[i]);
        }
    }

    protected static int hashCode(URL uRL) {
        String string;
        String string2;
        int n = 0;
        String string3 = uRL.getProtocol();
        if (string3 != null) {
            n = string3.hashCode();
        }
        if ((string2 = uRL.getHost()) != null) {
            n = string2.toLowerCase().hashCode();
        }
        if ((string = uRL.getFile()) != null) {
            n += string.hashCode();
        }
        n = uRL.getPort() == -1 ? (n += uRL.getDefaultPort()) : (n += uRL.getPort());
        String string4 = uRL.getRef();
        if (string4 != null) {
            n += string4.hashCode();
        }
        return n;
    }

    static {
        cachingDisabled = false;
        random = new Random();
        cleanupThread = null;
        KB = "{0} KB";
        MB = "{0} MB";
        BYTES = "{0} bytes";
        UNLIMITED = "unlimited";
        String string = AccessController.doPrivileged(new GetPropertyAction(ENABLED_PROP, "true"));
        cachingDisabled = string.equalsIgnoreCase("false");
        if (cachingDisabled) {
            Cache.msgPrintln("cache.disabled", null);
        } else {
            String string2;
            long l;
            MessageFormat messageFormat;
            long l2;
            string = AccessController.doPrivileged(new GetPropertyAction(SIZE_PROP, "50m"));
            string.trim();
            if (string.endsWith("M") || string.endsWith("m")) {
                l2 = 0x100000L;
                string = string.substring(0, string.length() - 1);
                messageFormat = new MessageFormat(MB);
            } else if (string.endsWith("K") || string.endsWith("k")) {
                l2 = 1024L;
                string = string.substring(0, string.length() - 1);
                messageFormat = new MessageFormat(KB);
            } else {
                l2 = 1L;
                messageFormat = new MessageFormat(BYTES);
            }
            try {
                l = Long.valueOf(string);
                maxSize = l2 * l;
            }
            catch (NumberFormatException numberFormatException) {
                l = 50L;
                maxSize = 0x3200000L;
                messageFormat = new MessageFormat(MB);
            }
            if (l > 0L) {
                string2 = messageFormat.format(new Object[]{new Long(l)});
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup.getParent() != null) {
                    threadGroup = threadGroup.getParent();
                }
                if (maxSize >= 0x500000L) {
                    threadThresholdSize = maxSize - 0x100000L;
                    deleteThresholdSize = maxSize - 0x200000L;
                    cleanupThread = new CleanupThread(threadGroup, 60000L);
                    cleanupThread.start();
                } else {
                    cachingDisabled = true;
                    Cache.msgPrintln("cache.minSize", new Object[]{string2});
                    string2 = null;
                }
            } else {
                string2 = UNLIMITED;
            }
            if (string2 != null) {
                Cache.msgPrintln("cache.enabled", null);
                Cache.msgPrintln("cache.location", new Object[]{UserProfile.getPluginCacheDirectory()});
                Cache.msgPrintln("cache.maxSize", new Object[]{string2});
            }
        }
    }

    protected static class CacheIOAction
    implements PrivilegedExceptionAction {
        protected CacheIOAction() {
        }

        public Object run() throws IOException {
            return null;
        }
    }
}

