/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.ShowAnnotationAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowResourceInHistoryAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSActionDelegateWrapper;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSChangeSetCapability;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipant;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareRevertAction;
import org.eclipse.team.internal.core.subscribers.SubscriberChangeSetCollector;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class CompareParticipant
extends CVSParticipant
implements Preferences.IPropertyChangeListener {
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP = "context_group_1";
    public static final String NON_MODAL_CONTEXT_MENU_CONTRIBUTION_GROUP = "context_group_2";
    private SyncInfoFilter contentComparison = new SyncInfoFilter(){
        private SyncInfoFilter contentCompare = new SyncInfoFilter.ContentComparisonSyncInfoFilter();

        public boolean select(SyncInfo info, IProgressMonitor monitor) {
            return !this.contentCompare.select(info, monitor);
        }
    };

    public CompareParticipant(CVSCompareSubscriber subscriber) {
        this.setSubscriber((Subscriber)subscriber);
    }

    protected void setSubscriber(Subscriber subscriber) {
        super.setSubscriber(subscriber);
        if (CVSUIPlugin.getPlugin().getPluginPreferences().getBoolean("pref_consider_contents")) {
            this.setSyncInfoFilter(this.contentComparison);
        }
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor("org.eclipse.team.cvs.ui.compare-participant");
            this.setInitializationData(descriptor);
            CVSCompareSubscriber s = this.getCVSCompareSubscriber();
            this.setSecondaryId(s.getId().getLocalName());
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
        }
        CVSUIPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public String getName() {
        return NLS.bind((String)CVSUIMessages.CompareParticipant_0, (Object[])new String[]{this.getSubscriber().getName(), Utils.convertSelection((IResource[])this.getSubscriber().roots())});
    }

    public static CompareParticipant getMatchingParticipant(IResource[] resources, CVSTag tag) {
        ISynchronizeParticipantReference[] refs = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        int i = 0;
        while (i < refs.length) {
            ISynchronizeParticipantReference reference = refs[i];
            if (reference.getId().equals("org.eclipse.team.cvs.ui.compare-participant")) {
                try {
                    CompareParticipant p = (CompareParticipant)reference.getParticipant();
                    if (p.matches(resources, tag)) {
                        return p;
                    }
                }
                catch (TeamException teamException) {}
            }
            ++i;
        }
        return null;
    }

    protected boolean matches(IResource[] resources, CVSTag tag) {
        CVSTag existingTag = this.getCVSCompareSubscriber().getTag();
        if (existingTag != null) {
            Object[] roots = this.getResources();
            Arrays.sort(resources, Utils.resourceComparator);
            Arrays.sort(roots, Utils.resourceComparator);
            if (Arrays.equals(resources, roots) && existingTag.equals((Object)tag)) {
                return true;
            }
        }
        return false;
    }

    public CVSCompareSubscriber getCVSCompareSubscriber() {
        return (CVSCompareSubscriber)this.getSubscriber();
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", NON_MODAL_CONTEXT_MENU_CONTRIBUTION_GROUP);
        configuration.addActionContribution((SynchronizePageActionGroup)new CompareParticipantActionContribution());
    }

    public void dispose() {
        super.dispose();
        CVSUIPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.getCVSCompareSubscriber().dispose();
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().equals("pref_consider_contents")) {
            if (CVSUIPlugin.getPlugin().getPluginPreferences().getBoolean("pref_consider_contents")) {
                this.setSyncInfoFilter(this.contentComparison);
            } else {
                this.setSyncInfoFilter((SyncInfoFilter)new FastSyncInfoFilter());
            }
        }
    }

    protected String getLongTaskName() {
        return this.getName();
    }

    protected String getShortTaskName() {
        return CVSUIMessages.Participant_comparing;
    }

    protected CVSChangeSetCapability createChangeSetCapability() {
        return new CVSChangeSetCapability(){

            public SubscriberChangeSetCollector getActiveChangeSetManager() {
                return CVSUIPlugin.getPlugin().getChangeSetManager();
            }

            public boolean enableActiveChangeSetsFor(ISynchronizePageConfiguration configuration) {
                return super.enableActiveChangeSetsFor(configuration) || configuration.getComparisonType() == "two-way";
            }
        };
    }

    public class CompareParticipantActionContribution
    extends SynchronizePageActionGroup {
        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CompareParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new CompareRevertAction(configuration));
            if (!configuration.getSite().isModal()) {
                ShowAnnotationAction showAnnotationAction = new ShowAnnotationAction();
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CompareParticipant.NON_MODAL_CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new CVSActionDelegateWrapper(showAnnotationAction, configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CompareParticipant.NON_MODAL_CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new CVSActionDelegateWrapper(new ShowResourceInHistoryAction(), configuration));
            }
        }
    }
}

