/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.SafeUpdateOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class MergeUpdateOperation
extends SafeUpdateOperation {
    Subscriber currentSubcriber = null;

    protected MergeUpdateOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, boolean promptBeforeUpdate) {
        super(configuration, elements, promptBeforeUpdate);
    }

    protected String getJobName() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return NLS.bind((String)CVSUIMessages.MergeUpdateAction_jobName, (Object[])new String[]{new Integer(syncSet.size()).toString()});
    }

    protected boolean getOverwriteLocalChanges() {
        return true;
    }

    protected void updated(IResource[] resources) throws TeamException {
        if (resources.length > 0 && this.currentSubcriber != null) {
            ((CVSMergeSubscriber)this.currentSubcriber).merged(resources);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runUpdateDeletions(SyncInfo[] nodes, IProgressMonitor monitor) throws TeamException {
        try {
            try {
                monitor.beginTask(null, 100 * nodes.length);
                int i = 0;
                while (i < nodes.length) {
                    IResource resource = nodes[i].getLocal();
                    if (resource.getType() == 1) {
                        ((IFile)resource).delete(false, true, Policy.subMonitorFor(monitor, 100));
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runSafeUpdate(SyncInfo[] nodes, IProgressMonitor monitor) throws TeamException {
        if (nodes.length <= 0) return;
        this.setSubscriber(nodes[0]);
        CVSTag startTag = ((CVSMergeSubscriber)this.currentSubcriber).getStartTag();
        CVSTag endTag = ((CVSMergeSubscriber)this.currentSubcriber).getEndTag();
        ArrayList<SyncInfo> additions = new ArrayList<SyncInfo>();
        ArrayList<SyncInfo> changes = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < nodes.length) {
            SyncInfo resource = nodes[i];
            int kind = resource.getKind();
            if ((kind & 3) == 1) {
                additions.add(resource);
            } else {
                changes.add(resource);
            }
            ++i;
        }
        try {
            monitor.beginTask(null, (additions.size() + changes.size()) * 100);
            if (!additions.isEmpty()) {
                this.safeUpdate(this.getIResourcesFrom(additions.toArray(new SyncInfo[additions.size()])), new Command.LocalOption[]{Command.DO_NOT_RECURSE, Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)endTag.getName())}, Policy.subMonitorFor(monitor, additions.size() * 100));
            }
            if (!changes.isEmpty()) {
                this.safeUpdate(this.getIResourcesFrom(changes.toArray(new SyncInfo[changes.size()])), new Command.LocalOption[]{Command.DO_NOT_RECURSE, Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)startTag.getName()), Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)endTag.getName())}, Policy.subMonitorFor(monitor, changes.size() * 100));
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void setSubscriber(SyncInfo node) throws CVSException {
        this.currentSubcriber = ((CVSSyncInfo)node).getSubscriber();
        if (!(this.currentSubcriber instanceof CVSMergeSubscriber)) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.MergeUpdateAction_invalidSubscriber, (Object[])new String[]{this.currentSubcriber.toString()}));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void overwriteUpdate(SyncInfoSet set, IProgressMonitor monitor) throws TeamException {
        SyncInfo[] nodes = set.getSyncInfos();
        if (nodes.length == 0) {
            return;
        }
        this.setSubscriber(nodes[0]);
        monitor.beginTask(null, 1000 * nodes.length);
        try {
            int i = 0;
            while (i < nodes.length) {
                this.makeRemoteLocal(nodes[i], Policy.subMonitorFor(monitor, 1000));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }
}

