/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class JRERuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver {
    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        IVMInstall jre = null;
        jre = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? JREContainerInitializer.resolveVM(entry.getPath()) : JavaRuntime.computeVMInstall(configuration);
        if (jre == null) {
            return new IRuntimeClasspathEntry[0];
        }
        return this.resolveLibraryLocations(jre, entry.getClasspathProperty());
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        IVMInstall jre = null;
        jre = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? JREContainerInitializer.resolveVM(entry.getPath()) : JavaRuntime.getVMInstall(project);
        if (jre == null) {
            return new IRuntimeClasspathEntry[0];
        }
        return this.resolveLibraryLocations(jre, entry.getClasspathProperty());
    }

    protected IRuntimeClasspathEntry[] resolveLibraryLocations(IVMInstall vm, int kind) {
        LibraryInfo libraryInfo;
        File vmInstallLocation;
        if (kind == 2 && (vmInstallLocation = vm.getInstallLocation()) != null && (libraryInfo = LaunchingPlugin.getLibraryInfo(vmInstallLocation.getAbsolutePath())) != null) {
            String[] bootpath = libraryInfo.getBootpath();
            int length = bootpath.length;
            LibraryLocation[] libs = JavaRuntime.getLibraryLocations(vm);
            ArrayList<IRuntimeClasspathEntry> resolvedEntries = new ArrayList<IRuntimeClasspathEntry>(length);
            int i = 0;
            while (i < length) {
                Path libPath = new Path(bootpath[i]);
                if (libPath.toFile().exists()) {
                    IRuntimeClasspathEntry resolved = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)libPath);
                    resolved.setClasspathProperty(2);
                    int j = 0;
                    while (j < libs.length) {
                        String resolvedPath = resolved.getPath().toString();
                        if (libs[j].getSystemLibraryPath().toString().equalsIgnoreCase(resolvedPath)) {
                            IPath path = libs[j].getSystemLibrarySourcePath();
                            if (path == null || path.isEmpty()) break;
                            resolved.setSourceAttachmentPath(path);
                            resolved.setSourceAttachmentRootPath(libs[j].getPackageRootPath());
                            break;
                        }
                        ++j;
                    }
                    resolvedEntries.add(resolved);
                }
                ++i;
            }
            return resolvedEntries.toArray(new IRuntimeClasspathEntry[resolvedEntries.size()]);
        }
        LibraryLocation[] libs = vm.getLibraryLocations();
        LibraryLocation[] defaultLibs = vm.getVMInstallType().getDefaultLibraryLocations(vm.getInstallLocation());
        if (libs == null) {
            libs = defaultLibs;
        } else if (!JRERuntimeClasspathEntryResolver.isSameArchives(libs, defaultLibs)) {
            kind = 2;
        }
        ArrayList<IRuntimeClasspathEntry> resolvedEntries = new ArrayList<IRuntimeClasspathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            IPath systemLibraryPath = libs[i].getSystemLibraryPath();
            if (systemLibraryPath.toFile().exists()) {
                IRuntimeClasspathEntry resolved = JavaRuntime.newArchiveRuntimeClasspathEntry(systemLibraryPath);
                IPath path = libs[i].getSystemLibrarySourcePath();
                if (path != null && !path.isEmpty()) {
                    resolved.setSourceAttachmentPath(path);
                    resolved.setSourceAttachmentRootPath(libs[i].getPackageRootPath());
                }
                resolved.setClasspathProperty(kind);
                resolvedEntries.add(resolved);
            }
            ++i;
        }
        return resolvedEntries.toArray(new IRuntimeClasspathEntry[resolvedEntries.size()]);
    }

    public static boolean isSameArchives(LibraryLocation[] libs, LibraryLocation[] defaultLibs) {
        if (libs.length != defaultLibs.length) {
            return false;
        }
        int i = 0;
        while (i < defaultLibs.length) {
            LibraryLocation def = defaultLibs[i];
            LibraryLocation lib = libs[i];
            if (!def.getSystemLibraryPath().equals((Object)lib.getSystemLibraryPath())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) {
        switch (entry.getEntryKind()) {
            case 4: {
                if (!entry.getPath().segment(0).equals("JRE_LIB")) break;
                return JavaRuntime.getDefaultVMInstall();
            }
            case 5: {
                if (!entry.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) break;
                return JREContainerInitializer.resolveVM(entry.getPath());
            }
        }
        return null;
    }
}

