/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.EditorMessages;

class DeleteLineTarget {
    private final DeleteLineClipboard fClipboard;

    public DeleteLineTarget(ITextViewer viewer) {
        this.fClipboard = new DeleteLineClipboard(viewer);
    }

    private static IRegion getDeleteRegion(IDocument document, int position, int type) throws BadLocationException {
        int line = document.getLineOfOffset(position);
        int offset = 0;
        int length = 0;
        switch (type) {
            case 0: {
                offset = document.getLineOffset(line);
                length = document.getLineLength(line);
                break;
            }
            case 1: {
                offset = document.getLineOffset(line);
                length = position - offset;
                break;
            }
            case 2: {
                offset = position;
                IRegion lineRegion = document.getLineInformation(line);
                int end = lineRegion.getOffset() + lineRegion.getLength();
                if (position == end) {
                    String lineDelimiter = document.getLineDelimiter(line);
                    length = lineDelimiter == null ? 0 : lineDelimiter.length();
                    break;
                }
                length = end - offset;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new Region(offset, length);
    }

    public void deleteLine(IDocument document, int position, int type, boolean copyToClipboard) throws BadLocationException {
        IRegion deleteRegion = DeleteLineTarget.getDeleteRegion(document, position, type);
        int offset = deleteRegion.getOffset();
        int length = deleteRegion.getLength();
        if (length == 0) {
            return;
        }
        if (copyToClipboard) {
            this.fClipboard.checkState();
            try {
                this.fClipboard.append(document.get(offset, length));
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                Status status = new Status(4, "org.eclipse.ui.workbench.texteditor", e.code, EditorMessages.Editor_error_clipboard_copy_failed_message, (Throwable)e);
                TextEditorPlugin.getDefault().getLog().log((IStatus)status);
                this.fClipboard.uninstall();
                return;
            }
            this.fClipboard.setDeleting(true);
            document.replace(offset, length, null);
            this.fClipboard.setDeleting(false);
            this.fClipboard.saveState();
        } else {
            document.replace(offset, length, null);
        }
    }

    private static class DeleteLineClipboard
    implements MouseListener,
    ModifyListener,
    ISelectionChangedListener,
    ITextListener,
    FocusListener {
        private final ITextViewer fViewer;
        private int fIndex = -1;
        private Clipboard fClipboard;
        private final StringBuffer fBuffer = new StringBuffer();
        private boolean fDeleting;

        public DeleteLineClipboard(ITextViewer viewer) {
            Assert.isNotNull((Object)viewer);
            this.fViewer = viewer;
        }

        public ITextViewer getViewer() {
            return this.fViewer;
        }

        private void saveState() {
            this.fIndex = this.fViewer.getTextWidget().getCaretOffset();
        }

        private boolean hasSameState() {
            return this.fIndex == this.fViewer.getTextWidget().getCaretOffset();
        }

        public void checkState() {
            if (this.fClipboard == null) {
                StyledText text = this.fViewer.getTextWidget();
                if (text == null) {
                    return;
                }
                this.fViewer.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
                text.addFocusListener((FocusListener)this);
                text.addMouseListener((MouseListener)this);
                text.addModifyListener((ModifyListener)this);
                this.fClipboard = new Clipboard(text.getDisplay());
                this.fBuffer.setLength(0);
            } else if (!this.hasSameState()) {
                this.fBuffer.setLength(0);
            }
        }

        public void append(String deltaString) {
            this.fBuffer.append(deltaString);
            String string = this.fBuffer.toString();
            Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
            Object[] data = new Object[]{string};
            this.fClipboard.setContents(data, dataTypes);
        }

        private void uninstall() {
            if (this.fClipboard == null) {
                return;
            }
            StyledText text = this.fViewer.getTextWidget();
            if (text == null) {
                return;
            }
            this.fViewer.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            text.removeFocusListener((FocusListener)this);
            text.removeMouseListener((MouseListener)this);
            text.removeModifyListener((ModifyListener)this);
            this.fClipboard.dispose();
            this.fClipboard = null;
        }

        public void setDeleting(boolean deleting) {
            this.fDeleting = deleting;
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.uninstall();
        }

        public void mouseDown(MouseEvent e) {
            this.uninstall();
        }

        public void mouseUp(MouseEvent e) {
            this.uninstall();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.uninstall();
        }

        public void focusGained(FocusEvent e) {
            this.uninstall();
        }

        public void focusLost(FocusEvent e) {
            this.uninstall();
        }

        public void textChanged(TextEvent event) {
            this.uninstall();
        }

        public void modifyText(ModifyEvent e) {
            if (!this.fDeleting) {
                this.uninstall();
            }
        }
    }
}

