/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.internal.texteditor.CompoundEditExitStrategy;
import org.eclipse.ui.internal.texteditor.ICompoundEditListener;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.TextEditorAction;

public class MoveLinesAction
extends TextEditorAction {
    private final boolean fUpwards;
    private final boolean fCopy;
    private final AbstractTextEditor fEditor;
    private final CompoundEditExitStrategy fStrategy;
    private boolean fAddDelimiter;
    private boolean fEditInProgress = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MoveLinesAction(ResourceBundle bundle, String prefix, AbstractTextEditor editor, boolean upwards, boolean copy) {
        super(bundle, prefix, editor);
        String[] stringArray;
        this.fEditor = editor;
        this.fUpwards = upwards;
        this.fCopy = copy;
        if (copy) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "org.eclipse.ui.edit.text.copyLineUp";
            stringArray = stringArray2;
            stringArray2[1] = "org.eclipse.ui.edit.text.copyLineDown";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "org.eclipse.ui.edit.text.moveLineUp";
            stringArray = stringArray3;
            stringArray3[1] = "org.eclipse.ui.edit.text.moveLineDown";
        }
        String[] commandIds = stringArray;
        this.fStrategy = new CompoundEditExitStrategy(commandIds);
        this.fStrategy.addCompoundListener(new ICompoundEditListener(){

            public void endCompoundEdit() {
                MoveLinesAction.this.endCompoundEdit();
            }
        });
        this.update();
    }

    private void beginCompoundEdit() {
        IRewriteTarget target;
        if (this.fEditInProgress || this.fEditor == null) {
            return;
        }
        this.fEditInProgress = true;
        this.fStrategy.arm((ITextViewer)this.fEditor.getSourceViewer());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((target = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
            target.beginCompoundChange();
        }
    }

    private boolean containedByVisibleRegion(ITextSelection selection, ISourceViewer viewer) {
        int min = selection.getOffset();
        int max = min + selection.getLength();
        IDocument document = viewer.getDocument();
        IRegion visible = viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)viewer).getModelCoverage() : viewer.getVisibleRegion();
        int visOffset = visible.getOffset();
        try {
            int visEnd;
            if (visOffset > min) {
                if (document.getLineOfOffset(visOffset) != selection.getStartLine()) {
                    return false;
                }
                if (!this.isWhitespace(document.get(min, visOffset - min))) {
                    this.showStatus();
                    return false;
                }
            }
            if ((visEnd = visOffset + visible.getLength()) < max) {
                if (document.getLineOfOffset(visEnd) != selection.getEndLine()) {
                    return false;
                }
                if (!this.isWhitespace(document.get(visEnd, max - visEnd))) {
                    this.showStatus();
                    return false;
                }
            }
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void endCompoundEdit() {
        IRewriteTarget target;
        if (!this.fEditInProgress || this.fEditor == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((target = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
            target.endCompoundChange();
        }
        this.fEditInProgress = false;
    }

    private ITextSelection getMovingSelection(IDocument document, ITextSelection selection, ISourceViewer viewer) throws BadLocationException {
        int low = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int high = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String delim = document.getLineDelimiter(endLine);
        if (delim != null) {
            high -= delim.length();
        }
        this.fAddDelimiter = delim != null && document.getLineLength(endLine) == delim.length();
        return new TextSelection(document, low, high - low);
    }

    private ITextSelection getSkippedLine(IDocument document, ITextSelection selection) {
        int skippedLineN;
        int n = skippedLineN = this.fUpwards ? selection.getStartLine() - 1 : selection.getEndLine() + 1;
        if (skippedLineN < 0 || skippedLineN >= document.getNumberOfLines()) {
            return null;
        }
        try {
            IRegion line = document.getLineInformation(skippedLineN);
            return new TextSelection(document, line.getOffset(), line.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    public void runWithEvent(Event event) {
        if (this.fEditor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText widget = viewer.getTextWidget();
        if (widget == null) {
            return;
        }
        Point p = viewer.getSelectedRange();
        if (p == null) {
            return;
        }
        TextSelection sel = new TextSelection(document, p.x, p.y);
        ITextSelection skippedLine = this.getSkippedLine(document, (ITextSelection)sel);
        if (skippedLine == null) {
            return;
        }
        try {
            int deviation;
            int offset;
            String insertion;
            String delim;
            ITextSelection movingArea = this.getMovingSelection(document, (ITextSelection)sel, viewer);
            if (!this.containedByVisibleRegion(movingArea, viewer) || !this.containedByVisibleRegion(skippedLine, viewer)) {
                return;
            }
            String moving = movingArea.getText();
            String skipped = skippedLine.getText();
            if (moving == null || skipped == null) {
                return;
            }
            if (this.fUpwards) {
                delim = document.getLineDelimiter(skippedLine.getEndLine());
                Assert.isNotNull((Object)delim);
                if (this.fCopy) {
                    insertion = String.valueOf(moving) + delim;
                    offset = movingArea.getOffset();
                    deviation = 0;
                } else {
                    insertion = String.valueOf(moving) + delim + skipped;
                    offset = skippedLine.getOffset();
                    deviation = -skippedLine.getLength() - delim.length();
                }
            } else {
                delim = document.getLineDelimiter(movingArea.getEndLine());
                Assert.isNotNull((Object)delim);
                if (this.fCopy) {
                    insertion = String.valueOf(moving) + delim;
                    offset = skippedLine.getOffset();
                    deviation = movingArea.getLength() + delim.length();
                } else {
                    insertion = String.valueOf(skipped) + delim + moving;
                    offset = movingArea.getOffset();
                    deviation = skipped.length() + delim.length();
                }
            }
            this.beginCompoundEdit();
            if (this.fCopy) {
                document.replace(offset, 0, insertion);
            } else {
                document.replace(offset, insertion.length(), insertion);
            }
            int selOffset = movingArea.getOffset() + deviation;
            int selLength = movingArea.getLength() + (this.fAddDelimiter ? delim.length() : 0);
            if (!(viewer instanceof ITextViewerExtension5)) {
                selLength = Math.min(selLength, viewer.getVisibleRegion().getOffset() + viewer.getVisibleRegion().getLength() - selOffset);
            }
            this.selectAndReveal((ITextViewer)viewer, selOffset, selLength);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    private void selectAndReveal(ITextViewer viewer, int offset, int length) {
        viewer.setSelectedRange(offset + length, -length);
        StyledText st = viewer.getTextWidget();
        if (st != null) {
            st.showSelection();
        }
    }

    private void showStatus() {
        IEditorStatusLine status;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((status = (IEditorStatusLine)this.fEditor.getAdapter(clazz)) == null) {
            return;
        }
        status.setMessage(false, EditorMessages.Editor_MoveLines_IllegalMove_status, null);
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }
}

