/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.event;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.service.event.TopicPermission;

final class TopicPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -614647783533924048L;
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof TopicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        TopicPermission pp = (TopicPermission)permission;
        String name = pp.getName();
        TopicPermission existing = (TopicPermission)this.permissions.get(name);
        if (existing != null) {
            int newMask;
            int oldMask = existing.getMask();
            if (oldMask != (newMask = pp.getMask())) {
                this.permissions.put(name, new TopicPermission(name, oldMask | newMask));
            }
        } else {
            this.permissions.put(name, permission);
        }
        if (!this.all_allowed && name.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int last;
        TopicPermission x;
        if (!(permission instanceof TopicPermission)) {
            return false;
        }
        TopicPermission pp = (TopicPermission)permission;
        int desired = pp.getMask();
        int effective = 0;
        if (this.all_allowed && (x = (TopicPermission)this.permissions.get("*")) != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        String name = pp.getName();
        x = (TopicPermission)this.permissions.get(name);
        if (x != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf("/", offset)) != -1) {
            x = (TopicPermission)this.permissions.get(name = String.valueOf(name.substring(0, last + 1)) + "*");
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

