/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.wireadmin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.wireadmin.WirePermissionCollection;

public final class WirePermission
extends BasicPermission {
    static final long serialVersionUID = -5583709391516569321L;
    public static final String PRODUCE = "produce";
    public static final String CONSUME = "consume";
    private static final int ACTION_PRODUCE = 1;
    private static final int ACTION_CONSUME = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private transient int action_mask = 0;
    private String actions = null;

    public WirePermission(String name, String actions) {
        this(name, WirePermission.getMask(actions));
    }

    WirePermission(String name, int mask) {
        super(name);
        this.init(mask);
    }

    private void init(int mask) {
        if (mask == 0 || (mask & 3) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String actions) {
        seencomma = false;
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl33
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 6 || a[i - 6] != 'p' && a[i - 6] != 'P' || a[i - 5] != 'r' && a[i - 5] != 'R' || a[i - 4] != 'o' && a[i - 4] != 'O' || a[i - 3] != 'd' && a[i - 3] != 'D' || a[i - 2] != 'u' && a[i - 2] != 'U' || a[i - 1] != 'c' && a[i - 1] != 'C' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 7;
                    mask |= 1;
                } else if (!(i < 6 || a[i - 6] != 'c' && a[i - 6] != 'C' || a[i - 5] != 'o' && a[i - 5] != 'O' || a[i - 4] != 'n' && a[i - 4] != 'N' || a[i - 3] != 's' && a[i - 3] != 'S' || a[i - 2] != 'u' && a[i - 2] != 'U' || a[i - 1] != 'm' && a[i - 1] != 'M' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 7;
                    mask |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl33:
                // 2 sources

            } while (i != -1);
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    public boolean implies(Permission p) {
        if (p instanceof WirePermission) {
            WirePermission target = (WirePermission)p;
            return (this.action_mask & target.action_mask) == target.action_mask && super.implies(p);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            if ((this.action_mask & 1) == 1) {
                sb.append(PRODUCE);
                comma = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(CONSUME);
            }
            this.actions = sb.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new WirePermissionCollection();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WirePermission)) {
            return false;
        }
        WirePermission p = (WirePermission)obj;
        return this.action_mask == p.action_mask && this.getName().equals(p.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.getClass().getName());
        sb.append(" \"");
        sb.append(this.getName());
        sb.append("\" \"");
        sb.append(this.getActions());
        sb.append("\")");
        return sb.toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(WirePermission.getMask(this.actions));
    }
}

