/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.keys.BindingPersistence;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;

public final class BindingService
implements IBindingService {
    private final BindingManager bindingManager;
    private WorkbenchKeyboard keyboard;

    public BindingService(BindingManager bindingManager, Workbench workbench) {
        if (bindingManager == null) {
            throw new NullPointerException("Cannot create a binding service with a null manager");
        }
        this.bindingManager = bindingManager;
        this.keyboard = new WorkbenchKeyboard(workbench);
        Display display = workbench.getDisplay();
        WorkbenchKeyboard.KeyDownFilter listener = this.keyboard.getKeyDownFilter();
        display.addFilter(1, (Listener)listener);
        display.addFilter(31, (Listener)listener);
        KeyFormatterFactory.setDefault((IKeyFormatter)SWTKeySupport.getKeyFormatterForPlatform());
    }

    public final TriggerSequence[] getActiveBindingsFor(ParameterizedCommand parameterizedCommand) {
        return this.bindingManager.getActiveBindingsFor(parameterizedCommand);
    }

    public final TriggerSequence[] getActiveBindingsFor(String commandId) {
        return this.bindingManager.getActiveBindingsFor(commandId);
    }

    public final Scheme getActiveScheme() {
        return this.bindingManager.getActiveScheme();
    }

    public final Binding[] getBindings() {
        return this.bindingManager.getBindings();
    }

    public final String getDefaultSchemeId() {
        return BindingPersistence.getDefaultSchemeId();
    }

    public final Scheme[] getDefinedSchemes() {
        return this.bindingManager.getDefinedSchemes();
    }

    public final WorkbenchKeyboard getKeyboard() {
        return this.keyboard;
    }

    public final String getLocale() {
        return this.bindingManager.getLocale();
    }

    public final Map getPartialMatches(TriggerSequence trigger) {
        return this.bindingManager.getPartialMatches(trigger);
    }

    public final Binding getPerfectMatch(TriggerSequence trigger) {
        return this.bindingManager.getPerfectMatch(trigger);
    }

    public final String getPlatform() {
        return this.bindingManager.getPlatform();
    }

    public final Scheme getScheme(String schemeId) {
        return this.bindingManager.getScheme(schemeId);
    }

    public final boolean isKeyFilterEnabled() {
        return this.keyboard.getKeyDownFilter().isEnabled();
    }

    public final boolean isPartialMatch(TriggerSequence sequence) {
        return this.bindingManager.isPartialMatch(sequence);
    }

    public final boolean isPerfectMatch(TriggerSequence sequence) {
        return this.bindingManager.isPerfectMatch(sequence);
    }

    public final void openKeyAssistDialog() {
        this.keyboard.openMultiKeyAssistShell();
    }

    public final void readRegistryAndPreferences(ICommandService commandService) {
        BindingPersistence.read(this.bindingManager, commandService);
    }

    public final void savePreferences(Scheme activeScheme, Binding[] bindings) throws IOException {
        BindingPersistence.write(activeScheme, bindings);
        try {
            this.bindingManager.setActiveScheme(activeScheme);
        }
        catch (NotDefinedException notDefinedException) {}
        this.bindingManager.setBindings(bindings);
    }

    public final void setKeyFilterEnabled(boolean enabled) {
        this.keyboard.getKeyDownFilter().setEnabled(enabled);
    }
}

