/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.operations.OperationHistoryActionHandler;

public final class UndoActionHandler
extends OperationHistoryActionHandler {
    public UndoActionHandler(IWorkbenchPartSite site, IUndoContext context) {
        super(site, context);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO"));
    }

    void flush() {
        this.getHistory().dispose(this.undoContext, true, false, false);
    }

    String getCommandString() {
        return WorkbenchMessages.Workbench_undo;
    }

    IUndoableOperation getOperation() {
        return this.getHistory().getUndoOperation(this.undoContext);
    }

    IStatus runCommand(IProgressMonitor pm) throws ExecutionException {
        return this.getHistory().undo(this.undoContext, pm, (IAdaptable)this);
    }

    boolean shouldBeEnabled() {
        if (this.undoContext == null) {
            return false;
        }
        return this.getHistory().canUndo(this.undoContext);
    }
}

