/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.RemoveBreakpointAction;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class RemoveBreakpointAction
extends AbstractRemoveActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final List state = ((BreakpointsView)this.getView()).getSelectionState();
        final Iterator itr = selection.iterator();
        CoreException[] exception = new CoreException[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                ArrayList breakpointsToDelete = new ArrayList();
                boolean deleteContainers = false;
                while (itr.hasNext()) {
                    Object next = itr.next();
                    if (next instanceof IBreakpoint) {
                        breakpointsToDelete.add(next);
                        continue;
                    }
                    if (!(next instanceof BreakpointContainer)) continue;
                    if (!deleteContainers && !(deleteContainers = MessageDialog.openConfirm((Shell)RemoveBreakpointAction.this.getView().getSite().getShell(), (String)ActionMessages.RemoveBreakpointAction_0, (String)ActionMessages.RemoveBreakpointAction_1))) {
                        return;
                    }
                    IBreakpoint[] breakpoints = ((BreakpointContainer)((Object)next)).getBreakpoints();
                    int i = 0;
                    while (i < breakpoints.length) {
                        breakpointsToDelete.add(breakpoints[i]);
                        ++i;
                    }
                }
                IBreakpoint[] breakpoints = breakpointsToDelete.toArray(new IBreakpoint[0]);
                new Job(this, ActionMessages.RemoveBreakpointAction_2, breakpoints, state){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ IBreakpoint[] val$breakpoints;
                    private final /* synthetic */ List val$state;
                    {
                        this.this$1 = var1_1;
                        this.val$breakpoints = iBreakpointArray;
                        this.val$state = list;
                    }

                    protected IStatus run(IProgressMonitor pmonitor) {
                        try {
                            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(this.val$breakpoints, true);
                            if (this.val$state != null) {
                                Runnable r = new Runnable(this, this.val$state){
                                    final /* synthetic */ 2 this$2;
                                    private final /* synthetic */ List val$state;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$state = list;
                                    }

                                    public void run() {
                                        ((BreakpointsView)1.access$0(2.access$0(this.this$2)).getView()).preserveSelectionState(this.val$state);
                                    }
                                };
                                DebugUIPlugin.getStandardDisplay().asyncExec(r);
                            }
                            return Status.OK_STATUS;
                        }
                        catch (CoreException e) {
                            DebugUIPlugin.log(e);
                            return Status.CANCEL_STATUS;
                        }
                    }

                    static /* synthetic */ 1 access$0(2 var0) {
                        return var0.this$1;
                    }
                }.schedule();
            }

            static /* synthetic */ RemoveBreakpointAction access$0(1 var0) {
                return var0.RemoveBreakpointAction.this;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException ce) {
            exception[0] = ce;
        }
        if (exception[0] != null) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.RemoveBreakpointAction_Removing_a_breakpoint_4, ActionMessages.RemoveBreakpointAction_Exceptions_occurred_attempting_to_remove_a_breakpoint__5, exception[0]);
            } else {
                DebugUIPlugin.log(exception[0]);
            }
        }
    }

    protected void doAction(Object element) {
    }

    protected boolean isEnabledFor(Object element) {
        if (element instanceof BreakpointContainer) {
            return ((BreakpointContainer)((Object)element)).getChildren().length > 0;
        }
        return super.isEnabledFor(element);
    }
}

