/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.RemoteVariableContentManager;
import org.eclipse.debug.ui.DeferredDebugElementWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredVariable
extends DeferredDebugElementWorkbenchAdapter {
    private static final IVariable[] EMPTY_VARS = new IVariable[0];

    public Object[] getChildren(Object parent) {
        if (parent instanceof IVariable) {
            try {
                IVariable variable = (IVariable)parent;
                IValue value = variable.getValue();
                if (value != null) {
                    return this.getValueChildren((IDebugElement)variable, value);
                }
            }
            catch (DebugException debugException) {}
        }
        return EMPTY;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Object[] children = this.getChildren(object);
        if (monitor.isCanceled()) {
            return;
        }
        if (children.length > 0) {
            if (collector instanceof RemoteVariableContentManager.VariableCollector) {
                RemoteVariableContentManager.VariableCollector remoteCollector = (RemoteVariableContentManager.VariableCollector)collector;
                int i = 0;
                while (i < children.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    Object child = children[i];
                    remoteCollector.setHasChildren(child, this.hasChildren(child));
                    ++i;
                }
            }
            collector.add(children, monitor);
        }
        collector.done();
    }

    protected boolean hasChildren(Object child) {
        if (child instanceof IVariable) {
            IVariable var = (IVariable)child;
            try {
                IValue value = var.getValue();
                return value.hasVariables();
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    public Object getParent(Object element) {
        return null;
    }

    protected IVariable[] getValueChildren(IDebugElement parent, IValue value) throws DebugException {
        IIndexedValue indexedValue;
        int partitionSize;
        if (value == null) {
            return EMPTY_VARS;
        }
        IValue logicalValue = this.getLogicalValue(value);
        if (logicalValue instanceof IIndexedValue && (partitionSize = this.computeParitionSize(indexedValue = (IIndexedValue)logicalValue)) > 1) {
            int offset = indexedValue.getInitialOffset();
            int length = indexedValue.getSize();
            int numPartitions = length / partitionSize;
            int remainder = length % partitionSize;
            if (remainder > 0) {
                ++numPartitions;
            }
            IVariable[] partitions = new IVariable[numPartitions];
            int i = 0;
            while (i < numPartitions - 1) {
                partitions[i] = new IndexedVariablePartition(parent, indexedValue, offset, partitionSize);
                offset += partitionSize;
                ++i;
            }
            if (remainder == 0) {
                remainder = partitionSize;
            }
            partitions[numPartitions - 1] = new IndexedVariablePartition(parent, indexedValue, offset, remainder);
            return partitions;
        }
        if (logicalValue == null) {
            logicalValue = value;
        }
        return logicalValue.getVariables();
    }

    protected IValue getLogicalValue(IValue value) {
        return this.getLogicalValue(value, new ArrayList());
    }

    private IValue getLogicalValue(IValue value, List previousStructureIds) {
        ILogicalStructureType type;
        ILogicalStructureType[] types;
        if (this.isShowLogicalStructure() && (types = DebugPlugin.getLogicalStructureTypes((IValue)value)).length > 0 && (type = DebugPlugin.getDefaultStructureType((ILogicalStructureType[])types)) != null && !previousStructureIds.contains(type.getId())) {
            try {
                value = type.getLogicalStructure(value);
                previousStructureIds.add(type.getId());
                return this.getLogicalValue(value, previousStructureIds);
            }
            catch (CoreException coreException) {}
        }
        return value;
    }

    protected boolean isShowLogicalStructure() {
        return false;
    }

    protected int computeParitionSize(IIndexedValue value) {
        int partitionSize = 1;
        try {
            int length = value.getSize();
            int partitionDepth = 0;
            int preferredSize = this.getArrayPartitionSize();
            int remainder = length % preferredSize;
            length /= preferredSize;
            while (length > 0) {
                if (remainder == 0 && length == 1) break;
                ++partitionDepth;
                remainder = length % preferredSize;
                length /= preferredSize;
            }
            int i = 0;
            while (i < partitionDepth) {
                partitionSize *= preferredSize;
                ++i;
            }
        }
        catch (DebugException debugException) {}
        return partitionSize;
    }

    protected int getArrayPartitionSize() {
        return 100;
    }
}

