/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.AbstractViewerState;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public class ViewerState
extends AbstractViewerState {
    public ViewerState(TreeViewer viewer) {
        super(viewer);
    }

    public ViewerState() {
    }

    protected IPath encodeElement(TreeItem item) throws DebugException {
        Object data = item.getData();
        if (data instanceof IVariable) {
            IVariable variable = (IVariable)data;
            Path path = new Path(variable.getName());
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                variable = (IVariable)parent.getData();
                path = new Path(variable.getName()).append((IPath)path);
                parent = parent.getParentItem();
            }
            return path;
        }
        return null;
    }

    protected Object decodePath(IPath path, TreeViewer viewer) throws DebugException {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        String[] names = path.segments();
        Object parent = viewer.getInput();
        IVariable variable = null;
        int i = 0;
        while (i < names.length) {
            variable = null;
            Object[] children = null;
            children = viewer instanceof RemoteTreeViewer ? ((RemoteTreeViewer)viewer).getCurrentChildren(parent) : contentProvider.getChildren(parent);
            if (children == null) {
                return null;
            }
            String name = names[i];
            if (children != null) {
                int j = 0;
                while (j < children.length) {
                    IVariable var;
                    if (children[j] instanceof IVariable && (var = (IVariable)children[j]).getName().equals(name)) {
                        variable = var;
                        break;
                    }
                    ++j;
                }
            }
            if (variable == null) {
                return null;
            }
            parent = variable;
            ++i;
        }
        return variable;
    }

    public AbstractViewerState copy() {
        ViewerState copy = new ViewerState();
        if (this.fSavedExpansion != null) {
            copy.fSavedExpansion = new ArrayList();
            Iterator iter = this.fSavedExpansion.iterator();
            while (iter.hasNext()) {
                copy.fSavedExpansion.add(iter.next());
            }
        }
        if (this.fSelection != null) {
            copy.fSelection = new IPath[this.fSelection.length];
            int i = 0;
            while (i < this.fSelection.length) {
                IPath sel;
                copy.fSelection[i] = sel = this.fSelection[i];
                ++i;
            }
        }
        return copy;
    }
}

