/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class CommonTab
extends AbstractLaunchConfigurationTab {
    private Button fLocalRadioButton;
    private Button fSharedRadioButton;
    private Text fSharedLocationText;
    private Button fSharedLocationButton;
    protected Button fLaunchInBackgroundButton;
    private CheckboxTableViewer fFavoritesTable;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            CommonTab.this.updateLaunchConfigurationDialog();
        }
    };
    private Button fDefaultEncodingButton;
    private Button fAltEncodingButton;
    private Combo fEncodingCombo;
    private Button fConsoleOutput;
    private Button fFileOutput;
    private Button fFileBrowse;
    private Text fFileText;
    private Button fVariables;
    private Button fAppend;
    private Button fWorkspaceBrowse;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_COMMON_TAB);
        GridLayout topLayout = new GridLayout(2, true);
        topLayout.horizontalSpacing = 10;
        comp.setLayout((Layout)topLayout);
        comp.setFont(parent.getFont());
        Group group = new Group(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setText(LaunchConfigurationsMessages.CommonTab_0);
        group.setFont(comp.getFont());
        this.setLocalRadioButton(new Button((Composite)group, 16));
        this.getLocalRadioButton().setText(LaunchConfigurationsMessages.CommonTab_L_ocal_3);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.getLocalRadioButton().setLayoutData((Object)gd);
        this.setSharedRadioButton(new Button((Composite)group, 16));
        this.getSharedRadioButton().setText(LaunchConfigurationsMessages.CommonTab_S_hared_4);
        this.getSharedRadioButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CommonTab.this.handleSharedRadioButtonSelected();
            }
        });
        gd = new GridData();
        this.getSharedRadioButton().setLayoutData((Object)gd);
        this.setSharedLocationText(new Text((Composite)group, 2052));
        gd = new GridData(768);
        this.getSharedLocationText().setLayoutData((Object)gd);
        this.getSharedLocationText().addModifyListener(this.fBasicModifyListener);
        this.setSharedLocationButton(this.createPushButton((Composite)group, LaunchConfigurationsMessages.CommonTab__Browse_6, null));
        this.getSharedLocationButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CommonTab.this.handleSharedLocationButtonSelected();
            }
        });
        this.getLocalRadioButton().setSelection(true);
        this.setSharedEnabled(false);
        Group favComp = new Group(comp, 0);
        gd = new GridData(1808);
        favComp.setLayoutData((Object)gd);
        GridLayout favLayout = new GridLayout();
        favComp.setLayout((Layout)favLayout);
        favComp.setText(LaunchConfigurationsMessages.CommonTab_Display_in_favorites_menu__10);
        favComp.setFont(parent.getFont());
        this.fFavoritesTable = CheckboxTableViewer.newCheckList((Composite)favComp, (int)67618);
        Control table = this.fFavoritesTable.getControl();
        gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        this.fFavoritesTable.setContentProvider((IContentProvider)new FavoritesContentProvider());
        this.fFavoritesTable.setLabelProvider((IBaseLabelProvider)new FavoritesLabelProvider());
        this.fFavoritesTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createEncodingComponent(comp);
        this.createOutputCaptureComponent(comp);
        this.createLaunchInBackgroundComponent(comp);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createOutputCaptureComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LaunchConfigurationsMessages.CommonTab_4);
        GridData gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(5, false);
        group.setLayout((Layout)layout);
        group.setFont(parent.getFont());
        this.fConsoleOutput = this.createCheckButton((Composite)group, LaunchConfigurationsMessages.CommonTab_5);
        gd = new GridData(1, 0, true, false);
        gd.horizontalSpan = 5;
        this.fConsoleOutput.setLayoutData((Object)gd);
        this.fConsoleOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fFileOutput = this.createCheckButton((Composite)group, LaunchConfigurationsMessages.CommonTab_6);
        this.fFileOutput.setLayoutData((Object)new GridData(1, 0, false, false));
        this.fFileText = new Text((Composite)group, 2052);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 4;
        this.fFileText.setLayoutData((Object)gd);
        Label spacer = new Label((Composite)group, 0);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 2;
        spacer.setLayoutData((Object)gd);
        this.fWorkspaceBrowse = this.createPushButton((Composite)group, LaunchConfigurationsMessages.CommonTab_12, null);
        this.fFileBrowse = this.createPushButton((Composite)group, LaunchConfigurationsMessages.CommonTab_7, null);
        this.fVariables = this.createPushButton((Composite)group, LaunchConfigurationsMessages.CommonTab_9, null);
        spacer = new Label((Composite)group, 0);
        spacer.setLayoutData((Object)new GridData(4, 0, false, false));
        this.fAppend = this.createCheckButton((Composite)group, LaunchConfigurationsMessages.CommonTab_11);
        gd = new GridData(16384, 128, true, false);
        gd.horizontalSpan = 4;
        this.fAppend.setLayoutData((Object)gd);
        this.fFileOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = CommonTab.this.fFileOutput.getSelection();
                CommonTab.this.fFileText.setEnabled(enabled);
                CommonTab.this.fFileBrowse.setEnabled(enabled);
                CommonTab.this.fWorkspaceBrowse.setEnabled(enabled);
                CommonTab.this.fVariables.setEnabled(enabled);
                CommonTab.this.fAppend.setEnabled(enabled);
                CommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAppend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(CommonTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(LaunchConfigurationsMessages.CommonTab_13);
                dialog.setMessage(LaunchConfigurationsMessages.CommonTab_14);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setSorter((ViewerSorter)new ResourceSorter(1));
                int buttonId = dialog.open();
                if (buttonId == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                    CommonTab.this.fFileText.setText(fileLoc);
                }
            }
        });
        this.fFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = CommonTab.this.fFileText.getText();
                FileDialog dialog = new FileDialog(CommonTab.this.getShell(), 8192);
                filePath = dialog.open();
                if (filePath != null) {
                    CommonTab.this.fFileText.setText(filePath);
                }
            }
        });
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fVariables.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(CommonTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    CommonTab.this.fFileText.insert(variable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createEncodingComponent(Composite parent) {
        List allEncodings = IDEEncoding.getIDEEncodings();
        String defaultEncoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
        Group group = new Group(parent, 0);
        group.setText(LaunchConfigurationsMessages.CommonTab_1);
        GridData gd = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        group.setFont(parent.getFont());
        this.fDefaultEncodingButton = this.createRadioButton((Composite)group, MessageFormat.format(LaunchConfigurationsMessages.CommonTab_2, defaultEncoding));
        gd = new GridData(1, 0, true, false);
        gd.horizontalSpan = 2;
        this.fDefaultEncodingButton.setLayoutData((Object)gd);
        this.fAltEncodingButton = this.createRadioButton((Composite)group, LaunchConfigurationsMessages.CommonTab_3);
        this.fAltEncodingButton.setLayoutData((Object)new GridData(32));
        this.fEncodingCombo = new Combo((Composite)group, 8);
        this.fEncodingCombo.setLayoutData((Object)new GridData(768));
        String[] encodingArray = allEncodings.toArray(new String[0]);
        this.fEncodingCombo.setItems(encodingArray);
        if (encodingArray.length > 0) {
            this.fEncodingCombo.select(0);
        }
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonTab.this.updateLaunchConfigurationDialog();
                CommonTab.this.fEncodingCombo.setEnabled(CommonTab.this.fAltEncodingButton.getSelection());
            }
        };
        this.fAltEncodingButton.addSelectionListener((SelectionListener)listener);
        this.fDefaultEncodingButton.addSelectionListener((SelectionListener)listener);
        this.fEncodingCombo.addSelectionListener((SelectionListener)listener);
    }

    protected void createLaunchInBackgroundComponent(Composite parent) {
        this.fLaunchInBackgroundButton = this.createCheckButton(parent, LaunchConfigurationsMessages.CommonTab_10);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.fLaunchInBackgroundButton.setLayoutData((Object)data);
        this.fLaunchInBackgroundButton.setFont(parent.getFont());
        this.fLaunchInBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void setSharedLocationButton(Button sharedLocationButton) {
        this.fSharedLocationButton = sharedLocationButton;
    }

    private Button getSharedLocationButton() {
        return this.fSharedLocationButton;
    }

    private void setSharedLocationText(Text sharedLocationText) {
        this.fSharedLocationText = sharedLocationText;
    }

    private Text getSharedLocationText() {
        return this.fSharedLocationText;
    }

    private void setLocalRadioButton(Button button) {
        this.fLocalRadioButton = button;
    }

    private Button getLocalRadioButton() {
        return this.fLocalRadioButton;
    }

    private void setSharedRadioButton(Button button) {
        this.fSharedRadioButton = button;
    }

    private Button getSharedRadioButton() {
        return this.fSharedRadioButton;
    }

    private void handleSharedRadioButtonSelected() {
        this.setSharedEnabled(this.isShared());
        this.updateLaunchConfigurationDialog();
    }

    private void setSharedEnabled(boolean enable) {
        this.getSharedLocationText().setEnabled(enable);
        this.getSharedLocationButton().setEnabled(enable);
    }

    private boolean isShared() {
        return this.getSharedRadioButton().getSelection();
    }

    private void handleSharedLocationButtonSelected() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)this.getWorkspaceRoot(), false, LaunchConfigurationsMessages.CommonTab_Select_a_location_for_the_launch_configuration_13);
        String currentContainerString = this.getSharedLocationText().getText();
        IContainer currentContainer = this.getContainer(currentContainerString);
        if (currentContainer != null) {
            IPath path = currentContainer.getFullPath();
            dialog.setInitialSelections(new Object[]{path});
        }
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.toOSString();
            this.getSharedLocationText().setText(containerName);
        }
    }

    private IContainer getContainer(String path) {
        Path containerPath = new Path(path);
        return (IContainer)this.getWorkspaceRoot().findMember((IPath)containerPath);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateLocalSharedFromConfig(configuration);
        this.updateSharedLocationFromConfig(configuration);
        this.updateFavoritesFromConfig(configuration);
        this.updateLaunchInBackground(configuration);
        this.updateEncoding(configuration);
        this.updateConsoleOutput(configuration);
    }

    private void updateConsoleOutput(ILaunchConfiguration configuration) {
        boolean haveOutputFile;
        boolean outputToConsole = true;
        String outputFile = null;
        boolean append = false;
        try {
            outputToConsole = configuration.getAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_CONSOLE, true);
            outputFile = configuration.getAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_FILE, null);
            append = configuration.getAttribute(IDebugUIConstants.ATTR_APPEND_TO_FILE, false);
        }
        catch (CoreException coreException) {}
        this.fConsoleOutput.setSelection(outputToConsole);
        this.fAppend.setSelection(append);
        boolean bl = haveOutputFile = outputFile != null;
        if (haveOutputFile) {
            this.fFileText.setText(outputFile);
        }
        this.fFileOutput.setSelection(haveOutputFile);
        this.fFileText.setEnabled(haveOutputFile);
        this.fFileBrowse.setEnabled(haveOutputFile);
        this.fWorkspaceBrowse.setEnabled(haveOutputFile);
        this.fVariables.setEnabled(haveOutputFile);
        this.fAppend.setEnabled(haveOutputFile);
    }

    protected void updateLaunchInBackground(ILaunchConfiguration configuration) {
        this.fLaunchInBackgroundButton.setSelection(CommonTab.isLaunchInBackground(configuration));
    }

    private void updateEncoding(ILaunchConfiguration configuration) {
        String encoding = null;
        try {
            encoding = configuration.getAttribute(IDebugUIConstants.ATTR_CONSOLE_ENCODING, null);
        }
        catch (CoreException coreException) {}
        if (encoding != null) {
            this.fAltEncodingButton.setSelection(true);
            this.fDefaultEncodingButton.setSelection(false);
            this.fEncodingCombo.setText(encoding);
            this.fEncodingCombo.setEnabled(true);
        } else {
            this.fDefaultEncodingButton.setSelection(true);
            this.fAltEncodingButton.setSelection(false);
            this.fEncodingCombo.setEnabled(false);
        }
    }

    public static boolean isLaunchInBackground(ILaunchConfiguration configuration) {
        boolean launchInBackground = true;
        try {
            launchInBackground = configuration.getAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, true);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return launchInBackground;
    }

    private void updateLocalSharedFromConfig(ILaunchConfiguration config) {
        boolean isShared = !config.isLocal();
        this.getSharedRadioButton().setSelection(isShared);
        this.getLocalRadioButton().setSelection(!isShared);
        this.setSharedEnabled(isShared);
    }

    private void updateSharedLocationFromConfig(ILaunchConfiguration config) {
        IContainer parent;
        this.getSharedLocationText().setText("");
        IFile file = config.getFile();
        if (file != null && (parent = file.getParent()) != null) {
            String containerName = parent.getFullPath().toOSString();
            this.getSharedLocationText().setText(containerName);
        }
    }

    private void updateFavoritesFromConfig(ILaunchConfiguration config) {
        this.fFavoritesTable.setInput((Object)config);
        this.fFavoritesTable.setCheckedElements(new Object[0]);
        try {
            List groups = config.getAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, new ArrayList());
            if (groups.isEmpty()) {
                if (config.getAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, false)) {
                    groups.add(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP);
                }
                if (config.getAttribute(IDebugUIConstants.ATTR_RUN_FAVORITE, false)) {
                    groups.add(IDebugUIConstants.ID_RUN_LAUNCH_GROUP);
                }
            }
            if (!groups.isEmpty()) {
                ArrayList<LaunchGroupExtension> list = new ArrayList<LaunchGroupExtension>();
                Iterator iterator = groups.iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    LaunchGroupExtension extension = this.getLaunchConfigurationManager().getLaunchGroup(id);
                    list.add(extension);
                }
                this.fFavoritesTable.setCheckedElements(list.toArray());
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private void updateConfigFromLocalShared(ILaunchConfigurationWorkingCopy config) {
        if (this.isShared()) {
            String containerPathString = this.getSharedLocationText().getText();
            IContainer container = this.getContainer(containerPathString);
            config.setContainer(container);
        } else {
            config.setContainer(null);
        }
    }

    private void updateConfigFromFavorites(ILaunchConfigurationWorkingCopy config) {
        try {
            ArrayList<Object> groups;
            Object[] checked = this.fFavoritesTable.getCheckedElements();
            boolean debug = config.getAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, false);
            boolean run = config.getAttribute(IDebugUIConstants.ATTR_RUN_FAVORITE, false);
            if (debug || run) {
                groups = new ArrayList<Object>();
                int num = 0;
                if (debug) {
                    groups.add(this.getLaunchConfigurationManager().getLaunchGroup(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP));
                    ++num;
                }
                if (run) {
                    ++num;
                    groups.add(this.getLaunchConfigurationManager().getLaunchGroup(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP));
                }
                if (num == checked.length) {
                    boolean different = false;
                    int i = 0;
                    while (i < checked.length) {
                        if (!groups.contains(checked[i])) {
                            different = true;
                            break;
                        }
                        ++i;
                    }
                    if (!different) {
                        return;
                    }
                }
            }
            config.setAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, null);
            config.setAttribute(IDebugUIConstants.ATTR_RUN_FAVORITE, null);
            groups = null;
            int i = 0;
            while (i < checked.length) {
                LaunchGroupExtension group = (LaunchGroupExtension)checked[i];
                if (groups == null) {
                    groups = new ArrayList();
                }
                groups.add(group.getIdentifier());
                ++i;
            }
            config.setAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, groups);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        this.setErrorMessage(null);
        return this.validateLocalShared() && this.validateRedirectFile() && this.validateEncoding();
    }

    private boolean validateEncoding() {
        if (this.fAltEncodingButton.getSelection() && this.fEncodingCombo.getSelectionIndex() == -1) {
            this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_No_Encoding_Selected);
            return false;
        }
        return true;
    }

    private boolean validateRedirectFile() {
        int len;
        if (this.fFileOutput.getSelection() && (len = this.fFileText.getText().trim().length()) == 0) {
            this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_8);
            return false;
        }
        return true;
    }

    private boolean validateLocalShared() {
        if (this.isShared()) {
            String path = this.fSharedLocationText.getText().trim();
            IContainer container = this.getContainer(path);
            if (container == null || container.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
                this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_Invalid_shared_configuration_location_14);
                return false;
            }
            if (!container.getProject().isOpen()) {
                this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_Cannot_save_launch_configuration_in_a_closed_project__1);
                return false;
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setContainer(null);
        config.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.updateConfigFromLocalShared(configuration);
        this.updateConfigFromFavorites(configuration);
        this.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, configuration, this.fLaunchInBackgroundButton.getSelection(), true);
        String encoding = null;
        if (this.fAltEncodingButton.getSelection()) {
            encoding = this.fEncodingCombo.getText();
        }
        configuration.setAttribute(IDebugUIConstants.ATTR_CONSOLE_ENCODING, encoding);
        boolean captureOutput = false;
        if (this.fConsoleOutput.getSelection()) {
            captureOutput = true;
            configuration.setAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_CONSOLE, null);
        } else {
            configuration.setAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_CONSOLE, false);
        }
        if (this.fFileOutput.getSelection()) {
            captureOutput = true;
            String file = this.fFileText.getText();
            configuration.setAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_FILE, file);
            if (this.fAppend.getSelection()) {
                configuration.setAttribute(IDebugUIConstants.ATTR_APPEND_TO_FILE, true);
            } else {
                configuration.setAttribute(IDebugUIConstants.ATTR_APPEND_TO_FILE, null);
            }
        } else {
            configuration.setAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_FILE, null);
        }
        if (!captureOutput) {
            configuration.setAttribute("org.eclipse.debug.core.capture_output", false);
        } else {
            configuration.setAttribute("org.eclipse.debug.core.capture_output", null);
        }
    }

    public String getName() {
        return LaunchConfigurationsMessages.CommonTab__Common_15;
    }

    public boolean canSave() {
        return this.validateLocalShared();
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_OBJS_COMMON_TAB");
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    class FavoritesContentProvider
    implements IStructuredContentProvider {
        FavoritesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
            ArrayList<ILaunchGroup> possibleGroups = new ArrayList<ILaunchGroup>();
            ILaunchConfiguration configuration = (ILaunchConfiguration)inputElement;
            int i = 0;
            while (i < groups.length) {
                ILaunchGroup extension = groups[i];
                LaunchHistory history = CommonTab.this.getLaunchConfigurationManager().getLaunchHistory(extension.getIdentifier());
                if (history != null && history.accepts(configuration)) {
                    possibleGroups.add(extension);
                }
                ++i;
            }
            return possibleGroups.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class FavoritesLabelProvider
    implements ITableLabelProvider {
        private Map fImages = new HashMap();

        FavoritesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ImageDescriptor descriptor;
            Image image = (Image)this.fImages.get(element);
            if (image == null && (descriptor = ((LaunchGroupExtension)element).getImageDescriptor()) != null) {
                image = descriptor.createImage();
                this.fImages.put(element, image);
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String label = ((LaunchGroupExtension)element).getLabel();
            return DebugUIPlugin.removeAccelerators(label);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            Iterator images = this.fImages.values().iterator();
            while (images.hasNext()) {
                Image image = (Image)images.next();
                image.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

