/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.swt.graphics.Image;

public class LogViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image infoImage;
    private Image okImage;
    private Image errorImage = PDERuntimePluginImages.DESC_ERROR_ST_OBJ.createImage();
    private Image warningImage = PDERuntimePluginImages.DESC_WARNING_ST_OBJ.createImage();
    private Image errorWithStackImage;

    public LogViewLabelProvider() {
        this.infoImage = PDERuntimePluginImages.DESC_INFO_ST_OBJ.createImage();
        this.okImage = PDERuntimePluginImages.DESC_OK_ST_OBJ.createImage();
        this.errorWithStackImage = PDERuntimePluginImages.DESC_ERROR_STACK_OBJ.createImage();
    }

    public void dispose() {
        this.errorImage.dispose();
        this.infoImage.dispose();
        this.okImage.dispose();
        this.warningImage.dispose();
        this.errorWithStackImage.dispose();
        super.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        LogEntry entry = (LogEntry)((Object)element);
        if (columnIndex == 0) {
            switch (entry.getSeverity()) {
                case 1: {
                    return this.infoImage;
                }
                case 0: {
                    return this.okImage;
                }
                case 2: {
                    return this.warningImage;
                }
            }
            return entry.getStack() == null ? this.errorImage : this.errorWithStackImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        LogEntry entry = (LogEntry)((Object)element);
        switch (columnIndex) {
            case 0: {
                return entry.getMessage() != null ? entry.getMessage() : "";
            }
            case 1: {
                return entry.getPluginId() != null ? entry.getPluginId() : "";
            }
            case 2: {
                return entry.getDate() != null ? entry.getDate() : "";
            }
        }
        return "";
    }
}

