/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.TextConsole;

public class JavaStackTraceConsole
extends TextConsole {
    public static final String CONSOLE_TYPE = "javaStackTraceConsole";
    public static final String FILE_NAME = String.valueOf(JDIDebugUIPlugin.getDefault().getStateLocation().toOSString()) + File.separator + "stackTraceConsole.txt";
    private JavaStackTraceConsolePartitioner partitioner = new JavaStackTraceConsolePartitioner();
    private IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("org.eclipse.debug.ui.consoleFont")) {
                JavaStackTraceConsole.this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            }
        }
    };

    public JavaStackTraceConsole() {
        super(ConsoleMessages.JavaStackTraceConsoleFactory_0, CONSOLE_TYPE, null, true);
        Font font = JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont");
        this.setFont(font);
        this.partitioner.connect(this.getDocument());
    }

    void initializeDocument() {
        File file = new File(FILE_NAME);
        if (file.exists()) {
            try {
                int len = (int)file.length();
                byte[] b = new byte[len];
                FileInputStream fin = new FileInputStream(file);
                int read = 0;
                while (read < len) {
                    read += fin.read(b);
                }
                this.getDocument().set(new String(b));
                fin.close();
            }
            catch (IOException iOException) {}
        } else {
            this.getDocument().set(ConsoleMessages.JavaStackTraceConsole_0);
        }
    }

    protected void init() {
        JFaceResources.getFontRegistry().addListener(this.propertyListener);
    }

    protected void dispose() {
        this.saveDocument();
        JFaceResources.getFontRegistry().removeListener(this.propertyListener);
        super.dispose();
    }

    void saveDocument() {
        try {
            IDocument document = this.getDocument();
            if (document != null) {
                if (document.getLength() > 0) {
                    String contents = document.get();
                    FileOutputStream fout = new FileOutputStream(FILE_NAME);
                    fout.write(contents.getBytes());
                    fout.close();
                } else {
                    File file = new File(FILE_NAME);
                    file.delete();
                }
            }
        }
        catch (IOException iOException) {}
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    class JavaStackTraceConsolePartitioner
    extends DefaultPartitioner
    implements IConsoleDocumentPartitioner {
        public JavaStackTraceConsolePartitioner() {
            super((IPartitionTokenScanner)new RuleBasedPartitionScanner(), null);
            JavaStackTraceConsole.this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this);
        }

        public boolean isReadOnly(int offset) {
            return false;
        }

        public StyleRange[] getStyleRanges(int offset, int length) {
            return null;
        }
    }
}

