/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import org.eclipse.core.internal.resources.mapping.ResourceMapping;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;
import org.eclipse.team.internal.ui.dialogs.IResourceMappingResourceFilter;
import org.eclipse.team.internal.ui.dialogs.ResourceMappingResourceDisplayArea;
import org.eclipse.team.internal.ui.dialogs.ResourceMappingSelectionArea;

public abstract class MappingSelectionDialog
extends DetailsDialog
implements IPropertyChangeListener {
    private final ResourceMapping[] mappings;
    private ResourceMapping[] checkedMappings;
    private ResourceMappingSelectionArea mappingArea;
    private ResourceMappingResourceDisplayArea resourceArea;
    private final IResourceMappingResourceFilter filter;

    protected MappingSelectionDialog(Shell parentShell, String dialogTitle, ResourceMapping[] mappings, IResourceMappingResourceFilter filter) {
        super(parentShell, dialogTitle);
        this.mappings = mappings;
        this.filter = filter;
    }

    protected void createMainDialogArea(Composite parent) {
        if (this.mappings.length == 1) {
            this.createWrappingLabel(parent, this.getSingleMappingMessage(this.mappings[0]));
        } else {
            this.createMappingSelectionArea(parent);
        }
    }

    private void createMappingSelectionArea(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.mappingArea = new ResourceMappingSelectionArea(this.mappings);
        this.mappingArea.setDescription(this.getMultipleMappingsMessage());
        this.mappingArea.addPropertyChangeListener(this);
        this.mappingArea.createArea(composite);
        Label seperator = new Label(composite, 258);
        seperator.setLayoutData((Object)new GridData(768));
        this.checkedMappings = this.mappingArea.getCheckedMappings();
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        if (this.resourceArea == null) {
            ResourceMapping selectedMapping = this.getSelectedMapping();
            this.resourceArea = new ResourceMappingResourceDisplayArea(selectedMapping, this.getResourceListMessage(selectedMapping), this.filter);
        }
        Composite c = this.createComposite(parent);
        this.resourceArea.createArea(c);
        return c;
    }

    private ResourceMapping getSelectedMapping() {
        if (this.mappingArea != null) {
            return this.mappingArea.getSelectedMapping();
        }
        if (this.mappings.length == 1) {
            return this.mappings[0];
        }
        return null;
    }

    protected void updateEnablements() {
        this.setPageComplete(true);
    }

    protected boolean includeErrorMessage() {
        return false;
    }

    protected boolean includeOkButton() {
        return this.mappings.length != 1;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.mappings.length == 1) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int id) {
        if (2 == id) {
            this.checkedMappings = this.mappings;
            super.buttonPressed(0);
        } else if (3 == id) {
            this.checkedMappings = new ResourceMapping[0];
            super.buttonPressed(0);
        } else {
            super.buttonPressed(id);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("SelectedMapping")) {
            if (this.resourceArea != null) {
                ResourceMapping selectedMapping = this.getSelectedMapping();
                this.resourceArea.setMapping(selectedMapping, this.getResourceListMessage(selectedMapping));
            }
        } else if (event.getProperty().equals("CheckedMappings")) {
            this.checkedMappings = this.mappingArea.getCheckedMappings();
            this.updateEnablements();
        }
    }

    protected abstract String getSingleMappingMessage(ResourceMapping var1);

    protected abstract String getMultipleMappingsMessage();

    protected abstract String getResourceListMessage(ResourceMapping var1);

    public final ResourceMapping[] getMappings() {
        return this.mappings;
    }

    protected final ResourceMapping[] getCheckedMappings() {
        return this.checkedMappings;
    }
}

