/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshSubscriberJob;
import org.eclipse.team.internal.ui.synchronize.RefreshUserNotificationPolicy;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;

public class SubscriberRefreshSchedule {
    private long refreshInterval = 3600L;
    private boolean enabled = false;
    private RefreshSubscriberJob job;
    private SubscriberParticipant participant;
    private IRefreshEvent lastRefreshEvent;
    private static final String CTX_REFRESHSCHEDULE_INTERVAL = "org.eclipse.team.ui.CTX_REFRESHSCHEDULE_INTERVAL";
    private static final String CTX_REFRESHSCHEDULE_ENABLED = "org.eclipse.team.ui.CTX_REFRESHSCHEDULE_ENABLED";
    private IRefreshSubscriberListener refreshSubscriberListener = new IRefreshSubscriberListener(){

        public void refreshStarted(IRefreshEvent event) {
        }

        public ActionFactory.IWorkbenchAction refreshDone(IRefreshEvent event) {
            if (event.getSubscriber() == SubscriberRefreshSchedule.this.participant.getSubscriber()) {
                SubscriberRefreshSchedule.this.lastRefreshEvent = event;
                if (SubscriberRefreshSchedule.this.enabled && event.getRefreshType() == 1) {
                    RefreshUserNotificationPolicy policy = new RefreshUserNotificationPolicy(SubscriberRefreshSchedule.this.participant);
                    policy.refreshDone(event);
                }
            }
            return null;
        }
    };

    public SubscriberRefreshSchedule(SubscriberParticipant participant) {
        this.participant = participant;
        RefreshSubscriberJob.addRefreshListener(this.refreshSubscriberListener);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled, boolean allowedToStart) {
        boolean wasEnabled = this.isEnabled();
        this.enabled = enabled;
        if (enabled && !wasEnabled) {
            if (allowedToStart) {
                this.startJob();
            }
        } else {
            this.stopJob();
        }
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public SubscriberParticipant getParticipant() {
        return this.participant;
    }

    public void setRefreshInterval(long refreshInterval) {
        if (refreshInterval != this.getRefreshInterval()) {
            this.stopJob();
            this.refreshInterval = refreshInterval;
            if (this.isEnabled()) {
                this.startJob();
            }
        }
    }

    public void startJob() {
        SyncInfoTree set = this.participant.getSubscriberSyncInfoCollector().getSyncInfoSet();
        if (set == null) {
            return;
        }
        if (this.job == null) {
            SubscriberParticipant participant = this.getParticipant();
            this.job = new RefreshSubscriberJob(participant, TeamUIMessages.RefreshSchedule_14, NLS.bind((String)TeamUIMessages.RefreshSchedule_15, (Object[])new String[]{participant.getName(), this.getRefreshIntervalAsString()}), participant.getResources(), new RefreshUserNotificationPolicy(this.getParticipant()));
            this.job.setUser(false);
        } else if (this.job.getState() != 0) {
            this.stopJob();
        }
        this.job.setRefreshInterval(this.getRefreshInterval());
        this.job.setRestartOnCancel(true);
        this.job.setReschedule(true);
        this.job.schedule(this.getRefreshInterval() * 1000L);
    }

    protected void stopJob() {
        if (this.job != null) {
            this.job.setRestartOnCancel(false);
            this.job.setReschedule(false);
            this.job.cancel();
            this.job = null;
        }
    }

    public void dispose() {
        this.stopJob();
        RefreshSubscriberJob.removeRefreshListener(this.refreshSubscriberListener);
    }

    public void saveState(IMemento memento) {
        memento.putString(CTX_REFRESHSCHEDULE_ENABLED, Boolean.toString(this.enabled));
        memento.putInteger(CTX_REFRESHSCHEDULE_INTERVAL, (int)this.refreshInterval);
    }

    public static SubscriberRefreshSchedule init(IMemento memento, SubscriberParticipant participant) {
        SubscriberRefreshSchedule schedule = new SubscriberRefreshSchedule(participant);
        if (memento != null) {
            String enabled = memento.getString(CTX_REFRESHSCHEDULE_ENABLED);
            int interval = memento.getInteger(CTX_REFRESHSCHEDULE_INTERVAL);
            schedule.setRefreshInterval(interval);
            schedule.setEnabled("true".equals(enabled), false);
        }
        return schedule;
    }

    public static String refreshEventAsString(IRefreshEvent event) {
        if (event == null) {
            return TeamUIMessages.SyncViewPreferencePage_lastRefreshRunNever;
        }
        long stopMills = event.getStopTime();
        StringBuffer text = new StringBuffer();
        if (stopMills <= 0L) {
            text.append(TeamUIMessages.SyncViewPreferencePage_lastRefreshRunNever);
        } else {
            Date lastTimeRun = new Date(stopMills);
            text.append(DateFormat.getDateTimeInstance(3, 3).format(lastTimeRun));
        }
        SyncInfo[] changes = event.getChanges();
        if (changes.length == 0) {
            text.append(TeamUIMessages.RefreshSchedule_7);
        } else if (changes.length == 1) {
            text.append(NLS.bind((String)TeamUIMessages.RefreshSchedule_changesSingular, (Object[])new String[]{Integer.toString(changes.length)}));
        } else {
            text.append(NLS.bind((String)TeamUIMessages.RefreshSchedule_changesPlural, (Object[])new String[]{Integer.toString(changes.length)}));
        }
        return text.toString();
    }

    public IRefreshEvent getLastRefreshEvent() {
        return this.lastRefreshEvent;
    }

    private String getRefreshIntervalAsString() {
        long minutes;
        boolean hours = false;
        long seconds = this.getRefreshInterval();
        if (seconds <= 60L) {
            seconds = 60L;
        }
        if ((minutes = seconds / 60L) >= 60L) {
            minutes /= 60L;
            hours = true;
        }
        String unit = minutes >= 1L ? (hours ? TeamUIMessages.RefreshSchedule_9 : TeamUIMessages.RefreshSchedule_10) : (hours ? TeamUIMessages.RefreshSchedule_11 : TeamUIMessages.RefreshSchedule_12);
        return NLS.bind((String)TeamUIMessages.RefreshSchedule_13, (Object[])new String[]{Long.toString(minutes), unit});
    }
}

