/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.PlatformUI;

public class RemoveSynchronizeParticipantAction
extends Action {
    private final ISynchronizeView view;
    private boolean removeAll;

    public RemoveSynchronizeParticipantAction(ISynchronizeView view, boolean removeAll) {
        this.view = view;
        this.removeAll = removeAll;
        if (removeAll) {
            Utils.initAction((IAction)this, "action.removeAllPage.");
        } else {
            Utils.initAction((IAction)this, "action.removePage.");
        }
    }

    public void run() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (RemoveSynchronizeParticipantAction.this.removeAll) {
                        RemoveSynchronizeParticipantAction.this.removeAll();
                    } else {
                        RemoveSynchronizeParticipantAction.this.removeCurrent();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void removeCurrent() {
        ISynchronizeParticipant participant = this.view.getParticipant();
        if (participant != null) {
            if (participant.isPinned()) {
                final boolean[] bail = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        bail[0] = !MessageDialog.openQuestion((Shell)RemoveSynchronizeParticipantAction.this.view.getSite().getShell(), (String)TeamUIMessages.RemoveSynchronizeParticipantAction_0, (String)TeamUIMessages.RemoveSynchronizeParticipantAction_1);
                    }
                });
                if (bail[0]) {
                    return;
                }
            }
            TeamUI.getSynchronizeManager().removeSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        }
    }

    private void removeAll() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        ISynchronizeParticipantReference[] refs = manager.getSynchronizeParticipants();
        ArrayList<ISynchronizeParticipant> removals = new ArrayList<ISynchronizeParticipant>();
        int i = 0;
        while (i < refs.length) {
            ISynchronizeParticipantReference reference = refs[i];
            try {
                ISynchronizeParticipant p = reference.getParticipant();
                if (!p.isPinned()) {
                    removals.add(p);
                }
            }
            catch (TeamException teamException) {}
            ++i;
        }
        manager.removeSynchronizeParticipants(removals.toArray(new ISynchronizeParticipant[removals.size()]));
    }
}

