/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.actions.AbstractBreakpointRulerAction;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo info) {
        this.setInfo(info);
        this.setTextEditor(editor);
        this.setText(AntEditorActionMessages.getString("EnableDisableBreakpointRulerAction.0"));
    }

    public void run() {
        if (this.getBreakpoint() != null) {
            try {
                this.getBreakpoint().setEnabled(!this.getBreakpoint().isEnabled());
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getTextEditor().getEditorSite().getShell(), (String)AntEditorActionMessages.getString("EnableDisableBreakpointRulerAction.1"), (String)AntEditorActionMessages.getString("EnableDisableBreakpointRulerAction.2"), (IStatus)e.getStatus());
            }
        }
    }

    public void update() {
        this.setBreakpoint(this.determineBreakpoint());
        if (this.getBreakpoint() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            boolean enabled = this.getBreakpoint().isEnabled();
            this.setText(enabled ? AntEditorActionMessages.getString("EnableDisableBreakpointRulerAction.3") : AntEditorActionMessages.getString("EnableDisableBreakpointRulerAction.4"));
        }
        catch (CoreException ce) {
            AntUIPlugin.log(ce);
        }
    }
}

