/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SunJCE_am;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

public final class PBKDF2HmacSHA1Factory
extends SecretKeyFactorySpi {
    public PBKDF2HmacSHA1Factory() {
        if (!SunJCE.b(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
        return new SunJCE_am(pBEKeySpec, "HmacSHA1");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (secretKey instanceof PBEKey) {
            if (clazz != null && PBEKeySpec.class.isAssignableFrom(clazz)) {
                PBEKey pBEKey = (PBEKey)secretKey;
                return new PBEKeySpec(pBEKey.getPassword(), pBEKey.getSalt(), pBEKey.getIterationCount(), pBEKey.getEncoded().length * 8);
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("PBKDF2WithHmacSHA1") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
            if (secretKey instanceof SunJCE_am) {
                return secretKey;
            }
            if (secretKey instanceof PBEKey) {
                PBEKey pBEKey = (PBEKey)secretKey;
                try {
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(pBEKey.getPassword(), pBEKey.getSalt(), pBEKey.getIterationCount(), pBEKey.getEncoded().length * 8);
                    return new SunJCE_am(pBEKeySpec, "HmacSHA1");
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    InvalidKeyException invalidKeyException = new InvalidKeyException("Invalid key component(s)");
                    invalidKeyException.initCause(invalidKeySpecException);
                    throw invalidKeyException;
                }
            }
        }
        throw new InvalidKeyException("Invalid key format/algorithm");
    }
}

