/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sybase.connector.repra.util.RaConnection;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.repra.util.RaUtils;
import java.util.Properties;
import java.util.Vector;

public class RaClientUtil
implements RaUtils {
    private String _host = "localhost";
    private String _port = "8000";
    private String _user = "repraadmin";
    private String _password = null;
    private RaConnection _raConn = null;
    private boolean _verbose = false;

    public RaClientUtil(String string, String string2, String string3, String string4, String string5) {
        this.init(string, string2, string3, string4, string5, false);
    }

    public RaClientUtil(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.init(string, string2, string3, string4, string5, bl);
    }

    public RaClientUtil(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4, null, false);
    }

    public RaClientUtil(String string, String string2, String string3, String string4, boolean bl) {
        this.init(string, string2, string3, string4, null, bl);
    }

    private void init(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this._verbose = bl;
        if (this._verbose) {
            System.out.println("RaClientUtil[DEBUG]: host:" + string + ", port:" + string2 + ", user:" + string3 + ", password: " + string4 + ",servletName = " + string5 + ",verbose:" + bl);
        }
        if (this.isEmpty(string)) {
            this._host = string;
        }
        if (this.isEmpty(string2)) {
            this._port = string2;
        }
        if (this.isEmpty(string3)) {
            this._user = string3;
        }
        if (this.isEmpty(string4)) {
            this._password = string4;
        }
        this._raConn = new RaConnection(this._host, this._port, this._user, this._password, this._verbose);
        if (this.isEmpty(string5)) {
            this._raConn.setServletName(string5);
        }
    }

    private boolean isEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }

    public Vector startConnection() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[Info]: startConnection()");
        }
        Object object = null;
        this._raConn.setURI("command", 2);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (Vector)object;
    }

    public RaStatus startConnection(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: startConnection(): connName=" + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 1);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public Vector stopConnection() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: stopConnection()");
        }
        Object object = null;
        this._raConn.setURI("command", 4);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (Vector)object;
    }

    public RaStatus stopConnection(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: stopConnection(): connName=" + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 3);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public Vector refreshConnection() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: refreshConnection()");
        }
        Object object = null;
        this._raConn.setURI("command", 6);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (Vector)object;
    }

    public RaStatus refreshConnection(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: refreshConnection(): connName=" + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 5);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus createConnection(String string, Properties properties, boolean bl) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: createConnection(): connName=" + string + ", override = " + bl + "connProps = " + properties.toString());
        }
        Object object = null;
        if (properties == null || properties.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 7);
        if (string == null) {
            string = properties.getProperty("ConnectionName");
        }
        if (string != null) {
            this._raConn.setURI("connName", string);
        }
        if (bl) {
            this._raConn.setURI("override", String.valueOf(bl));
        }
        try {
            object = this._raConn.send(properties);
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public Vector deleteConnection() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: deleteConnection()");
        }
        Object object = null;
        this._raConn.setURI("command", 10);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (Vector)object;
    }

    public RaStatus deleteConnection(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: deleteConnection(): connName = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 9);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus copyConnection(String string, String string2) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: copyConnection(): connName = " + string + ", newConnName = " + string2);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        if (this.isNull(string2)) {
            throw new RaException("new Connection name is not valid.");
        }
        this._raConn.setURI("command", 12);
        this._raConn.setURI("connName", string);
        this._raConn.setURI("newConnName", string2);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus renameConnection(String string, String string2) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: renameConnection(): connName = " + string + ", newConnName = " + string2);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        if (this.isNull(string2)) {
            throw new RaException("new Connection name is not valid.");
        }
        this._raConn.setURI("command", 11);
        this._raConn.setURI("connName", string);
        this._raConn.setURI("newConnName", string2);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus validateConnection(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: validateConnection(): connName = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 13);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus validateConnection(String string, Properties properties) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: validateConnection(): connName = " + string + " connProps = " + properties.toString());
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        if (properties == null || properties.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 13);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send(properties);
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getConnections() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnections()");
        }
        Object object = null;
        this._raConn.setURI("command", 14);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getConnectionStatus() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionStatus()");
        }
        Object object = null;
        this._raConn.setURI("command", 16);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getConnectionStatus(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionStatus(): connName = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 15);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus isRunning(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: isRunning(): connName = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 27);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getConnectionProps(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionProps(): connName = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 18);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getConnectionPropValue(String string, String string2) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionPropValue(): connName = " + string + ", propName = " + string2);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        if (this.isNull(string2)) {
            throw new RaException("Property Key name is not specified.");
        }
        this._raConn.setURI("command", 19);
        this._raConn.setURI("connName", string);
        this._raConn.setURI("propName", string2);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus setConnectionPropValue(String string, String string2, String string3) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getConnectionPropValue(): connName = " + string + ", propName = " + string2 + ",propValue = " + string3);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        if (this.isNull(string2)) {
            throw new RaException("Property Key name is not specified.");
        }
        if (this.isNull(string3)) {
            throw new RaException("Property Value name is not specified.");
        }
        this._raConn.setURI("command", 20);
        this._raConn.setURI("connName", string);
        this._raConn.setURI("propName", string2);
        this._raConn.setURI("propValue", string3);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getInboundTypes() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getInboundTypes()");
        }
        Object object = null;
        this._raConn.setURI("command", 25);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getOutboundTypes() throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getOutboundTypes()");
        }
        Object object = null;
        this._raConn.setURI("command", 26);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getInboundTypes(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getInboundTypes(): outboundType = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Type is not specified.");
        }
        this._raConn.setURI("command", 25);
        this._raConn.setURI("OutboundType", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getOutboundTypes(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getOutboundTypes(): inboundType = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Type is not specified.");
        }
        this._raConn.setURI("command", 26);
        this._raConn.setURI("InboundType", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getGeneralParams(Properties properties) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getGeneralParams(): connProps = " + properties);
        }
        Object object = null;
        if (properties == null || properties.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 21);
        try {
            object = this._raConn.send(properties);
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getInboundParams(Properties properties) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getInboundParams(): connProps = " + properties);
        }
        Object object = null;
        if (properties == null || properties.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 22);
        try {
            object = this._raConn.send(properties);
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getOutboundParams(Properties properties) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getOutboundParams(): connProps = " + properties);
        }
        Object object = null;
        if (properties == null || properties.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 23);
        try {
            object = this._raConn.send(properties);
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getPluginParams(Properties properties) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getPluginParams(): connProps = " + properties);
        }
        Object object = null;
        if (properties == null || properties.isEmpty()) {
            throw new RaException("Connection Props is not specified.");
        }
        this._raConn.setURI("command", 24);
        try {
            object = this._raConn.send(properties);
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getLogInfo(String string) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getLogInfo(): connName = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 17);
        this._raConn.setURI("connName", string);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getLogInfo(String string, int n, int n2) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getLogInfo(): connName = " + string);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection name is not valid.");
        }
        this._raConn.setURI("command", 17);
        this._raConn.setURI("connName", string);
        this._raConn.setURI("sLine", n);
        this._raConn.setURI("eLine", n2);
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    public RaStatus getLogInfo(String string, int n) throws RaException {
        if (this._verbose) {
            System.out.println("RaClientUtil[INFO]: getLogInfo(): connName = " + string + ", size = " + n);
        }
        Object object = null;
        if (this.isNull(string)) {
            throw new RaException("Connection is not specified.");
        }
        if (n == 0 || n < -1) {
            // empty if block
        }
        this._raConn.setURI("command", 17);
        this._raConn.setURI("connName", string);
        this._raConn.setURI("size", String.valueOf(n));
        try {
            object = this._raConn.send();
        }
        catch (Exception exception) {
            throw new RaException(exception.getMessage());
        }
        return (RaStatus)object;
    }

    private boolean isNull(String string) {
        boolean bl = false;
        if (string == null || string.equals("")) {
            bl = true;
        }
        return bl;
    }

    public Vector ping(String string, String string2, Properties properties) throws RaException {
        Vector vector = new Vector();
        if (!this.isEmpty(string)) {
            throw new RaException("connname.null");
        }
        if (!this.isEmpty(string2)) {
            throw new RaException("sourcetype.null");
        }
        this._raConn.setURI("command", 29);
        this._raConn.setURI("connName", string);
        this._raConn.setURI("Source", string2);
        try {
            vector = properties != null ? (Vector)this._raConn.send(properties) : (Vector)this._raConn.send();
        }
        catch (Throwable throwable) {
            throw new RaException(throwable.getMessage());
        }
        return vector;
    }

    public Vector ping(String string, String string2) throws RaException {
        return this.ping(string, string2, null);
    }

    private void verbose(String string) {
        System.out.println("RaClientUtil[INFO]: " + string);
    }
}

