/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.actions.DeleteAction;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.model.ProfileElement;
import com.sybase.connector.ui.persistance.Profile;
import com.sybase.connector.ui.view.ConnectionView;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DeleteConnAction
extends DeleteAction {
    public DeleteConnAction(String string) {
        super(string);
    }

    public DeleteConnAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
    }

    public void doRun(IStructuredSelection iStructuredSelection) {
        Cursor cursor = new Cursor(null, 1);
        Control control = this.getViewer().getControl();
        try {
            if (MessageDialog.openConfirm((Shell)this.getView().getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("action.delete.connection.confirm.dialog"), (String)this.getResourceString("action.delete.connection.confirm.msg"))) {
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    control.setCursor(cursor);
                    ConnectionElement connectionElement = (ConnectionElement)iterator.next();
                    ProfileElement profileElement = connectionElement.getParent();
                    Profile profile = profileElement.getLoginInfo();
                    RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
                    RaStatus raStatus = raClientUtil.deleteConnection(connectionElement.getName());
                    int n = raStatus.getCode();
                    if (n == 0 || n == 1) {
                        profileElement.remove(connectionElement);
                        continue;
                    }
                    throw new Exception(raStatus.getMessage());
                }
                this.getViewer().refresh();
            }
        }
        catch (Exception exception) {
            RepConnectorUIPlugin.log(exception);
            MultiStatus multiStatus = new MultiStatus(RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, this.getResourceString("DeleteConnAction.doRun.error.reason"), (Throwable)exception);
            String string = ((Object)((Object)this)).getClass().getName();
            multiStatus.add((IStatus)new Status(4, RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, exception.getMessage() + "  " + this.getResourceString("DeleteConnAction.doRun.error.guide"), (Throwable)exception));
            ErrorDialog.openError((Shell)this.mainView.getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("DeleteConnAction.doRun.error.title"), (String)this.getResourceString("DeleteConnAction.doRun.error.text"), (IStatus)multiStatus);
        }
        control.setCursor(null);
        cursor.dispose();
    }
}

